<?php
/**
 * External Links Controller for WordPress. Exclusively on Envato Market: http://codecanyon.net/user/42theme/portfolio?ref=42Theme
 * @encoding     UTF-8
 * @version      1.0.3
 * @copyright    Copyright (C) 2020 42Theme ( https://42theme.com ). All rights reserved.
 * @license      Envato License https://codecanyon.net/licenses/standard?ref=42theme
 * @author       Alexander Khmelnitskiy ( ak@42theme.com )
 * @support      support@42theme.com
 **/

namespace T42\Junction;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * SINGLETON: Class contain information about the envato item.
 *
 * @since 1.0.0
 * @author Alexandr Khmelnytsky (info@alexander.khmelnitskiy.ua)
 **/
final class EnvatoItem {

	/**
	 * URL to plugin documentation.
	 *
	 * @var string
	 * @since 1.0.0
	 **/
	public static $documentation_url = 'https://42theme.com/category/help-center/wordpress/junction/';

	/**
	 * Plugin changelog URL.
	 *
	 * @var string
	 * @since 1.0.0
	 **/
	public static $changelog_url = 'https://42theme.com/help-center/wordpress/junction/changelog-junction-plugin-for-wordpress/';

	/**
	 * The one true EnvatoItem.
	 *
	 * @var EnvatoItem
	 * @since 1.0.0
	 **/
	private static $instance;

	/**
	 * Return CodeCanyon Item URL.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string
	 **/
	public function get_url() {

		return 'https://codecanyon.net/item/junction-external-links-controller-for-wordpress/25599204';

	}

	/**
	 * Return CodeCanyon Item ID.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string
	 **/
	public function get_id() {

		/** Do we have stored Envato ID? */
		$item_id = get_option( 't42_junction_envato_id' );

		/** If we have stored Envato ID, return it. */
		if ( $item_id ) {
			return $item_id;
		}

		/** Else get id from our server. */
		$item_id = $this->get_remote_plugin_id();

		/** Store local option if this is real item ID. */
		if ( (int)$item_id > 0 ) {
			update_option( 't42_junction_envato_id', $item_id );
		}

		return (string)$item_id;
	}

	/**
	 * Return CodeCanyon Plugin ID from out server.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	private function get_remote_plugin_id() {

		/** Get Plugin name. */
		if ( ! function_exists('get_plugin_data') ) {
			require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		}

		$plugin_data = get_plugin_data( WP_PLUGIN_DIR . '/t42-junction/t42-junction.php' );
		$plugin_name = $plugin_data['Name'];

		/** Build URL. */
		$url = 'https://updates.42theme.com/wp-content/plugins/t42-purchase-validator/src/GetMyId.php';
		$url .= '?plugin_name=' . urlencode($plugin_name);

		/** Suppress warning, if file not exist. */
		$context = stream_context_create( ['http' => ['ignore_errors' => true] ] );
		$plugin_id = file_get_contents( $url, false, $context );

		/** We don't have plugin ID. */
		if ( false === $plugin_id ) { return '0'; }

		$plugin_id = json_decode( $plugin_id );

		/** Wrong JSON. */
		if ( null === $plugin_id ) { return '0'; }

		return $plugin_id;
	}

	/**
	 * Main EnvatoItem Instance.
	 *
	 * Insures that only one instance of EnvatoItem exists in memory at any one time.
	 *
	 * @static
	 * @return EnvatoItem
	 * @since 1.0.0
	 **/
	public static function get_instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof EnvatoItem ) ) {
			self::$instance = new EnvatoItem;
		}

		return self::$instance;
	}

} // End Class EnvatoItem.
