<?php
/**
 * External Links Controller for WordPress. Exclusively on Envato Market: http://codecanyon.net/user/42theme/portfolio?ref=42Theme
 * @encoding     UTF-8
 * @version      1.0.3
 * @copyright    Copyright (C) 2020 42Theme ( https://42theme.com ). All rights reserved.
 * @license      Envato License https://codecanyon.net/licenses/standard?ref=42theme
 * @author       Alexander Khmelnitskiy ( ak@42theme.com )
 * @support      support@42theme.com
 **/

namespace T42\Junction;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * SINGLETON: Class used to implement admin messages queue.
 *
 * @since 1.0.0
 * @author Alexandr Khmelnytsky (info@alexander.khmelnitskiy.ua)
 **/
final class MessageHelper {

	/**
	 * The one true MessageHelper.
	 *
	 * @var MessageHelper
	 * @since 1.0.0
	 **/
	private static $instance;


	/**
	 * Get all admin messages.
	 *
	 * @access public
	 * @since 1.0.0
	 * @return false|array - Messages
	 **/
	public function get_messages() {

		$messages = get_option( 't42_junction_messages' );

		if ( ! $messages ) {
			$messages = [];
		}

		return $messages;


	}

	/**
	 * Add new message to messages.
	 *
	 * @param $message array - New Message,
	 *
	 * @access public
	 * @since 1.0.0
	 * @return void
	 **/
	public function add_message( $message ) {

		$messages = $this->get_messages();

		$messages[] = $message;

		update_option( 't42_junction_messages', $messages );

	}

	/**
	 * Remove all messages from the queue.
	 *
	 * @access public
	 * @since 1.0.0
	 * @return void
	 **/
	public function clear_messages() {

		delete_option( 't42_junction_messages' );

	}

	/**
	 * Main MessageHelper Instance.
	 *
	 * Insures that only one instance of MessageHelper exists in memory at any one time.
	 *
	 * @static
	 * @return MessageHelper
	 * @since 1.0.0
	 **/
	public static function get_instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Helper ) ) {
			self::$instance = new MessageHelper;
		}

		return self::$instance;
	}

} // End Class MessageHelper.
