<?php
/**
 * External Links Controller for WordPress. Exclusively on Envato Market: http://codecanyon.net/user/42theme/portfolio?ref=42Theme
 * @encoding     UTF-8
 * @version      1.0.3
 * @copyright    Copyright (C) 2020 42Theme ( https://42theme.com ). All rights reserved.
 * @license      Envato License https://codecanyon.net/licenses/standard?ref=42theme
 * @author       Alexander Khmelnitskiy ( ak@42theme.com )
 * @support      support@42theme.com
 **/

namespace T42\Junction;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * SINGLETON: Class used to render settings fields.
 *
 * @since 1.0.0
 * @author Alexander Khmelnitskiy ( ak@42theme.com )
 **/
final class SettingsFields {

	/**
	 * The one true SettingsFields.
	 *
	 * @var SettingsFields
	 * @since 1.0.0
	 **/
	private static $instance;

	/**
	 * Render "Delete Plugin" field.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	public function field_delete_plugin() {

		/** Get plugins settings. */
		$delete_plugin = Settings::get_instance()->options['delete_plugin'];

		$options = [
			'plugin' => esc_html__( 'Delete plugin only', 't42-junction' ),
			'plugin+settings' => esc_html__( 'Delete plugin and settings', 't42-junction' ),
		];

		/** Prepare description. */
		$helper_text = esc_html__( 'Choose which data to delete upon using the "Delete" action in the "Plugins" admin page.', 't42-junction' );

		/** Render select. */
		SettingsUI::get_instance()->render_select(
			$options,
			$delete_plugin, // Selected option.
			esc_html__('Delete plugin', 't42-junction' ),
			$helper_text,
			['name' => 't42_junction_settings[delete_plugin]']
		);

	}

	/**
	 * Render target="_blank" field.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	public function target_blank() {

		$name = 't42_junction_settings[target_blank]';
		$label = esc_html__( 'Open in New Tabs', 't42-junction' );
		$class = 't42-junction-target-blank';
		$checked = checked( filter_var( Settings::get_instance()->options['target_blank'], FILTER_VALIDATE_BOOLEAN ), true, false );
		$desc = esc_html__( 'Because outbound links deliberately send people away from your site.', 't42-junction' );

		SettingsUI::get_instance()->render_checkbox( $name, $label, $checked, $class, $desc );

	}

	/**
	 * Render rel="noopener" field.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	public function noopener() {

		$name = 't42_junction_settings[noopener]';
		$label = esc_html__( 'Add rel="noopener"', 't42-junction' );
		$class = 't42-junction-noopener';
		$checked = checked( filter_var( Settings::get_instance()->options['noopener'], FILTER_VALIDATE_BOOLEAN ), true, false );
		$desc = esc_html__( 'rel="noopener" prevents the new page from being able to access the window.opener property and ensures it runs in a separate process.', 't42-junction' );

		SettingsUI::get_instance()->render_checkbox( $name, $label, $checked, $class, $desc );

	}

	/**
	 * Render rel="noreferrer" field.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	public function noreferrer() {

		$name = 't42_junction_settings[noreferrer]';
		$label = esc_html__( 'Add rel="noreferrer"', 't42-junction' );
		$class = 't42-junction-noreferrer';
		$checked = checked( filter_var( Settings::get_instance()->options['noreferrer'], FILTER_VALIDATE_BOOLEAN ), true, false );
		$desc = esc_html__( 'Same as the previous setting and also prevents the Referer header from being sent to the new page.', 't42-junction' );

		SettingsUI::get_instance()->render_checkbox( $name, $label, $checked, $class, $desc );

	}

	/**
	 * Render rel="nofollow" field.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	public function nofollow() {

		$name = 't42_junction_settings[nofollow]';
		$label = esc_html__( 'Add rel="nofollow"', 't42-junction' );
		$class = 't42-junction-nofollow';
		$checked = checked( filter_var( Settings::get_instance()->options['nofollow'], FILTER_VALIDATE_BOOLEAN ), true, false );
		$desc = esc_html__( 'rel="nofollow" tells search engines not to follow links and do not associate your site with the linked page.', 't42-junction' );

		SettingsUI::get_instance()->render_checkbox( $name, $label, $checked, $class, $desc );

	}

	/**
	 * Render rel="dofollow" field.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	public function dofollow() {

		$name = 't42_junction_settings[dofollow]';
		$label = esc_html__( 'Add rel="dofollow"', 't42-junction' );
		$class = 't42-junction-dofollow';
		$checked = checked( filter_var( Settings::get_instance()->options['dofollow'], FILTER_VALIDATE_BOOLEAN ), true, false );
		$desc = esc_html__( 'rel="dofollow" links pass on ranking power from your website to the targeted page. Be careful, it is better to set this parameter manually individually for each link.', 't42-junction' );

		SettingsUI::get_instance()->render_checkbox( $name, $label, $checked, $class, $desc );

	}

	/**
	 * Render skip field.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	public function skip() {

		?>
		<div class="t42-form-row">
			<label class="t42-form-label"><?php esc_html_e( 'Skip Links', 't42-junction' ); ?></label>

			<div class="t42-form-controls t42-junction-skip">
				<textarea class="t42-junction-skip" name="t42_junction_settings[skip]" placeholder="http://example.com/"><?php echo esc_textarea( Settings::get_instance()->options['skip'] ); ?></textarea>
				<span class="t42-form-help-inline t42-large">
					<i class="t42-icon-question-circle-o"></i>
					<?php esc_html_e( 'Enter (part of) the URLs to match. Use a new line for each different match.', 't42-junction' ); ?>
				</span>
			</div>
		</div>
		<?php

	}

	/**
	 * Main SettingsFields Instance.
	 *
	 * Insures that only one instance of SettingsFields exists in memory at any one time.
	 *
	 * @static
	 * @return SettingsFields
	 * @since 1.0.0
	 **/
	public static function get_instance() {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof SettingsFields ) ) {
			self::$instance = new SettingsFields();
		}

		return self::$instance;

	}

} // End Class SettingsFields.

