<?php
/**
 * External Links Controller for WordPress. Exclusively on Envato Market: http://codecanyon.net/user/42theme/portfolio?ref=42Theme
 * @encoding     UTF-8
 * @version      1.0.3
 * @copyright    Copyright (C) 2020 42Theme ( https://42theme.com ). All rights reserved.
 * @license      Envato License https://codecanyon.net/licenses/standard?ref=42theme
 * @author       Alexander Khmelnitskiy ( ak@42theme.com )
 * @support      support@42theme.com
 **/

namespace T42\Junction;

use T42\Junction as Junction;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * SINGLETON: Class used to implement TabStatus tab on plugin settings page.
 *
 * @since 1.0.0
 * @author Alexandr Khmelnytsky (info@alexander.khmelnitskiy.ua)
 **/
final class TabStatus {

	/**
	 * The one true TabStatus.
	 *
	 * @var TabStatus
	 * @since 1.0.0
	 **/
	private static $instance;

	/**
	 * Sets up a new TabStatus instance.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	private function __construct() {

	}

	/**
	 * Render "System Requirements" field.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	public function render_system_requirements() {

	    $reports = [
            'server' => ReporterServer::get_instance(),
            'wordpress' => ReporterWordPress::get_instance(),
        ]
		?>

		<div class="t42-system-requirements">

			<?php foreach ( $reports as $key => $report ) : ?>
                <div class="t42-plugin-<?php echo esc_attr( $key ); ?>">
                    <div class="t42-overflow-container">
                        <table class="t42-system-requirements-table t42-table t42-table-hover t42-table-striped">
                            <thead>
                                <tr>
                                    <th colspan="3"><h3><?php echo esc_html( $report->get_title() ); ?></h3></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach ( $report->get_report() as $row ) : ?>
                                <tr>
                                    <td class="t42-row-label"><?php echo esc_html( $row['label'] ); ?>:</td>
                                    <td><span class="t42-system-value"><?php echo wp_kses_post( $row['value'] ); ?></span></td>
                                    <td class="t42-text-left">
                                        <?php if ( isset( $row['warning'] ) AND $row['warning'] ) : ?>
                                            <i class="t42-icon-warning"></i>
                                            <?php echo ( isset( $row['recommendation'] ) ? esc_html( $row['recommendation'] ) : ''); ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endforeach; ?>

		</div><?php

	}

	/**
	 * Render Privacy Notice.
	 *
	 * @since 1.0.0
	 * @access public
	 **/
	public function render_privacy_notice() {
	    ?>
        <div class="t42-alert">
	        <?php esc_html_e( 'Some data will be sent to our server to verify purchase and to ensure that a plugin is compatible with your install. We will never collect any confidential data. All data is stored anonymously.', 't42-junction' ); ?>
        </div>
        <?php
    }

	/**
	 * Main TabStatus Instance.
	 *
	 * Insures that only one instance of TabStatus exists in memory at any one time.
	 *
	 * @static
	 * @return TabStatus
	 * @since 1.0.0
	 **/
	public static function get_instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof TabStatus ) ) {
			self::$instance = new TabStatus;
		}

		return self::$instance;
	}

} // End Class TabStatus.
