<?php
/**
 * External Links Controller for WordPress. Exclusively on Envato Market: http://codecanyon.net/user/42theme/portfolio?ref=42Theme
 * @encoding     UTF-8
 * @version      1.0.3
 * @copyright    Copyright (C) 2020 42Theme ( https://42theme.com ). All rights reserved.
 * @license      Envato License https://codecanyon.net/licenses/standard?ref=42theme
 * @author       Alexander Khmelnitskiy ( ak@42theme.com )
 * @support      support@42theme.com
 **/

/** Register 42Theme Autoloader. */
spl_autoload_register( static function ( $class ) {

    $namespace = 'T42\\';

    /** Bail if the class is not in our namespace. */
    if ( 0 !== strpos( $class, $namespace ) ) { return; }

    /** Brevity is the soul of wit. */
    $DS = DIRECTORY_SEPARATOR;

    /** Build the filename. */
    $file = realpath( __DIR__ );
    $file .= $DS . substr( strrchr( $class, '\\' ), 1 ) . '.php';

    /** If the file exists for the class name, load it. */
    if ( file_exists( $file ) ) {

        /** @noinspection PhpIncludeInspection */
        include_once( $file );

    }

} );