<?php

namespace WPFEPP\Element_Containers;

if ( ! defined( 'WPINC' ) ) {
	die;
}

use WPFEPP\Constants\Email_Placeholders;
use WPFEPP\Constants\Email_Settings;
use WPGurus\Forms\Constants\Elements;
use WPGurus\Forms\Element;
use WPGurus\Forms\Elements\Select;
use WPGurus\Forms\Factories\Element_Factory;
use WPGurus\Forms\Sanitizers\Strip_HTML;

class Email_Settings_Container extends Backend_Element_Container {
	public function __construct( $current_values = array() ) {
		parent::__construct( $current_values );

		$this->build_form_elements();
	}

	private function build_form_elements() {
		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXT,
				array(
					Element::KEY        => Email_Settings::SETTING_SENDER_NAME,
					Element::LABEL      => __( 'Sender Name', 'frontend-publishing-pro' ),
					Element::POSTFIX    => __( 'This name will be used as the sender name in notification emails.', 'frontend-publishing-pro' ),
					Element::SANITIZERS => array(
						new Strip_HTML(),
					),
				)
			),
			Email_Settings::SETTING_SENDER_NAME
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXT,
				array(
					Element::KEY        => Email_Settings::SETTING_SENDER_ADDRESS,
					Element::LABEL      => __( 'Sender Address', 'frontend-publishing-pro' ),
					Element::POSTFIX    => __( 'Emails will be sent from this address.', 'frontend-publishing-pro' ),
					Element::SANITIZERS => array(
						new Strip_HTML(),
					),
				)
			),
			Email_Settings::SETTING_SENDER_ADDRESS
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::SELECT,
				array(
					Element::KEY     => Email_Settings::SETTING_EMAIL_FORMAT,
					Element::LABEL   => __( 'Email Format', 'frontend-publishing-pro' ),
					Element::POSTFIX => __( 'In which format would you like to send the emails.', 'frontend-publishing-pro' ),
					Element::VALUE   => 'plain',
					Select::CHOICES  => array(
						'plain' => __( 'Plain Text', 'frontend-publishing-pro' ),
						'html'  => __( 'HTML', 'frontend-publishing-pro' ),
					),
				)
			),
			Email_Settings::SETTING_EMAIL_FORMAT
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::CHECKBOX,
				array(
					Element::KEY     => Email_Settings::SETTING_USER_EMAILS,
					Element::LABEL   => __( 'Enable', 'frontend-publishing-pro' ),
					Element::POSTFIX => __( 'Send thank you email to author on post submission?', 'frontend-publishing-pro' ),
					Element::VALUE   => true,
				)
			),
			Email_Settings::SETTING_USER_EMAILS
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXT,
				array(
					Element::KEY   => Email_Settings::SETTING_USER_EMAIL_SUBJECT,
					Element::LABEL => __( 'Email Subject', 'frontend-publishing-pro' ),
					Element::VALUE => __( 'Thank you for your contribution', 'frontend-publishing-pro' ),
				)
			),
			Email_Settings::SETTING_USER_EMAIL_SUBJECT
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXTAREA,
				array(
					Element::KEY        => Email_Settings::SETTING_USER_EMAIL_CONTENT,
					Element::LABEL      => __( 'Email Content', 'frontend-publishing-pro' ),
					Element::VALUE      => sprintf( __( "Hi %s,\n\nThank you for submitting the article '%s' at our website %s. It has been added to the queue and will be published shortly.\n\nRegards,\n%s\n%s", 'frontend-publishing-pro' ), "%%AUTHOR_NAME%%", "%%POST_TITLE%%", "%%SITE_NAME%%", "%%ADMIN_NAME%%", "%%SITE_URL%%" ),
					Element::ATTRIBUTES => array(
						Element::HTML_ATTR_CLASS => 'large-textarea',
					),
				)
			),
			Email_Settings::SETTING_USER_EMAIL_CONTENT
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::CHECKBOX,
				array(
					Element::KEY     => Email_Settings::SETTING_ADMIN_EMAILS,
					Element::LABEL   => __( 'Enable', 'frontend-publishing-pro' ),
					Element::POSTFIX => __( 'Send email to admin on post submission?', 'frontend-publishing-pro' ),
					Element::VALUE   => true,
				)
			),
			Email_Settings::SETTING_ADMIN_EMAILS
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXT,
				array(
					Element::KEY   => Email_Settings::SETTING_ADMIN_EMAIL_SUBJECT,
					Element::LABEL => __( 'Email Subject', 'frontend-publishing-pro' ),
					Element::VALUE => sprintf( __( "A new article has been submitted on your website %s", 'frontend-publishing-pro' ), "%%SITE_NAME%%" ),
				)
			),
			Email_Settings::SETTING_ADMIN_EMAIL_SUBJECT
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXTAREA,
				array(
					Element::KEY        => Email_Settings::SETTING_ADMIN_EMAIL_CONTENT,
					Element::LABEL      => __( 'Email Content', 'frontend-publishing-pro' ),
					Element::VALUE      => sprintf( __( "Hi %s,\n\nA new article has been added to your website. You can view and edit all your articles here:\n\n%s\n\nRegards,\nYour web server", 'frontend-publishing-pro' ), "%%ADMIN_NAME%%", "%%EDIT_LINK%%" ),
					Element::ATTRIBUTES => array(
						Element::HTML_ATTR_CLASS => 'large-textarea',
					),
				)
			),
			Email_Settings::SETTING_ADMIN_EMAIL_CONTENT
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::CHECKBOX,
				array(
					Element::KEY     => Email_Settings::SETTING_USER_PENDING_TO_PUBLISH_EMAILS,
					Element::LABEL   => __( 'Enable', 'frontend-publishing-pro' ),
					Element::POSTFIX => __( 'Send email to author when their pending post is published?', 'frontend-publishing-pro' ),
					Element::VALUE   => true,
				)
			),
			Email_Settings::SETTING_USER_PENDING_TO_PUBLISH_EMAILS
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXT,
				array(
					Element::KEY   => Email_Settings::SETTING_USER_PENDING_TO_PUBLISH_EMAIL_SUBJECT,
					Element::LABEL => __( 'Email Subject', 'frontend-publishing-pro' ),
					Element::VALUE => sprintf( __( "Your article %s has been published on %s", 'frontend-publishing-pro' ), "%%POST_TITLE%%", "%%SITE_NAME%%" ),
				)
			),
			Email_Settings::SETTING_USER_PENDING_TO_PUBLISH_EMAIL_SUBJECT
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXTAREA,
				array(
					Element::KEY        => Email_Settings::SETTING_USER_PENDING_TO_PUBLISH_EMAIL_CONTENT,
					Element::LABEL      => __( 'Email Content', 'frontend-publishing-pro' ),
					Element::VALUE      => sprintf( __( "Hi %s,\n\nCongratulations! Your article '%s' has been published and is now live on %s.\n\nRegards,\n%s\n%s", 'frontend-publishing-pro' ), "%%AUTHOR_NAME%%", "%%POST_TITLE%%", "%%SITE_NAME%%", "%%ADMIN_NAME%%", "%%SITE_URL%%" ),
					Element::ATTRIBUTES => array(
						Element::HTML_ATTR_CLASS => 'large-textarea',
					),
				)
			),
			Email_Settings::SETTING_USER_PENDING_TO_PUBLISH_EMAIL_CONTENT
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::CHECKBOX,
				array(
					Element::KEY     => Email_Settings::SETTING_USER_PENDING_TO_DRAFT_EMAILS,
					Element::LABEL   => __( 'Enable', 'frontend-publishing-pro' ),
					Element::POSTFIX => __( 'Send email to author when their pending post is rejected (status changed to draft)?', 'frontend-publishing-pro' ),
					Element::VALUE   => true,
				)
			),
			Email_Settings::SETTING_USER_PENDING_TO_DRAFT_EMAILS
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXT,
				array(
					Element::KEY   => Email_Settings::SETTING_USER_PENDING_TO_DRAFT_EMAIL_SUBJECT,
					Element::LABEL => __( 'Email Subject', 'frontend-publishing-pro' ),
					Element::VALUE => sprintf( __( "Your article was rejected on %s", 'frontend-publishing-pro' ), "%%SITE_NAME%%" ),
				)
			),
			Email_Settings::SETTING_USER_PENDING_TO_DRAFT_EMAIL_SUBJECT
		);

		$this->add_element(
			Element_Factory::make_element(
				Elements::TEXTAREA,
				array(
					Element::KEY        => Email_Settings::SETTING_USER_PENDING_TO_DRAFT_EMAIL_CONTENT,
					Element::LABEL      => __( 'Email Content', 'frontend-publishing-pro' ),
					Element::VALUE      => sprintf( __( "Hi %s,\n\nWe're sorry to inform you that your article '%s' cannot be published on %s at this time, it has been moved back to the drafts section of your profile.\n\nRegards,\n%s\n%s", 'frontend-publishing-pro' ), "%%AUTHOR_NAME%%", "%%POST_TITLE%%", "%%SITE_NAME%%", "%%ADMIN_NAME%%", "%%SITE_URL%%" ),
					Element::ATTRIBUTES => array(
						Element::HTML_ATTR_CLASS => 'large-textarea',
					),
				)
			),
			Email_Settings::SETTING_USER_PENDING_TO_DRAFT_EMAIL_CONTENT
		);
	}

	function render() {
		$placeholder_string = $this->make_placeholder_string();
		$container_template = WPFEPP_ELEMENT_CONTAINER_TEMPLATES_DIR . 'email-settings.php';

		$general_elements = array();
		foreach (
			array(
				Email_Settings::SETTING_SENDER_NAME,
				Email_Settings::SETTING_SENDER_ADDRESS,
				Email_Settings::SETTING_EMAIL_FORMAT,
			) as $general_setting_key
		) {
			$general_elements[] = $this->get_element( $general_setting_key );
		}

		$groups = array(
			'user'                    => array( 'label' => esc_html__( 'To author on post submission', 'frontend-publishing-pro' ) ),
			'admin'                   => array( 'label' => esc_html__( 'To site admin on post submission', 'frontend-publishing-pro' ) ),
			'user_pending_to_publish' => array( 'label' => esc_html__( 'To author on post publication', 'frontend-publishing-pro' ) ),
			'user_pending_to_draft'   => array( 'label' => esc_html__( 'To author on post rejection', 'frontend-publishing-pro' ) ),
		);
		foreach ( array_keys( $groups ) as $prefix ) {
			$groups[ $prefix ]['settings'][] = $this->get_element( $prefix . '_emails' );
			$groups[ $prefix ]['settings'][] = $this->get_element( $prefix . '_email_subject' );
			$groups[ $prefix ]['settings'][] = $this->get_element( $prefix . '_email_content' );
		}
		?>

		<h2 class="title">
			<?php esc_html_e( 'Settings', 'frontend-publishing-pro' ); ?>
		</h2>

		<?php $this->render_template( $container_template, array(
			self::TEMP_ARG_ELEMENTS => $general_elements,
		) ); ?>

		<hr/>
		<h2 class="title">
			<?php esc_html_e( 'Emails', 'frontend-publishing-pro' ); ?>
		</h2>
		<p class="tab-description"><?php echo __( 'You can use the following placeholders in email subject and content: ', 'frontend-publishing-pro' ) . $placeholder_string; ?></p>

		<?php foreach ( $groups as $prefix => $group ) { ?>
			<div class="collapsable-box">
				<div class="collapsable-box-head">
					<strong><?php echo esc_html( $group['label'] ); ?></strong>
				</div>
				<div class="collapsable-box-body">
					<?php $this->render_template( $container_template, array(
						self::TEMP_ARG_ELEMENTS => $group['settings'],
					) ); ?>
				</div>
			</div>
		<?php }

		submit_button();
	}

	/**
	 * @return string
	 */
	private function make_placeholder_string() {
		$placeholders = array();
		foreach ( Email_Placeholders::values() as $placeholder ) {
			$placeholders[] = sprintf( '<span class="highlighted-text">%s</span>', $placeholder );
		}
		$placeholder_string = implode( ' ', $placeholders );
		return $placeholder_string;
	}
}