<?php
namespace Barn2\Plugin\Posts_Table_Pro;

use Barn2\Plugin\Posts_Table_Pro\Util\Util,
    Posts_Table_Args,
    Barn2\PTP_Lib\Service,
    Barn2\PTP_Lib\Registerable,
    Barn2\PTP_Lib\Conditional,
    Barn2\PTP_Lib\Util as Lib_Util;

/**
 * Responsible for registering the front-end styles and scripts in Posts Table Pro.
 *
 * @package   Barn2\posts-table-pro
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Frontend_Scripts implements Service, Registerable, Conditional {

    const SCRIPT_HANDLE  = 'posts-table-pro';
    const SCRIPT_VERSION = PLUGIN_VERSION;

    public function is_required() {
        return Lib_Util::is_front_end();
    }

    public function register() {
        // Register front-end styles and scripts
        add_action( 'wp_enqueue_scripts', [ self::class, 'register_styles' ] );
        add_action( 'wp_enqueue_scripts', [ self::class, 'register_scripts' ] );
    }

    public static function register_styles() {
        $suffix = Lib_Util::get_script_suffix();

        wp_register_style( 'photoswipe', Util::get_asset_url( 'js/photoswipe/photoswipe.min.css' ), [], '4.1.3' );
        wp_register_style( 'photoswipe-default-skin', Util::get_asset_url( 'js/photoswipe/default-skin/default-skin.min.css' ), [ 'photoswipe' ], '4.1.3' );
        wp_register_style( 'datatables', Util::get_asset_url( 'js/datatables/datatables.min.css' ), [], '1.10.21' );

        wp_register_style( self::SCRIPT_HANDLE, Util::get_asset_url( "css/posts-table-pro{$suffix}.css" ), [ 'datatables' ], self::SCRIPT_VERSION );
    }

    public static function register_scripts() {
        $suffix = Lib_Util::get_script_suffix();

        if ( apply_filters( 'posts_table_use_fitvids', true ) ) {
            wp_register_script( 'fitvids', Util::get_asset_url( "js/jquery-fitvids/jquery.fitvids{$suffix}.js" ), [ 'jquery' ], '1.1', true );
        }

        wp_register_script( 'datatables', Util::get_asset_url( "js/datatables/datatables{$suffix}.js" ), [ 'jquery' ], '1.10.21', true );
        wp_register_script( 'jquery-blockui', Util::get_asset_url( "js/jquery-blockui/jquery.blockUI{$suffix}.js" ), [ 'jquery' ], '2.70.0', true );
        wp_register_script( 'photoswipe', Util::get_asset_url( "js/photoswipe/photoswipe{$suffix}.js" ), [], '4.1.3', true );
        wp_register_script( 'photoswipe-ui-default', Util::get_asset_url( "js/photoswipe/photoswipe-ui-default{$suffix}.js" ), [ 'photoswipe' ], '4.1.3', true );

        wp_register_script( self::SCRIPT_HANDLE, Util::get_asset_url( "js/posts-table-pro{$suffix}.js" ), [ 'jquery', 'datatables', 'jquery-blockui' ], self::SCRIPT_VERSION, true );

        $script_params = array(
            'ajax_url'      => admin_url( 'admin-ajax.php' ),
            'ajax_nonce'    => wp_create_nonce( self::SCRIPT_HANDLE ),
            'wrapper_class' => esc_attr( Util::get_wrapper_class() ),
            'language'      => apply_filters( 'posts_table_language_defaults', array(
                'info'         => __( 'Showing _START_ to _END_ of _TOTAL_ entries', 'posts-table-pro' ),
                'infoEmpty'    => __( 'Showing 0 entries', 'posts-table-pro' ),
                'infoFiltered' => __( '(_MAX_ entries in total)', 'posts-table-pro' ),
                'lengthMenu'   => __( 'Show _MENU_ entries', 'posts-table-pro' ),
                'emptyTable'   => __( 'No data available in table.', 'posts-table-pro' ),
                'zeroRecords'  => __( 'No matching records found.', 'posts-table-pro' ),
                'search'       => apply_filters( 'posts_table_search_label', __( 'Search:', 'posts-table-pro' ) ),
                'paginate'     => array(
                    'first'    => __( 'First', 'posts-table-pro' ),
                    'last'     => __( 'Last', 'posts-table-pro' ),
                    'next'     => __( 'Next', 'posts-table-pro' ),
                    'previous' => __( 'Previous', 'posts-table-pro' ),
                ),
                'thousands'    => _x( ',', 'thousands separator', 'posts-table-pro' ),
                'decimal'      => _x( '.', 'decimal mark', 'posts-table-pro' ),
                'aria'         => array(
                    /* translators: ARIA text for sorting column in ascending order */
                    'sortAscending'  => __( ': activate to sort column ascending', 'posts-table-pro' ),
                    /* translators: ARIA text for sorting column in descending order */
                    'sortDescending' => __( ': activate to sort column descending', 'posts-table-pro' ),
                ),
                'filterBy'     => apply_filters( 'posts_table_filter_label', __( 'Filter:', 'posts-table-pro' ) ),
                'resetButton'  => apply_filters( 'posts_table_reset_button', __( 'Reset', 'posts-table-pro' ) )
            ) ),
        );

        wp_localize_script( self::SCRIPT_HANDLE, 'posts_table_params', apply_filters( 'posts_table_pro_script_params', $script_params ) );
    }

    public static function load_table_scripts( Posts_Table_Args $args = null ) {
        if ( ! apply_filters( 'posts_table_load_frontend_scripts', true ) ) {
            return;
        }

        wp_enqueue_style( self::SCRIPT_HANDLE );
        wp_enqueue_script( self::SCRIPT_HANDLE );

        if ( $args ) {
            if ( $args->shortcodes ) {
                // Add fitVids.js for responsive video if we're displaying shortcodes.
                if ( apply_filters( 'posts_table_use_fitvids', true ) ) {
                    wp_enqueue_script( 'fitvids' );
                }

                // Queue media element and playlist scripts/styles.
                wp_enqueue_style( 'wp-mediaelement' );
                wp_enqueue_script( 'wp-mediaelement' );
                wp_enqueue_script( 'wp-playlist' );

                add_action( 'wp_footer', 'wp_underscore_playlist_templates', 0 );
            }

            // Enqueue Photoswipe for image lightbox.
            if ( $args->lightbox ) {
                wp_enqueue_style( 'photoswipe-default-skin' );
                wp_enqueue_script( 'photoswipe-ui-default' );

                add_action( 'wp_footer', [ self::class, 'load_photoswipe_template' ] );
            }
        }
    }

    public static function load_photoswipe_template() {
        Util::include_template( 'photoswipe.php' );
    }

}
