<?php

// main MP3 Sticky Player plugin class
class FWDMSP
{
	// constants
	const MIN_WP_VER =  "3.5.0";
	const CAPABILITY = "edit_fwdmsp";
	const VERSION = '7.0';
	
	// variables
	private $_data;
	private $_dir_url;
    
    private static $_msp_id = 0;
    private static $_pl_id = 0;
    
    // constructor
   
    public function init(){
		$this->_dir_url = plugin_dir_url(dirname(__FILE__));
	
    	// set hooks
    	add_action("admin_menu", array($this, "add_plugin_menu"));
		add_shortcode("fwdmsp", array($this, "set_player"));
		add_action("wp_enqueue_scripts", array($this, "add_scripts_and_styles"));
		
		// set data
		$this->_data = new FWDMSPData();
		$this->_data->init();
    }
	
    // functions
    
    public function add_plugin_menu()
    {
    	// add menus
        add_menu_page("Player Title", "MP3 Sticky Player", FWDMSP::CAPABILITY, "FWDMSPMenu-General-Settings", array($this, "set_general_settings"), $this->_dir_url . "content/icons/menu-icon.png");
       	add_submenu_page("FWDMSPMenu-General-Settings", "General settings", "General settings", FWDMSP::CAPABILITY, "FWDMSPMenu-General-Settings");
       	add_submenu_page("FWDMSPMenu-General-Settings", "Playlists manager", "Playlists manager", FWDMSP::CAPABILITY, "FWDMSPMenu-Playlists-Manager", array($this, "set_playlists_manager"));
       	add_submenu_page("FWDMSPMenu-General-Settings", "CSS Editor", "CSS Editor", FWDMSP::CAPABILITY, "FWDMSPMenu-CSS-Editor", array($this, "set_css_editor"));
       	
       	// add meta boxes
       	$post_type_screens = array("post", "page");
       	$args = array(
	       'public'   => true,
	       '_builtin' => false,
	    );
       	$custom_post_types = get_post_types($args);
       	foreach ($custom_post_types as $screen){
       		$post_type_screens[] = $screen;
       	}

    	foreach ($post_type_screens as $screen){
       		add_meta_box("fwdmsp-shortcode-generator", "MP3 Sticky Player Shortcode Generator",  array($this, "set_custom_meta_box"), $screen, "side", "default");
    	}
    }
	
	public function add_scripts_and_styles($posts){
		global $post, $wpdb;
    	if(empty($post)) return;
		
		$shortcode_found = false;
       	if(has_shortcode($post->post_content, 'fwdmsp')){
          	$shortcode_found = true;
       	}else if(isset($post->ID)){ 
          	$result = $wpdb->get_var($wpdb->prepare(
            "SELECT count(*) FROM $wpdb->postmeta " .
            "WHERE post_id = %d and meta_value LIKE '%%fwdmsp%%'", $post->ID));
          	$shortcode_found = !empty($result);
       	}
       
		//if(!empty($shortcode_found)){
			wp_enqueue_style("fwdmsp_msp_css", $this->_dir_url . "css/fwdmsp.css", array(), FWDMSP::VERSION);
			wp_enqueue_script("fwdmsp_msp_script", $this->_dir_url . "js/FWDMSP.js", array(), FWDMSP::VERSION);
		//}		
		
		return $posts;
	}
    
	private function check_wp_ver(){
	    global $wp_version;
	    
		$exit_msg = "The MP3 Sticky Player plugin requires WordPress " . FWDMSP::MIN_WP_VER . " or newer. <a href='http://codex.wordpress.org/Updating_WordPress'>Please update!</a>";
		
		if (version_compare($wp_version, FWDMSP::MIN_WP_VER) <= 0){
			echo $exit_msg;
			
			return false;
		}
		
		return true;
	}
	
	public function is_user_logged_in() {
		$user = wp_get_current_user();
	 
		return $user->exists();
	}
	
    public function set_general_settings(){
    	if (!$this->check_wp_ver()){
    		return;
    	}
    	
    	$msg = "";
    	
    	$set_id = 0;
		$set_order_id = 0;
		$tab_init_id = 0;
    	
	    if (!empty($_POST) && check_admin_referer("fwdmsp_general_settings_update", "fwdmsp_general_settings_nonce")){
			$data_obj = json_decode(str_replace("\\", "", $_POST["settings_data"]), true);
			
			$action = $data_obj["action"];
			$settingsAr = $data_obj["settings_ar"];

			// validate input
			foreach($settingsAr as $key => $value) {	
				if(!empty($settingsAr[$key]["googleAnalyticsTrackingCode"])){
					$settingsAr[$key]["googleAnalyticsTrackingCode"] = sanitize_text_field($settingsAr[$key]["googleAnalyticsTrackingCode"]);
				}

				if(!empty($settingsAr[$key]["proxyCors"])){
					$settingsAr[$key]["proxyCors"] = sanitize_text_field($settingsAr[$key]["proxyCors"]);
				}
				
				if(!empty($settingsAr[$key]["privatePassword"])){
					$settingsAr[$key]["privatePassword"] = sanitize_text_field($settingsAr[$key]["privatePassword"]);
				}

				if(!empty($settingsAr[$key]["loggedInMessage"])){
					$settingsAr[$key]["loggedInMessage"] = esc_html($settingsAr[$key]["loggedInMessage"]);
				}

				if(!empty($settingsAr[$key]["ytbAPiKey"])){
					$settingsAr[$key]["ytbAPiKey"] = sanitize_text_field($settingsAr[$key]["ytbAPiKey"]);
				}

				if(!empty($settingsAr[$key]["soundCloudAPIKey"])){
					$settingsAr[$key]["soundCloudAPIKey"] = sanitize_text_field($settingsAr[$key]["soundCloudAPIKey"]);
				}		
			}

			$this->_data->settings_ar = $settingsAr;
			$this->_data->set_data();
			switch ($action){
			    case "add":
			        $msg = "<div class='fwd-updated'><p style='padding:8px;'>Your new preset has been added!</p></div>";
			        $set_id = $data_obj["set_id"];
					$set_order_id = $data_obj["set_order_id"];
					$tab_init_id = $data_obj["tab_init_id"];
			        break;
			    case "save":
			        $msg = "<div class='fwd-updated'><p style='padding:8px;'>Your preset settings have been updated!</p></div>";
			        $set_id = $data_obj["set_id"];
					$set_order_id = $data_obj["set_order_id"];
					$tab_init_id = $data_obj["tab_init_id"];
			        break;
			    case "del":
			       	$msg = "<div class='fwd-updated'><p style='padding:8px;'>Your preset has been deleted!</p></div>";
			        break;
			}
		}
		
		// jquery ui
		wp_enqueue_style("fwdmsp_fwd_ui_css", $this->_dir_url . "css/fwd_ui.css");
		wp_enqueue_script("jquery-ui-tabs");
		wp_enqueue_script("jquery-ui-tooltip");
		
		// spectrum colorpicker
    	wp_enqueue_style("fwdmsp_spectrum_css", $this->_dir_url . "css/spectrum.css");
    	wp_enqueue_script("fwdmsp_spectrum_script", $this->_dir_url . "js/spectrum.js");
    	
    	// general settings script
		wp_enqueue_media();
        wp_enqueue_script("fwdmsp_general_settings_script", $this->_dir_url . "js/general_settings.js", array(), FWDMSP::VERSION);
		
    	include_once "general_settings.php";
    }
    
 	public function set_playlists_manager(){
    	if (!$this->check_wp_ver()){
    		return;
    	}
    	
    	$msg = "";
    	
	    if (!empty($_POST) && check_admin_referer("fwdmsp_playlist_manager_update", "fwdmsp_playlist_manager_nonce")){
			$mainPlaylistsAr = json_decode(str_replace("\\", "", $_POST["playlist_data"]), true);
			
			$this->_data->main_playlists_ar = $mainPlaylistsAr;
			$this->_data->set_data();
			
			$msg = "<div class='fwd-updated'><p style='padding:8px;'>Your playlists have been updated!</p></div>";
		}
		
		// jquery ui
		wp_enqueue_style("fwdmsp_fwd_ui_css", $this->_dir_url . "css/fwd_ui.css");
		wp_enqueue_script("jquery-ui-sortable");
		wp_enqueue_script("jquery-ui-accordion");
		wp_enqueue_script("jquery-ui-dialog");
		wp_enqueue_script("jquery-ui-tooltip");
		
		// playlist manager script
		wp_enqueue_media();
        wp_enqueue_script("fwdmsp_playlist_manager_script", $this->_dir_url . "js/playlist_manager.js", array(), FWDMSP::VERSION);
        
    	include_once "playlist_manager.php";
    }
    
    public function set_css_editor(){
    	if (!$this->check_wp_ver()){
    		return;
    	}
    	
    	$msg = "";
    	$scroll_pos = 0;
    	
    	$css_file = plugin_dir_path(dirname(__FILE__)) . "css/fwdmsp.css";
    	
	    if (!empty($_POST) && check_admin_referer("fwdmsp_css_editor_update", "fwdmsp_css_editor_nonce")){
			$handle = fopen($css_file, "w") or die("Cannot open file: " . $css_file);
			
			$data = str_replace("\\", "", $_POST["css_data"]);
			$data = str_replace("'e", "'\\e", $data);
			
			fwrite($handle, $data);
			
			$msg = "<div class='fwd-updated'><p style='padding:8px;'>The CSS file has been updated!</p></div>";
		}
		
		wp_enqueue_style("fwdmsp_fwd_ui_css", $this->_dir_url . "css/fwd_ui.css", array(), FWDMSP::VERSION);
	  			
		$handle = fopen($css_file, "r") or die("Cannot open file: " . $css_file);
        
    	include_once "css_editor.php";
    	
    	fclose($handle);
    }
    
	public static function set_action_links($links){
		$settings_link = "<a href='" . get_admin_url(null, "admin.php?page=FWDMSPMenu-General-Settings") . "'>Settings</a>";
   		array_unshift($links, $settings_link);
   		
   		return $links;
	}
    
    public function get_constructor($sid, $pid){
    	$preset = NULL;
    	
    	foreach ($this->_data->settings_ar as $set){
    		if ($set["name"] == $sid){
    			$preset = $set;
    		}
    	}
    	
    	if (is_null($preset)){
    		return "Preset with id ". $sid . " does not exist!";
    	}
    	
    	$main_playlist = NULL;
    	
    	foreach ($this->_data->main_playlists_ar as $pl){
    		if ($pl["name"] == $pid){
    			$main_playlist = $pl;
    		}
    	}
		
    	 	
    	if (is_null($main_playlist)){
    		return "Main playlist with id ". $pid . " does not exist!";
    	}
		
		$isLoggedIn = $this->is_user_logged_in();
		if($preset['playIfLoggedIn'] == "yes" && $isLoggedIn) $preset['playIfLoggedIn'] = 'no';
		
		$preset['loggedInMessage'] = html_entity_decode($preset['loggedInMessage'], ENT_QUOTES);

    	return "<script type='text/javascript'>document.addEventListener('DOMContentLoaded', function(event) {FWDMSPUtils.checkIfHasTransofrms();new FWDMSP({" . "instanceName:'fwdmspPlayer" . FWDMSP::$_msp_id . "',playlistsId:'fwdmspMainPlaylist" . $pid . "',mainFolderPath:'" . $this->_dir_url . "content'," . "skinPath:'" . $preset['skin_path']. "',showMainScrubberAndVolumeScrubberToolTipLabel:'" . $preset['showMainScrubberAndVolumeScrubberToolTipLabel'] . "',scrubbersToolTipLabelBackgroundColor:'" . $preset['scrubbersToolTipLabelBackgroundColor'] . "',scrubbersToolTipLabelFontColor:'" . $preset['scrubbersToolTipLabelFontColor'] . "',atbTimeTextColorNormal:'" . $preset['atbTimeTextColorNormal']. "',atbTimeTextColorSelected:'" . $preset['atbTimeTextColorSelected']. "',atbButtonTextNormalColor:'" . $preset['atbButtonTextNormalColor']. "',atbButtonTextSelectedColor:'" . $preset['atbButtonTextSelectedColor']. "',atbButtonBackgroundNormalColor:'" . $preset['atbButtonBackgroundNormalColor']. "',atbButtonBackgroundSelectedColor:'" . $preset['atbButtonBackgroundSelectedColor'] . "',proxyCors:'" . $preset['proxyCors'] . "',youtubeAPIKey:'" . $preset['ytbAPiKey'] . "',showSoundCloudUserNameInTitle:'" . $preset['show_soundcloud_username_in_title'] . "',soundCloudAPIKey:'" . $preset['soundCloudAPIKey'] . "',googleAnalyticsTrackingCode:'" . $preset['googleAnalyticsTrackingCode'] . "',verticalPosition:'" . $preset['verticalPosition'] . "',horizontalPosition:'" . $preset['horizontalPosition'] . "',useYoutube:'" . $preset['use_youtube'] . "',useDeepLinking:'" . $preset['use_deeplinking'] . "',rightClickContextMenu:'" . $preset['right_click_context_menu'] . "',showButtonsToolTips:'" . $preset['show_buttons_tooltips'] . "',animate:'" . $preset['animate'] . "',autoPlay:'" . $preset['autoplay'] . "',startAtRandomTrack:'" . $preset['start_at_random_track'] . "',loop:'" . $preset['loop'] . "',shuffle:'" . $preset['shuffle'] . "',maxWidth:" . $preset['max_width'] . ",showMainBackground:'" . $preset['showMainBackground'] . "',useContinuousPlayback:'" . $preset['useContinuousPlayback'] . "',addKeyboardSupport:'" . $preset['addKeyboardSupport'] . "',playIfLoggedIn:'" .  $preset['playIfLoggedIn'] . "',playIfLoggedInMessage:\"" .  $preset['loggedInMessage'] . "\",volume:" . $preset['volume'] . ",useVideo:'" . $preset['use_video'] . "',showPlaybackRateButton:'" . $preset['showPlaybackRateButton'] . "',openPopupOnPlay:'" . $preset['openPopupOnPlay'] . "',defaultPlaybackRate:" . $preset['defaultPlaybackRate'] . ",playlistSelectorHeight:" . $preset['playlistSelectorHeight'] . ",playbackRateWindowTextColor:'" . $preset['playbackRateWindowTextColor'] . "',playTrackAfterPlaylistLoad:'" . $preset['playTrackAfterPlaylistLoad'] . "',showFullScreenButton:'" . $preset['show_full_screen_button'] . "',useHEXColorsForSkin:'" . $preset['use_HEX_colors_for_skin'] . "',normalHEXButtonsColor:'" . $preset['normal_HEX_buttons_color'] . "',normalHEXButtonsColor2:'" . $preset['normalHEXButtonsColor2'] . "',toolTipsButtonsHideDelay:" . $preset['tooltips_buttons_hide_delay']  . ",toolTipsButtonsBackgroundColor:'" . $preset['toolTipsButtonsBackgroundColor'] . "',toolTipsButtonFontColor:'" . $preset['tooltips_button_font_color'] . "'," . "showControllerByDefault:'" . $preset['show_controller_by_default'] . "',showThumbnail:'" . $preset['show_thumbnail'] . "',showNextAndPrevButtons:'" . $preset['show_next_and_prev_buttons'] . "',disableScrubber:'" . $preset['disable_scrubber']. "',showLoopButton:'" . $preset['show_loop_button'] . "',showShuffleButton:'" . $preset['show_shuffle_button'] . "',showDownloadMp3Button:'" . $preset['show_download_mp3_button'] . "',showShareButton:'" . $preset['show_share_button'] . "',showBuyButton:'" . $preset['show_buy_button'] . "',expandBackground:'" . $preset['expand_background'] . "',titleColor:'" . $preset['title_color'] . "',timeColor:'" . $preset['time_color'] . "'," . "controllerHeight:" . $preset['controller_height'] . ",startSpaceBetweenButtons:" . $preset['start_space_between_buttons'] . ",spaceBetweenButtons:" . $preset['space_between_buttons'] . ",separatorOffsetOutSpace:" . $preset['separator_offset_out_space'] . ",separatorOffsetInSpace:" . $preset['separator_offset_in_space'] . ",lastButtonsOffsetTop:" . $preset['last_buttons_offset_top'] . ",allButtonsOffsetTopAndBottom:" . $preset['all_buttons_offset_top_and_bottom'] . ",titleBarOffsetTop:" . $preset['title_bar_offset_top'] . ",mainScrubberOffsetTop:" . $preset['main_scrubber_offset_top'] . ",spaceBetweenMainScrubberAndTime:" . $preset['space_between_main_scrubber_and_time'] . ",startTimeSpace:" . $preset['start_time_space'] . ",scrubbersOffsetWidth:" . $preset['scrubbers_offset_width'] . ",scrubbersOffestTotalWidth:" . $preset['scrubbers_offset_total_width'] . ",volumeButtonAndScrubberOffsetTop:" . $preset['volume_button_and_scrubber_offset_top'] . ",spaceBetweenVolumeButtonAndScrubber:" . $preset['space_between_volume_button_and_scrubber'] . ",volumeScrubberOffestWidth:" . $preset['volume_scrubber_offset_width'] . ",scrubberOffsetBottom:" . $preset['scrubber_offset_bottom'] . ",playbackRateButtonsMargins:" . $preset['playbackRateButtonsMargins'] . "," . "showPlaylistsButtonAndPlaylists:'" . $preset['show_playlists_button_and_playlists'] . "',showPlaylistsSearchInput:'" . $preset['showPlaylistsSearchInput'] . "',usePlaylistsSelectBox:'" . $preset['usePlaylistsSelectBox'] . "',randomizePlaylist:'" . $preset['randomizePlaylist'] . "',mainSelectorBackgroundSelectedColor:'" . $preset['mainSelectorBackgroundSelectedColor'] . "',mainSelectorTextNormalColor:'" . $preset['mainSelectorTextNormalColor'] . "',mainSelectorTextSelectedColor:'" . $preset['mainSelectorTextSelectedColor'] . "',mainButtonTextNormalColor:'" . $preset['mainButtonTextNormalColor'] . "',mainButtonTextSelectedColor:'" . $preset['mainButtonTextSelectedColor'] . "',showPlaylistsSelectBoxNumbers:'" . $preset['showPlaylistsSelectBoxNumbers'] . "',showPlaylistsByDefault:'" . $preset['show_playlists_by_default'] . "',thumbnailSelectedType:'" . $preset['thumbnail_selected_type'] . "',startAtPlaylist:" . $preset['start_at_playlist'] . ",startAtTrack:" . $preset['start_at_track'] . ",buttonsMargins:" . $preset['buttons_margins'] . ",thumbnailMaxWidth:" . $preset['thumbnail_max_width'] . ",thumbnailMaxHeight:" . $preset['thumbnail_max_height'] . ",horizontalSpaceBetweenThumbnails:" . $preset['horizontal_space_between_thumbnails'] . ",verticalSpaceBetweenThumbnails:" . $preset['vertical_space_between_thumbnails'] . "," . "showPlayListButtonAndPlaylist:'" . $preset['show_playlist_button_and_playlist'] . "',showPlayListOnMobile:'" . $preset['showPlayListOnMobile'] . "',showPlayListByDefault:'" . $preset['show_playlist_by_default'] . "',showPlaylistItemPlayButton:'" . $preset['show_playlist_item_play_button'] . "',showPlaylistItemDownloadButton:'" . $preset['show_playlist_item_download_button'] . "',showPlaylistItemBuyButton:'" . $preset['show_playlist_item_buy_button'] . "',forceDisableDownloadButtonForPodcast:'" . $preset['force_disable_download_button_for_podcast'] . "',forceDisableDownloadButtonForOfficialFM:'" . $preset['force_disable_download_button_for_official_fm'] . "',forceDisableDownloadButtonForFolder:'" . $preset['force_disable_download_button_for_folder'] . "',addScrollBarMouseWheelSupport:'" . $preset['add_scrollbar_mouse_wheel_support'] . "',showTracksNumbers:'" . $preset['show_tracks_numbers'] . "',playlistBackgroundColor:'" . $preset['playlist_background_color'] . "',trackTitleNormalColor:'" . $preset['track_title_normal_color'] . "',trackTitleSelectedColor:'" . $preset['track_title_selected_color'] . "',trackDurationColor:'" . $preset['track_duration_color'] . "',playlistItemHeight:" . $preset['playlistItemHeight'] . ",maxPlaylistItems:" . $preset['max_playlist_items'] . ",nrOfVisiblePlaylistItems:" . $preset['nr_of_visible_playlist_items'] . ",trackTitleOffsetLeft:" . $preset['track_title_offset_left'] . ",playPauseButtonOffsetLeftAndRight:" . $preset['play_pause_button_offset_left_and_right'] . ",durationOffsetRight:" . $preset['duration_offset_right'] . ",downloadButtonOffsetRight:" . $preset['download_button_offset_right'] . ",borderColor:'" . $preset['borderColor'] . "',secondaryLabelsColor:'" . $preset['secondaryLabelsColor'] . "',textColor:'" . $preset['textColor'] . "',inputBackgroundColor:'" . $preset['inputBackgroundColor'] . "',inputColor:'" . $preset['inputColor'] . "',privatePassword:'" .  md5($preset['privatePassword']) . "',scrollbarOffestWidth:" . $preset['scrollbar_offset_width'] . "," . "openerAlignment:'" . $preset['opener_alignment'] . "',showOpener:'" . $preset['show_opener'] . "',showOpenerPlayPauseButton:'" . $preset['show_opener_play_pause_button'] . "',openerEqulizerOffsetLeft:" . $preset['opener_equlizer_offset_left'] . ",openerEqulizerOffsetTop:" . $preset['opener_equlizer_offset_top'] . "," ."showPopupButton:'" . $preset['show_popup_button'] . "',popupWindowBackgroundColor:'" . $preset['popup_window_background_color'] . "',popupWindowWidth:" . $preset['popup_window_width'] . ",popupWindowHeight:" . $preset['popup_window_height'] . "," . "showSearchBar:'" . $preset['show_search_bar'] . "',showSortButtons:'" . $preset['show_sort_buttons'] . "',searchInputColor:'" . $preset['search_input_color'] . "',searchBarHeight:" . $preset['search_bar_height'] . ",inputSearchTextOffsetTop:" . $preset['input_search_text_offset_top'] . ",inputSearchOffsetLeft:" . $preset['input_search_offset_left'] . ",useVisualizer:'" . $preset['useVisualizer'] . "',visualizerRandomPreset:'" . $preset['visualizerRandomPreset']  . "',visualizerPreset:'"  . $preset['visualizerPreset'] .  "',visualizerColor:[" .  "'" . implode("','",array_reverse($preset['visualizerColor'])) . "'" . "],visualizerCapColor:'" . $preset['visualizerCapColor'] . "'})});</script>";
    }
    
    public function get_main_playlist($pid){
    	$main_playlist = NULL;
    	
    	foreach ($this->_data->main_playlists_ar as $pl){
    		if ($pl["name"] == $pid){
    			$main_playlist = $pl;
    		}
    	}
    	
    	if (is_null($main_playlist)){
    		return "Main playlist with id ". $pid . " does not exist!";
    	}
    	
    	$main_playlist_str = "<ul id='fwdmspMainPlaylist$pid' style='display:none;'>";
		$normal_playlist_str = "";
    	
    	foreach ($main_playlist["playlists"] as $playlist){
			if ($playlist["type"] == "normal"){
				$main_playlist_str .= "<li data-source='fwdmspPlaylist" . FWDMSP::$_pl_id . "' data-playlist-name='" . $playlist['name'] . "'";
				
				$normal_playlist_str .= "<ul id='fwdmspPlaylist" . FWDMSP::$_pl_id . "' style='display:none;'>";
				
				foreach ($playlist["tracks"] as $track){
					if($track['encrypt'] == "yes"){
						$source = "encrypt:" . base64_encode($track["audio"]);
					}else{
						$source = $track["audio"];
					}
				
					$normal_playlist_str .= "<li data-path='" . $source . "'";
					
					$trackType = NULL;
					if($track['type'] == "shoutcast"){
						$trackType = "shoutcast";
					}else if($track['type'] == "icecast"){
						$trackType = "icecast";
					}
					
					if (strlen($track["thumb"]) >= 1){
						$normal_playlist_str .= " data-thumbpath='" . $track["thumb"] . "'";
					}
					
					if(!is_null($trackType)){
						$normal_playlist_str .= " data-type='" . $trackType . "'";
					}
					
					if (strlen($track["duration"]) >= 1){
						$normal_playlist_str .= " data-duration='" . $track["duration"] . "'";
					}
					
					$normal_playlist_str .= " data-is-private='" . $track["isPrivate"] . "'";
					
					if($track["password"]){
						$normal_playlist_str .= " data-private-video-password='" . md5($track["password"]) . "'";
					}
					
					if (strlen($track["startAtTime"]) >= 1){
						$normal_playlist_str .= " data-start-at-time='" . $track["startAtTime"] . "'";
					}
					
					if (strlen($track["stopAtTime"]) >= 1){
						$normal_playlist_str .= " data-stop-at-time='" . $track["stopAtTime"] . "'";
					}
					
					if (isset($track["buy"]) && strlen($track["buy"]) >= 1){
						$normal_playlist_str .= " data-buy-url='" . $track["buy"] . "'";
					}

					if (isset($track["useATB"]) && $track["useATB"] == 'yes'){
						$normal_playlist_str .= " data-use-a-to-b='" . $track["useATB"] . "'";
					}

					if(isset($track["playOnlyIfLoggedIn"])){
						$isLoggedIn = $this->is_user_logged_in();
						if($track["playOnlyIfLoggedIn"] == 'yes' && !$isLoggedIn){
							 $normal_playlist_str .= " data-play-if-logged-in='yes'";
						}
					}
					
					$normal_playlist_str .= " data-downloadable='" . $track["dl"] . "'>";
					
					$normal_playlist_str .= $track["title"];
					
					$normal_playlist_str .= "</li>";
				}
				
				$normal_playlist_str .= "</ul>";
				
				FWDMSP::$_pl_id++;
			}else if ($playlist["type"] == "folder"){
					$main_playlist_str .= "<li data-source='folder:" . $playlist["source"]  . "' data-playlist-name='" . $playlist['name'] . "'";
			}
			else if ($playlist["type"] == "youtube"){

				$youtube_playlist_source = "list=";

				$reg_exp = "/[\?\&]list\=.+/";

				if (preg_match($reg_exp, $playlist["source"], $matches)){
					$youtube_playlist_source .= substr($matches[0], 6);
				}

				$main_playlist_str .= "<li data-source='" . $youtube_playlist_source  . "' data-playlist-name='" . $playlist['name'] . "'";
			}else if ($playlist["type"] == "xml"){
				$main_playlist_str .= "<li data-source='" . $playlist["source"]  ."' data-playlist-name='" . $playlist['name'] . "'";
			}else{
				$main_playlist_str .= "<li data-source='" . $playlist["source"]  ."' data-playlist-name='" . $playlist['name'] . "'";
			}
			
			
			if(strlen($playlist["thumb"]) >= 1){
				$main_playlist_str .= " data-thumbnail-path='" . $playlist["thumb"] . "'>";
			}else{
				$main_playlist_str .= ">";
			}
			
			$main_playlist_str .= $playlist["text"];
    		
    		$main_playlist_str .= "</li>";
    	}
    	
    	$main_playlist_str .= "</ul>";
		$main_playlist_str .= $normal_playlist_str;
    	return $main_playlist_str;
    }
    
 	public function set_player($atts){
		extract(shortcode_atts(array("preset_id" => 0, "playlist_id" => 0), $atts, "fwdmsp"));
		
		$msp_constructor = $this->get_constructor($preset_id, $playlist_id);
		$msp_div = "<div id='fwdmspDiv" . FWDMSP::$_msp_id. "'></div>";
		$msp_main_playlist = $this->get_main_playlist($playlist_id);
		
		FWDMSP::$_msp_id++;
		
		$msp_output =  $msp_div . $msp_main_playlist . $msp_constructor;
		
		return $msp_output;
	}
	
	public function set_custom_meta_box($post){
		if (!$this->check_wp_ver()){
    		return;
    	}
		
		// presets
		$presetsNames = array();
		
		foreach ($this->_data->settings_ar as $setting){
    		$el = array(
    						"id" => $setting["name"],
    						"name" => $setting["name"]
    				   );
    				   
    		array_push($presetsNames, $el);
    	}
    	
		// playlists
		$mainPlaylistsNames = array();
		
		if (isset($this->_data->main_playlists_ar)){
			foreach ($this->_data->main_playlists_ar as $main_playlist){
	    		$el = array(
	    						"id" => $main_playlist["name"],
	    						"name" => $main_playlist["name"]
	    				   );
	    				   
	    		array_push($mainPlaylistsNames, $el);
	    	}
		}
		
    	wp_enqueue_style("fwdmsp_fwd_ui_css", $this->_dir_url . "css/fwd_ui.css", array(), FWDMSP::VERSION);
		wp_enqueue_script("fwdmsp_shortcode_script", $this->_dir_url . "js/shortcode.js", array(), FWDMSP::VERSION);
		
    	include_once "meta_box.php";
	}
}
?>