jQuery(document).ready(function($)
{
	$("#main_playlists").accordion(
	{
		header: ".main-playlist-header",
    	collapsible: true,
    	heightStyle: "content",
    	active: false
    })
    .sortable(
   	{
        axis: "x, y",
        handle: ".main-playlist-header",
        start: startMainPlaylistsOrder,
        update: updateMainPlaylistsOrder
    });

	$(".pls").accordion(
	{
		header: ".playlist-header",
    	collapsible: true,
    	heightStyle: "content",
    	active: false
    })
    .sortable(
   	{
        axis: "x, y",
        handle: ".playlist-header-sort",
        start: startPlaylistsOrder,
        update: updatePlaylistsOrder
    });
	
	$(".fwd-playlist").mouseover(function()
	{
		$(this).addClass("pl_over");
		$(this).find(".pl-header").css("color", "#212121");
	});
	
	$(".fwd-playlist").mouseout(function()
	{
		$(this).removeClass("pl_over");
		$(this).find(".pl-header").css("color", "#555555");
	});
	
	var imgPath = iconsPath + "normal-icon.png";
	var img = "<img src='" + imgPath + "' style='position:absolute;left:6px;top:6px;'>";
	
	$(".playlist > h3").prepend(img);
	
	$(".playlist-header .ui-accordion-header-icon").css("left", "22px");

	$(".trs").sortable(
   	{
        axis: "x, y",
        handle: ".track-header",
        start: startTracksOrder,
        update: updateTracksOrder
    });
	
	$(".fwd-track").mouseover(function()
	{
		$(this).addClass("tr_over");
		$(this).find(".track-header").css("color", "#212121");
	});
	
	$(".fwd-track").mouseout(function()
	{
		$(this).removeClass("tr_over");
		$(this).find(".track-header").css("color", "#555555");
	});
	
	if ($("#main_playlists .main-playlist").length > 0)
	{
		$("#mp_em").hide();
	}
	
	$("img").tooltip(
    {
        position:
        {
    		my: "center bottom-10",
    		at: "center top"
        }
    });
	
	var curMpOrderId;
	var newMpOrderId;
	
	function startMainPlaylistsOrder(ev, ui)
	{
		var allMpItems = $(this).sortable("toArray");
		
		curMpOrderId = allMpItems.indexOf($(ui.item).attr("id"));
	}
	
	function updateMainPlaylistsOrder(ev, ui)
	{
		var allMpItems = $(this).sortable("toArray");

   		newMpOrderId = allMpItems.indexOf($(ui.item).attr("id"));
   		
   		var curItem = mainPlaylistsAr.splice(curMpOrderId, 1)[0];
   	  
   	    mainPlaylistsAr.splice(newMpOrderId, 0, curItem);
	};
	
	var curPlOrderId;
	var newPlOrderId;
	
	function startPlaylistsOrder(ev, ui)
	{
		var allPlItems = $(this).sortable("toArray");
		
		curPlOrderId = allPlItems.indexOf($(ui.item).attr("id"));
	}
	
	function updatePlaylistsOrder(ev, ui)
	{
		var allPlItems = $(this).sortable("toArray");

   		newPlOrderId = allPlItems.indexOf($(ui.item).attr("id"));
   		
   		var allMpItems = $("#main_playlists").sortable("toArray");
   		var plParent = $(this).closest(".main-playlist");
   		
   		curMpOrderId = allMpItems.indexOf($(plParent).attr("id"));
   		
   		var curItem = mainPlaylistsAr[curMpOrderId].playlists.splice(curPlOrderId, 1)[0];
   	  
		mainPlaylistsAr[curMpOrderId].playlists.splice(newPlOrderId, 0, curItem);
	}
	
	var curTrOrderId;
	var newTrOrderId;
	
	function startTracksOrder(ev, ui)
	{
		var allTrItems = $(this).sortable("toArray");
		
		curTrOrderId = allTrItems.indexOf($(ui.item).attr("id"));
	}
	
	function updateTracksOrder(ev, ui)
	{
		var allTrItems = $(this).sortable("toArray");

   		newTrOrderId = allTrItems.indexOf($(ui.item).attr("id"));
   		
   		var allMpItems = $("#main_playlists").sortable("toArray");
   		var plParent = $(this).closest(".main-playlist");
   		
   		curMpOrderId = allMpItems.indexOf($(plParent).attr("id"));
   		
   		var allPlItems = $($(this).closest(".pls")).sortable("toArray");
   		var catParent = $(this).closest(".playlist");

   		curPlOrderId = allPlItems.indexOf($(catParent).attr("id"));
   		
   		var curItem = mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks.splice(curTrOrderId, 1)[0];
   	  
   		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks.splice(newTrOrderId, 0, curItem);
	}

    function checkLength(tips, el, prop, min, max)
	{
      	if ((el.val().length > max) || (el.val().length < min))
	    {
        	el.addClass("ui-state-error");
        	updateTips(tips, "Length of " + prop + " must be between " + min + " and " + max + ".");
        	
        	return false;
      	}
	    else
		{
        	return true;
      	}
	}

    
    function checkIfDuration(tips, el, prop)
	{
    	var duration_reg_exp = /([0-9]{2}:){2}[0-9]{2}|[0-9]{2}:[0-9]{2}/;
    	var str = el.val();
    	var res = str.match(duration_reg_exp);
		
    	if ((str.length == 0) || (res && res[0] == str))
        {
            return true;
        }
        else
        {
        	el.addClass("ui-state-error");
        	updateTips(tips, "The " + prop + " field value is not well formatted.");
        	
        	return false;
        }
	}
	
	function checkPodcast(tips, el, prop)
	{
    	var str = el.val().toLowerCase();
		
    	if ((str.indexOf("http:") != -1) || (str.indexOf("https:") != -1))
        {
            return true;
        }
        else
        {
        	el.addClass("ui-state-error");
        	updateTips(tips, "The " + prop + " field value is not a well formatted Podcast URL.");
        	
        	return false;
        }
	}
	
	function checkSoundcloud(tips, el, prop)
	{
    	var str = el.val().toLowerCase();
		
    	if (str.indexOf("soundcloud.com") != -1)
        {
            return true;
        }
        else
        {
        	el.addClass("ui-state-error");
        	updateTips(tips, "The " + prop + " field value is not a well formatted Soundcloud URL.");
        	
        	return false;
        }
	}
	
	function checkOfficialFM(tips, el, prop)
	{
    	var str = el.val().toLowerCase();
		
    	if (str.indexOf("official.fm") != -1)
        {
            return true;
        }
        else
        {
        	el.addClass("ui-state-error");
        	updateTips(tips, "The " + prop + " field value is not a well formatted Official.FM URL.");
        	
        	return false;
        }
	}
	
	function checkFolder(tips, el, prop)
	{
    	var str = el.val().toLowerCase();
		
    	if ((str.indexOf("http:") != -1) || (str.indexOf("https:") != -1) || (str.indexOf("ftp:") != -1))
        {
			el.addClass("ui-state-error");
        	updateTips(tips, "The " + prop + " field value is not a well formatted folder path.");
        	
        	return false;
        }
        else
        {
			return true;
        }
	}
	
	function checkYoutube(tips, el, prop){
    	var str = el.val().toLowerCase();
		
    	if ((str.indexOf("youtube.") == -1) || (str.indexOf("list=") == -1)){
			el.addClass("ui-state-error");
        	updateTips(tips, "The " + prop + " field value is not a well formatted Youtube playlist URL.");
        	
        	return false;
        }else{
			return true;
        }
	}

	function checkXML(tips, el, prop)
	{
    	var str = el.val().toLowerCase();
		
    	if ((str.indexOf("http:") != -1) || (str.indexOf("https:") != -1) && (str.toLowerCase().indexOf(".xml") != -1) )
        {
            return true;
        }
        else
        {
        	el.addClass("ui-state-error");
        	updateTips(tips, "The " + prop + " field value is not a well formatted XML URL.");
        	
        	return false;
        }
	}
	
	function checkPLS(tips, el, prop)
	{
    	var str = el.val().toLowerCase();
		
    	if ((str.toLowerCase().indexOf(".pls") != -1) )
        {
            return true;
        }
        else
        {
        	el.addClass("ui-state-error");
        	updateTips(tips, "The " + prop + " field value is not a well formatted PLS URL.");
        	
        	return false;
        }
	}

	
	function updateTips(tips, txt)
	{
	    tips.text(txt).addClass("ui-state-highlight");

	    setTimeout(function()
		{
	    	tips.removeClass("ui-state-highlight", 1500);
	    }, 500);
	    
	    tips.addClass("fwd-error");
	}
	
	var cur_mp_id = 0;
	var cur_pl_id = 0;
	var cur_tr_id = 0;

	// main playlist dialogs
	var mp_name = $("#mp_name");
    var allFieldsMp = $([]).add(mp_name);

	$("#add-main-playlist-dialog").dialog(
	{
		autoOpen: false,
		width: 350,
	    height: 250,
	    modal: true,
	    buttons:
		{
	        "Add main playlist": function()
	        {
	         	var fValid = true;
	         	var tips = $("#add_mp_tips");
	         	
	          	allFieldsMp.removeClass("ui-state-error");
	 
	          	fValid = fValid && checkLength(tips, mp_name, "name", 1, 64);
	 
	          	if (fValid)
		        {
	          		var mid = $("#main_playlists .main-playlist").length;
	          		var plsIdsAr = [];
	          		
	          		if (mid > 0)
	          		{
	          			$.each(mainPlaylistsAr, function(i, el)
          				{
          					plsIdsAr.push(el.id);
          				});
    	          		
    	          		for (var i=0; i<mainPlaylistsAr.length; i++)
    	          		{
    	          			if ($.inArray(i, plsIdsAr) == -1)
    	          			{
    	          				mid = i;
    	          				break;
    	          			}
    	          		}
	          		}
	          		else
	          		{
	          			$("#mp_em").hide();
	          		}
	          		
		            $("#main_playlists").append("<div id='mp" + mid + "' class='main-playlist'>"
		    	    	+ "<h3 class='main-playlist-header'>" + mp_name.val().replace(/"/g, "'") + " <span style='float:right'>ID : " + mid + "</span></h3>"
		    	       	+ "<div>"
		    	       	+ "<div id='mp" + mid + "_pls' class='pls' style='width:654px'></div>"
		    	       	+ "<button class='add_playlist_btn' id='mp" + mid + "_add_btn' style='cursor:pointer;'>Add new playlist</button>"
		    	       	+ "<button class='edit_main_playlist_btn' id='mp" + mid + "_edit_btn' style='cursor:pointer;'>Edit</button>"
		    	    	+ "<button class='delete_main_playlist_btn' id='mp" + mid + "_del_btn' style='cursor:pointer;'>Delete</button>"
		    	       	+ "</div>"
		    	   	+ "</div>");

		            $(".add_playlist_btn").click(function()
            		{
            			var reg_exp = /mp[0-9]+_/;
            			
            			cur_mp_id = parseInt($(this).attr("id").match(reg_exp)[0].slice(2, -1));
            			
            	        $("#add-playlist-dialog").dialog("open");
            	        return false;
            	    });
		            
		            $(".edit_main_playlist_btn").click(function()
            		{
            			var reg_exp = /mp[0-9]+_/;
            			
            			cur_mp_id = parseInt($(this).attr("id").match(reg_exp)[0].slice(2, -1));
            			
            			var allMpItems = $("#main_playlists").sortable("toArray");
            	   		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
            			
            	        $("#edit-main-playlist-dialog").dialog("open");
            	        return false;
            	    });
		            
		            $(".delete_main_playlist_btn").click(function()
            		{
            			var reg_exp = /mp[0-9]+_/;
            			
            			cur_mp_id = parseInt($(this).attr("id").match(reg_exp)[0].slice(2, -1));         			
            			
            	        $("#delete-main-playlist-dialog").dialog("open");
            	        return false;
            	    });
		            
		            $("#mp" + mid + "_pls").accordion(
            		{
            			header: ".playlist-header",
            	    	collapsible: true,
            	    	heightStyle: "content",
            	    	active: false
            	    })
            	    .sortable(
            	   	{
            	        axis: "x, y",
            	        handle: ".playlist-header-sort",
            	        start: startPlaylistsOrder,
            	        update: updatePlaylistsOrder
            	    });       

		            $("#main_playlists").sortable("refresh");
		            $("#main_playlists").accordion("refresh");
		            
		            var newMp =
		            {
		            	id: mid,
		            	name: mp_name.val().replace(/"/g, "'"),
		            	playlists: []
		            };
		            
		            mainPlaylistsAr.push(newMp);

		            $(this).dialog("close");
	         	 }	
	        },
	        "Cancel": function()
	        {
	        	$(this).dialog("close");
	        }
	    },
	    close: function()
	    {
		    allFieldsMp.removeClass("ui-state-error");
		    $("#add_mp_tips").removeClass("fwd-error");
	    },
	    open: function()
	    {
	    	$("#mp_name").val("");
		    
		    $("#add_mp_tips").text("The name field is required.");
		}
	});

	$("#add_main_playlist_btn").click(function()
	{
        $("#add-main-playlist-dialog").dialog("open");
        return false;
    });
	
	var mp_name_edit = $("#mp_name_edit");
    var allFieldsMpEdit = $([]).add(mp_name_edit);

	$("#edit-main-playlist-dialog").dialog(
	{
		autoOpen: false,
		width: 350,
	    height: 250,
	    modal: true,
	    buttons:
		{
	        "Update main playlist": function()
	        {
	         	var fValid = true;
	         	var tips = $("#edit_mp_tips");
	         	
	         	allFieldsMpEdit.removeClass("ui-state-error");
	 
	          	fValid = fValid && checkLength(tips, mp_name_edit, "name", 1, 64);
	 
	          	if (fValid)
		        {
	          		var content = $("#mp" + cur_mp_id + " > h3").html();
	          		var pos = content.indexOf(mainPlaylistsAr[curMpOrderId].name);
	          		
	          		content = content.slice(0, pos);
	          		
	          		$("#mp" + cur_mp_id + " > h3").html(content + mp_name_edit.val().replace(/"/g, "'") + "<span style='float:right'>ID : " + mainPlaylistsAr[curMpOrderId].id + "</span>");
	          		
		            mainPlaylistsAr[curMpOrderId].name = mp_name_edit.val().replace(/"/g, "'");
		            
		            $(this).dialog("close");
	         	 }	
	        },
	        "Cancel": function()
	        {
	        	$(this).dialog("close");
	        }
	    },
	    close: function()
	    {
		    allFieldsMpEdit.removeClass("ui-state-error");
		    $("#edit_mp_tips").removeClass("fwd-error");
	    },
	    open: function()
	    {
	    	$("#mp_name_edit").val(mainPlaylistsAr[curMpOrderId].name);
	    	
	    	$("#edit_mp_tips").text("The name field is required.");
		}
	});
	
	$(".edit_main_playlist_btn").click(function()
	{
		var reg_exp = /mp[0-9]+_/;
		
		cur_mp_id = parseInt($(this).attr("id").match(reg_exp)[0].slice(2, -1));
		
		var allMpItems = $("#main_playlists").sortable("toArray");
   		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
		
        $("#edit-main-playlist-dialog").dialog("open");
        return false;
    });
	
	$("#delete-main-playlist-dialog").dialog(
	{
		autoOpen: false,
		width: 300,
	    height: 160,
	    modal: true,
	    buttons:
		{
	        "Yes": function()
	        {
		   		var allMpItems = $("#main_playlists").sortable("toArray");
	       		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
		   		
		   		mainPlaylistsAr.splice(curMpOrderId, 1);
		   		
	            $("#mp" + cur_mp_id).remove();
	            
	            $("#main_playlists").accordion("option", "active", false);
	            
	            $("#main_playlists").sortable("refresh");
	            $("#main_playlists").accordion("refresh");
	            
	            if ($("#main_playlists .main-playlist").length == 0)
	            {
	            	$("#mp_em").show();
	            }
	            
	            $(this).dialog("close");
	        },
	        "No": function()
	        {
	        	$(this).dialog("close");
	        }
	    }
	});
	
	$(".delete_main_playlist_btn").click(function()
	{
		var reg_exp = /mp[0-9]+_/;
		
		cur_mp_id = parseInt($(this).attr("id").match(reg_exp)[0].slice(2, -1));
		
        $("#delete-main-playlist-dialog").dialog("open");
        return false;
    });

	// playlist dialogs
	var pl_name = $("#pl_name");
    var pl_type = $("#pl_type");
	var pl_source = $("#pl_source");
    var pl_thumb = $("#pl_thumb");
    var pl_text = $("#pl_text");
    
    var allFieldsPl = $([]).add(pl_name).add(pl_source).add(pl_thumb);

	$("#add-playlist-dialog").dialog(
	{
		autoOpen: false,
		width: 610,
	    height: 690,
	    modal: true,
	    buttons:
		{
	        "Add playlist": function()
	        {
	         	var fValid = true;
	         	var tips = $("#add_pl_tips");
	         	
	          	allFieldsPl.removeClass("ui-state-error");
	 
	          	fValid = fValid && checkLength(tips, pl_name, "playlist name", 1, 64);
				
				if ($("#pl_type").val() != "normal")
				{
					fValid = fValid && checkLength(tips, pl_source, "playlist source", 1, 256);
					
					switch ($("#pl_type").val())
					{
						case "podcast":
							fValid = fValid && checkPodcast(tips, pl_source, "playlist source");
							break;
						case "soundcloud":
							fValid = fValid && checkSoundcloud(tips, pl_source, "playlist source");
							break;
						case "official.fm":
							fValid = fValid && checkOfficialFM(tips, pl_source, "playlist source");
							break;
						case "folder":
							fValid = fValid && checkFolder(tips, pl_source, "playlist source");
							break;
						case "youtube":
							fValid = fValid && checkYoutube(tips, pl_source, "playlist source");
							break
						case "xml":
							fValid = fValid && checkXML(tips, pl_source, "playlist source");
							break
						case "pls":
							fValid = fValid && checkPLS(tips, pl_source, "playlist source");
							break
					}
				}
				
	       		fValid = fValid && checkLength(tips, pl_thumb, "playlist thumbnail path", 1, 256);
	 
	          	if (fValid)
		        {
	          		var pid = $("#mp" + cur_mp_id + "_pls .playlist-count").length;
	          		var plsIdsAr = [];
	          		
	          		var allMpItems = $("#main_playlists").sortable("toArray");
	          		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
	          		
	          		$.each($("#mp" + cur_mp_id + "_pls .playlist-count"), function(i, el)
      				{
	          			var reg_exp = /pl[0-9]+/;
            			var pl_id = parseInt($(el).attr("id").match(reg_exp)[0].slice(2));
            			
            			plsIdsAr.push(pl_id);
      				});
	          		
	          		for (var i=0; i<mainPlaylistsAr[curMpOrderId].playlists.length; i++)
	          		{
	          			if ($.inArray(i, plsIdsAr) == -1)
	          			{
	          				pid = i;
	          				break;
	          			}
	          		}
					
					if ($("#pl_type").val() != "normal")
					{
						var imgPath = iconsPath;
					
						switch ($("#pl_type").val())
						{
							case "podcast":
								imgPath += "podcast-icon.png";
								break;
							case "soundcloud":
								imgPath += "soundcloud-icon.png";
								break;
							case "official.fm":
								imgPath += "official-fm-icon.png";
								break;
							case "folder":
								imgPath += "folder-icon.png";
								break;
							case "youtube":
								imgPath += "youtube-icon.png";
								break;
							case "xml":
								imgPath += "xml-icon.png";
								break;
							case "pls":
								imgPath += "folder-icon.png";
								break;
						}
						

						
						var img = "<img src='" + imgPath + "' style='position:absolute;left:6px;top:6px;'>";
					
						$("#mp" + cur_mp_id + "_pls").append("<div id='mp" + cur_mp_id + "_pl" + pid + "' class='fwd-playlist playlist-count'>"
							+ img
							+ "<h3 class='playlist-header-sort pl-header'><span style='position:relative; margin-left:22px; top:-1px;'>" + pl_name.val().replace(/"/g, "'") + "</span></h3>"
							+ "<button class='edit_playlist_btn2' id='mp" + cur_mp_id + "_pl" + pid + "_edit_btn'>Edit</button>"
							+ "<button class='delete_playlist_btn2' id='mp" + cur_mp_id + "_pl" + pid + "_del_btn'>Delete</button>"
						+ "</div>");
						
						$(".fwd-playlist").mouseover(function()
						{
							$(this).addClass("pl_over");
							$(this).find(".pl-header").css("color", "#212121");
						});
						
						$(".fwd-playlist").mouseout(function()
						{
							$(this).removeClass("pl_over");
							$(this).find(".pl-header").css("color", "#555555");
						});
					}
					else
					{
						$("#mp" + cur_mp_id + "_pls").prepend("<div id='mp" + cur_mp_id + "_pl" + pid + "' class='playlist playlist-count'>"
							+ "<h3 class='playlist-header-sort playlist-header'><span style='margin-left:16px;'>" + pl_name.val().replace(/"/g, "'") + "</span></h3>"
							+ "<div>"
							+ "<div id='mp" + cur_mp_id + "_pl" + pid + "_trs' class='trs' style='width:554px'></div>"
							+ "<button class='add_track_btn' id='mp" + cur_mp_id + "_pl" + pid + "_btn' style='cursor:pointer;'>Add new track</button>"
							+ "<button class='edit_playlist_btn' id='mp" + cur_mp_id + "_pl" + pid + "_edit_btn' style='cursor:pointer;'>Edit</button>"
							+ "<button class='delete_playlist_btn' id='mp" + cur_mp_id + "_pl" + pid + "_del_btn' style='cursor:pointer;'>Delete</button>"
							+ "</div>"
						+ "</div>");
						
						var imgPath = iconsPath + "normal-icon.png";
						var img = "<img src='" + imgPath + "' style='position:absolute;left:6px;top:6px;'>";
						
						$(".playlist > h3").prepend(img);
					
						$(".add_track_btn").click(function(e)
						{
							var reg_exp1 = /mp[0-9]+_/;
							var reg_exp2 = /pl[0-9]+_/;
							
							cur_mp_id = parseInt($(this).attr("id").match(reg_exp1)[0].slice(2, -1));
							cur_pl_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(2, -1));
							
							$("#add-track-dialog").dialog("open");
							return false;
						});
					}
					
					$(".edit_playlist_btn, .edit_playlist_btn2").click(function()
					{
						var reg_exp1 = /mp[0-9]+_/;
						var reg_exp2 = /pl[0-9]+_/;
						
						cur_mp_id = parseInt($(this).attr("id").match(reg_exp1)[0].slice(2, -1));
						cur_pl_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(2, -1));
						
						var allMpItems = $("#main_playlists").sortable("toArray");
						curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
						
						var allPlItems = $("#mp" + cur_mp_id + "_pls").sortable("toArray");
						curPlOrderId = allPlItems.indexOf("mp" + cur_mp_id + "_pl" + cur_pl_id);
						
						$("#edit-playlist-dialog").dialog("open");
						return false;
					});
					
					$(".delete_playlist_btn, .delete_playlist_btn2").click(function()
					{
						var reg_exp1 = /mp[0-9]+_/;
						var reg_exp2 = /pl[0-9]+_/;
						
						cur_mp_id = parseInt($(this).attr("id").match(reg_exp1)[0].slice(2, -1));
						cur_pl_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(2, -1));
						
						$("#delete-playlist-dialog").dialog("open");
						return false;
					});
		            
		            $("#mp" + cur_mp_id + "_pl" + pid + "_trs").sortable(
            	   	{
            	        axis: "x, y",
            	        handle: ".track-header",
            	        start: startTracksOrder,
            	        update: updateTracksOrder
            	    });

		            $(".pls").sortable("refresh");
		            $(".pls").accordion("refresh");
					
					$(".playlist-header .ui-accordion-header-icon").css("left", "22px");
		            
		            var newPl =
		            {
		            	name: pl_name.val().replace(/"/g, "'"),
						type: pl_type.val(),
						source: pl_source.val().replace(/"/g, "'"),
						thumb: pl_thumb.val().replace(/"/g, "'"),
						text: getPlaylistText(),
		            	tracks: []
		            };
		            
		            mainPlaylistsAr[curMpOrderId].playlists.unshift(newPl);

		            $(this).dialog("close");
	         	 }	
	        },
	        "Cancel": function()
	        {
	        	$(this).dialog("close");
	        }
	    },
	    close: function()
	    {
		    allFieldsPl.removeClass("ui-state-error");  
		    $("#add_pl_tips").removeClass("fwd-error");
	    },
	    open: function()
	    {
	    	$("#pl_name").val("");
			$("#pl_type").val("normal");
			$("#pl_source").val("");
	    	$("#pl_thumb").val("");
		    
		    setPlaylistText("");
			
			$("#upload_pl_thumb").attr("src", "");
		    
		    $("#wp-pltext-wrap").attr("style", "margin-top:-30px;");
		    $("#pltext-html").html("HTML");
			
			$("#pl_source_div").hide();
	    	
	    	$("#add_pl_tips").text("The playlist name and thumbnail path fields are required (and also the playlist source if the type is not 'normal').");
			
			$("#pltext_ifr").height(181);
		}
	});
	
	function setPlaylistText(str)
	{
		if (typeof tinyMCE !== "undefined" && tinyMCE.get("pltext"))
		{
			tinyMCE.get("pltext").setContent(str);
		}
	    
	    $("#pltext").val(str);
	}
	
	function getPlaylistText()
	{
		var pl_text;
		
		if (typeof tinyMCE !== "undefined" && tinyMCE.get("pltext"))
	    {
			if ($("#wp-pltext-wrap").hasClass("tmce-active"))
			{
				pl_text = tinyMCE.get("pltext").getContent();
				
				if (pl_text.length < 1)
				{
					pl_text = $("#pltext").val();
				}
			}
			else
			{
				pl_text = $("#pltext").val();
			}
	    }
		else
		{
			pl_text = $("#pltext").val();
		}

        return pl_text.replace(/"/g, "'").replace(/\n/g, "");
	}
	
	$("#pl_type").change(function()
	{
		if ($("#pl_type").val() == "normal")
		{
			$("#pl_source_div").hide(200);
		}
		else
		{
			$("#pl_source_div").show(200);
			
			switch ($("#pl_type").val())
			{
				case "podcast":
					$("#source_help_img").prop("title", "The source represents the path of a Podcast URL.");
					break;
				case "soundcloud":
					$("#source_help_img").prop("title", "The source represents the URL of a Soundcloud playlist.");
					break;
				case "official.fm":
					$("#source_help_img").prop("title", "The source must be an official.fm playlist URL that looks something like this 'http://www.official.fm/playlists/yrOG'.");
					break;
				case "folder":
					$("#source_help_img").prop("title", "The source represents the relative path to a folder containing only MP3 files that must be a subfolder of the 'content' folder contained in the plugin directory 'wp-content/plugins/fwdmsp'.");
					break;
				case "youtube":
					$("#source_help_img").prop("title", "The source represents the URL of a Youtube playlist.");
					break;
				case "xml":
					$("#source_help_img").prop("title", "The source represents the absolute path to a XML file that is sepcially formated to create a playlist for MSP. You can see an example at http://webdesign-flash.ro/w/msp/content/playlist1.xml or in the download files by oppening playlist1.xml file.");
					break;
				case "pls":
					$("#source_help_img").prop("title", "The source represents the relative or absolute path to a PLS file(Audio Playlist).");
					break;
			}
		}
	});

	$(".add_playlist_btn").click(function()
	{
		var reg_exp = /mp[0-9]+_/;
		
		cur_mp_id = parseInt($(this).attr("id").match(reg_exp)[0].slice(2, -1));
		
        $("#add-playlist-dialog").dialog("open");
        return false;
    });
	
	var pl_name_edit = $("#pl_name_edit");
    var pl_type_edit = $("#pl_type_edit");
	var pl_source_edit = $("#pl_source_edit");
    var pl_thumb_edit = $("#pl_thumb_edit");
    var pl_text_edit = $("#pl_text_edit");
    
    var allFieldsPlEdit = $([]).add(pl_name_edit).add(pl_source_edit).add(pl_thumb_edit);
	
	$("#edit-playlist-dialog").dialog(
	{
		autoOpen: false,
		width: 610,
	    height: 690,
	    modal: true,
	    buttons:
		{
	        "Update playlist": function()
	        {
	         	var fValid = true;
	         	var tips = $("#edit_pl_tips");
	         	
	          	allFieldsPlEdit.removeClass("ui-state-error");
				
				fValid = fValid && checkLength(tips, pl_name_edit, "playlist name", 1, 64);
				
				if ($("#pl_type_edit").val() != "normal")
				{
					fValid = fValid && checkLength(tips, pl_source_edit, "playlist source", 1, 256);
					
					switch ($("#pl_type_edit").val())
					{
						case "podcast":
							fValid = fValid && checkPodcast(tips, pl_source_edit, "playlist source");
							break;
						case "soundcloud":
							fValid = fValid && checkSoundcloud(tips, pl_source_edit, "playlist source");
							break;
						case "official.fm":
							fValid = fValid && checkOfficialFM(tips, pl_source_edit, "playlist source");
							break;
						case "folder":
							fValid = fValid && checkFolder(tips, pl_source_edit, "playlist source");
							break;
						case "youtube":
							fValid = fValid && checkYoutube(tips, pl_source_edit, "playlist source");
							break;
						case "xml":
							fValid = fValid && checkXML(tips, pl_source, "playlist source");
							break;
						case "pls":
							fValid = fValid && checkPLS(tips, pl_source, "playlist source");
							break;
					}
					
				}
				
	       		fValid = fValid && checkLength(tips, pl_thumb_edit, "playlist thumbnail path", 1, 256);
	 
	          	if (fValid)
		        {
	          		var content = $("#mp" + cur_mp_id + "_pl" + cur_pl_id + " > h3").html();
	          		var pos = content.indexOf(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].name);
	          		
	          		content = content.slice(0, pos);
	          		
	          		$("#mp" + cur_mp_id + "_pl" + cur_pl_id + " > h3").html(content + pl_name_edit.val().replace(/"/g, "'"));
	          		
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].name = pl_name_edit.val().replace(/"/g, "'");
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].source = pl_source_edit.val().replace(/"/g, "'");
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].thumb = pl_thumb_edit.val().replace(/"/g, "'");
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].text = getPlaylistTextEdit();

		            $(this).dialog("close");
	         	 }	
	        },
	        "Cancel": function()
	        {
	        	$(this).dialog("close");
	        }
	    },
	    close: function()
	    {
		    allFieldsPlEdit.removeClass("ui-state-error");
		    $("#edit_pl_tips").removeClass("fwd-error");
	    },
	    open: function()
	    {
			$("#pl_name_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].name);
			
			$("#pl_type_edit").prop("disabled", false);
			$("#pl_type_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].type);
			$("#pl_type_edit").prop("disabled", true);
			
			$("#pl_source_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].source);
	    	$("#pl_thumb_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].thumb);
		    
		    setPlaylistTextEdit(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].text);
			
			$("#upload_pl_thumb_edit").attr("src", mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].thumb);
		    
		    $("#wp-pltextedit-wrap").attr("style", "margin-top:-30px;");
		    $("#pltextedit-html").html("HTML");
			
			if ($("#pl_type_edit").val() == "normal")
			{
				$("#pl_source_div_edit").hide();
			}
			else
			{
				$("#pl_source_div_edit").show();
				
				switch ($("#pl_type_edit").val())
				{
					case "podcast":
						$("#source_help_img_edit").prop("title", "The source represents the path of a Podcast URL.");
						break;
					case "soundcloud":
						$("#source_help_img_edit").prop("title", "The source represents the URL of a Soundcloud playlist.");
						break;
					case "official.fm":
						$("#source_help_img_edit").prop("title", "The source must be an official.fm playlist URL that looks something like this 'http://www.official.fm/playlists/YrOG'.");
						break;
					case "folder":
						$("#source_help_img_edit").prop("title", "The source represents the relative path to a folder containing only MP3 files that must be a subfolder of the 'content' folder contained in the plugin directory 'wp-content/plugins/fwdmsp'.");
						break;
					case "youtube":
						$("#source_help_img_edit").prop("title", "The source represents the URL of a Youtube playlist.");
						break;
					case "xml":
						$("#source_help_img_edit").prop("title", "The source represents the absolute path to a XML file that is sepcially formated to create a playlist for MSP. You can see an example at http://webdesign-flash.ro/w/msp/content/playlist1.xml or in the download files by oppening playlist1.xml file.");
						break;
					case "pls":
						$("#source_help_img_edit").prop("title", "The source represents the relative or absolute path to a PLS file(Audio Playlist).");
						break;
				}
			}
	    	
	    	$("#edit_pl_tips").text("The playlist name and thumbnail path fields are required (and also the playlist source if the type is not 'normal').");
			
			$("#pltextedit_ifr").height(181);
		}
	});
	
	function setPlaylistTextEdit(str)
	{
		if (typeof tinyMCE !== "undefined" && tinyMCE.get("pltextedit"))
		{
			tinyMCE.get("pltextedit").setContent(str);
		}
	    
	    $("#pltextedit").val(str);
	}
	
	function getPlaylistTextEdit()
	{
		var pl_text_edit;
		
		if (typeof tinyMCE !== "undefined" && tinyMCE.get("pltextedit"))
	    {
			if ($("#wp-pltextedit-wrap").hasClass("tmce-active"))
			{
				pl_text_edit = tinyMCE.get("pltextedit").getContent();
				
				if (pl_text_edit.length < 1)
				{
					pl_text_edit = $("#pltextedit").val();
				}
			}
			else
			{
				pl_text_edit = $("#pltextedit").val();
			}
	    }
		else
		{
			pl_text_edit = $("#pltextedit").val();
		}

        return pl_text_edit.replace(/"/g, "'").replace(/\n/g, "");
	}
	
	$(".edit_playlist_btn, .edit_playlist_btn2").click(function()
	{
		var reg_exp1 = /mp[0-9]+_/;
		var reg_exp2 = /pl[0-9]+_/;
		
		cur_mp_id = parseInt($(this).attr("id").match(reg_exp1)[0].slice(2, -1));
		cur_pl_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(2, -1));
		
		var allMpItems = $("#main_playlists").sortable("toArray");
		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
		
		var allPlItems = $("#mp" + cur_mp_id + "_pls").sortable("toArray");
		curPlOrderId = allPlItems.indexOf("mp" + cur_mp_id + "_pl" + cur_pl_id);
		
		$("#edit-playlist-dialog").dialog("open");
		return false;
	});
	
	$("#delete-playlist-dialog").dialog(
	{
		autoOpen: false,
		width: 300,
	    height: 160,
	    modal: true,
	    buttons:
		{
	        "Yes": function()
	        {
	            var allMpItems = $("#main_playlists").sortable("toArray");
	       		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
	            
	            var allPlItems = $("#mp" + cur_mp_id + "_pls").sortable("toArray");
	       		curPlOrderId = allPlItems.indexOf("mp" + cur_mp_id + "_pl" + cur_pl_id);
	       		
	       		mainPlaylistsAr[curMpOrderId].playlists.splice(curPlOrderId, 1);
	       		
	       		$("#mp" + cur_mp_id + "_pl" + cur_pl_id).remove();
	       		
	       		$(".pls").accordion("option", "active", false);

	       		$(".pls").sortable("refresh");
	            $(".pls").accordion("refresh");
				
				$(".playlist-header .ui-accordion-header-icon").css("left", "22px");
	            
	            $(this).dialog("close");
	        },
	        "No": function()
	        {
	        	$(this).dialog("close");
	        }
	    }
	});
	
	$(".delete_playlist_btn, .delete_playlist_btn2").click(function()
	{
		var reg_exp1 = /mp[0-9]+_/;
		var reg_exp2 = /pl[0-9]+_/;
		
		cur_mp_id = parseInt($(this).attr("id").match(reg_exp1)[0].slice(2, -1));
		cur_pl_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(2, -1));
		
		$("#delete-playlist-dialog").dialog("open");
		return false;
	});
	
	// track dialogs
	var tr_name = $("#tr_name");
    var tr_audio = $("#tr_audio");
    var tr_thumb = $("#tr_thumb");
	var tr_buy = $("#tr_buy");
    var tr_duration = $("#tr_duration");
    var tr_dl = $("#tr_dl");
    
    var allFieldsTr = $([]).add(tr_name).add(tr_audio).add(tr_thumb).add(tr_buy).add(tr_duration).add(startAtTime).add(stopAtTime);

	$("#add-track-dialog").dialog(
	{
		autoOpen: false,
		width: 610,
	    height: 780,
		modal: true,
	    buttons:
		{
	        "Add track": function()
	        {
	         	var fValid = true;
	         	var tips = $("#add_tr_tips");
	         	
	          	allFieldsTr.removeClass("ui-state-error");
	 
	          	fValid = fValid && checkLength(tips, tr_name, "track name", 1, 64);
	       		fValid = fValid && checkLength(tips, tr_audio, "track path", 1, 256);
	       		fValid = fValid && checkLength(tips, tr_thumb, "track thumbnail", 0, 256);
			
				if($("#startAtTime").val().length > 0) fValid = fValid && checkTimeFormat(tips, $("#startAtTime"), "start at time");
				if($("#stopAtTime").val().length > 0) fValid = fValid && checkTimeFormat(tips, $("#stopAtTime"), "start at time");
	       		fValid = fValid && checkLength(tips, tr_buy, "buy URL / Javascript function", 0, 256);
	       		fValid = fValid && checkIfDuration(tips, tr_duration, "track duration");
	 
	          	if (fValid)
		        {
	          		var tid = $("#mp" + cur_mp_id + "_pl" + cur_pl_id + "_trs .fwd-track").length;
	          		var trsIdsAr = [];
	          		
	          		var allMpItems = $("#main_playlists").sortable("toArray");
		       		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
		            
		            var allPlItems = $("#mp" + cur_mp_id + "_pls").sortable("toArray");
		       		curPlOrderId = allPlItems.indexOf("mp" + cur_mp_id + "_pl" + cur_pl_id);
	          		
	          		$.each($("#mp" + cur_mp_id + "_pl" + cur_pl_id + "_trs .fwd-track"), function(i, el)
      				{
	          			var reg_exp = /tr[0-9]+/;
            			var tr_id = parseInt($(el).attr("id").match(reg_exp)[0].slice(2));
            			
            			trsIdsAr.push(tr_id);
      				});
	          		
	          		for (var i=0; i<mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks.length; i++)
	          		{
	          			if ($.inArray(i, trsIdsAr) == -1)
	          			{
	          				tid = i;
	          				break;
	          			}
	          		}
	          		
	          		$("#mp" + cur_mp_id + "_pl" + cur_pl_id + "_trs").prepend("<div id='mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + tid + "' class='fwd-track'>"
		    	    	+ "<h3 class='track-header'>" + tr_name.val().replace(/"/g, "'") + "</h3>"
						+ "<img src='" + tr_thumb.val().replace(/"/g, "'") + "' class='fwd-audio-image-img' id='mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + tid  + "_img'></img>"
		    	       	+ "<button class='delete_track_btn' id='mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + tid + "_del_btn'>Delete</button>"
		    	       	+ "<button class='edit_track_btn' id='mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + tid + "_edit_btn'>Edit</button>"
			    	+ "</div>");
	          		
	          		$(".edit_track_btn").click(function()
      				{
      					var reg_exp1 = /mp[0-9]+_/;
      					var reg_exp2 = /pl[0-9]+_/;
      					var reg_exp3 = /tr[0-9]+_/;
      					
      					cur_mp_id = parseInt($(this).attr("id").match(reg_exp1)[0].slice(2, -1));
      					cur_pl_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(2, -1));
      					cur_tr_id = parseInt($(this).attr("id").match(reg_exp3)[0].slice(2));
      					
      					var allMpItems = $("#main_playlists").sortable("toArray");
      			   		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
      			        
      			        var allPlItems = $("#mp" + cur_mp_id + "_pls").sortable("toArray");
      			   		curPlOrderId = allPlItems.indexOf("mp" + cur_mp_id + "_pl" + cur_pl_id);
      			   		
      			   		var allTrItems = $("#mp" + cur_mp_id + "_pl" + cur_pl_id + "_trs").sortable("toArray");
      			   		curTrOrderId = allTrItems.indexOf("mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + cur_tr_id);
      					
      			        $("#edit-track-dialog").dialog("open");
      			        return false;
      			    });
	          		
	          		$(".delete_track_btn").click(function()
      				{
      					var reg_exp1 = /mp[0-9]+_/;
      					var reg_exp2 = /pl[0-9]+_/;
      					var reg_exp3 = /tr[0-9]+_/;
      					
      					cur_mp_id = parseInt($(this).attr("id").match(reg_exp1)[0].slice(2, -1));
      					cur_pl_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(2, -1));
      					cur_tr_id = parseInt($(this).attr("id").match(reg_exp3)[0].slice(2));
      					
      			        $("#delete-track-dialog").dialog("open");
      			        return false;
      			    });

		            $(".trs").sortable("refresh");
		            
		            $(".fwd-track").mouseover(function()
            		{
            			$(this).addClass("tr_over");
            			$(this).find(".track-header").css("color", "#212121");
            		});
            		
            		$(".fwd-track").mouseout(function()
            		{
            			$(this).removeClass("tr_over");
            			$(this).find(".track-header").css("color", "#555555");
            		});
		
		            var newTr =
		            {
		            	name: tr_name.val().replace(/"/g, "'"),
		            	audio: tr_audio.val().replace(/"/g, "'"),
		            	thumb: tr_thumb.val().replace(/"/g, "'"),
						startAtTime:$("#startAtTime").val().replace(/"/g, "'"),
						stopAtTime:$("#stopAtTime").val().replace(/"/g, "'"),
		            	buy: tr_buy.val().replace(/"/g, "'"),
		            	duration: tr_duration.val(),
		            	dl: tr_dl.val(),
						encrypt:$("#encrypt").val().replace(/"/g, "'"),
						useATB:$("#use_a_to_b").val(),
						playOnlyIfLoggedIn: $('#play_only_if_logged_in').val(),
		            	title: getTrackTitle(),
						isPrivate:$("#is_private").val().replace(/"/g, "'"),
						password:$("#password").val().replace(/"/g, "'"),
						type:$("#track_type").val().replace(/"/g, "'"),
						
		            };
		            
		            mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks.unshift(newTr);

		            $(this).dialog("close");
	         	}
	          	else
	          	{
	          		$("#add-track-dialog").scrollTop(0);
	          	}
	        },
	        "Cancel": function()
	        {
	        	$(this).dialog("close");
	        }
	    },
	    close: function()
	    {
		    allFieldsTr.removeClass("ui-state-error");
		    $("#add_tr_tips").removeClass("fwd-error");
	    },
	    open: function()
	    {
	    	$("#tr_name").val("");
	    	$("#tr_audio").val("");
			$("#track_type").val("multimedia");
	    	$("#tr_thumb").val("");
	    	$("#tr_buy").val("");
	    	$("#tr_duration").val("");
	    	$("#tr_dl").val("yes");
			$("#is_private").val("no");
			$("#encrypt").val("no");
			$("#use_a_to_b").val("no");
			$("#play_only_if_logged_in").val("no");
		    $("#password").val("");
		    setTrackTitle("");
			
			$("#upload_thumb").attr("src", "");
		    
		    $("#wp-trtitle-wrap").attr("style", "margin-top:-30px;");
		    $("#trtitle-html").html("HTML");
		    
		    var allMpItems = $("#main_playlists").sortable("toArray");
       		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
		    
		    $("#add_tr_tips").text("The track name and path fields are required.");
       		
       		$("#trtitle_ifr").height(181);
		}
	});
	
	function setTrackTitle(str)
	{
		if (typeof tinyMCE !== "undefined" && tinyMCE.get("trtitle"))
		{
			tinyMCE.get("trtitle").setContent(str);
		}
	    
	    $("#trtitle").val(str);
	}
	
	function getTrackTitle()
	{
		var tr_title;
		
		if (typeof tinyMCE !== "undefined" && tinyMCE.get("trtitle"))
	    {
			if ($("#wp-trtitle-wrap").hasClass("tmce-active"))
			{
				tr_title = tinyMCE.get("trtitle").getContent();
				
				if (tr_title.length < 1)
				{
					tr_title = $("#trtitle").val();
				}
			}
			else
			{
				tr_title = $("#trtitle").val();
			}
	    }
		else
		{
			tr_title = $("#trtitle").val();
		}

        return tr_title.replace(/"/g, "'").replace(/\n/g, "");
	}

	$(".add_track_btn").click(function(e)
	{
		var reg_exp1 = /mp[0-9]+_/;
		var reg_exp2 = /pl[0-9]+_/;
		
		cur_mp_id = parseInt($(this).attr("id").match(reg_exp1)[0].slice(2, -1));
		cur_pl_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(2, -1));
		
        $("#add-track-dialog").dialog("open");
        return false;
    });
	
	var tr_name_edit = $("#tr_name_edit");
    var tr_audio_edit = $("#tr_audio_edit");
    var tr_thumb_edit = $("#tr_thumb_edit");
    var tr_buy_edit = $("#tr_buy_edit");
    var tr_duration_edit = $("#tr_duration_edit");
    var tr_dl_edit = $("#tr_dl_edit");
    
    var allFieldsTrEdit = $([]).add(tr_name_edit).add(tr_audio_edit).add(tr_thumb_edit).add(tr_buy_edit).add(tr_duration_edit).add($("#startAtTimeEdit")).add($("#stopAtTimeEdit"))

	$("#edit-track-dialog").dialog(
	{
		autoOpen: false,
		width: 610,
	    height: 780,
	    modal: true,
	    buttons:
		{
	        "Update track": function()
	        {
	         	var fValid = true;
	         	var tips = $("#edit_tr_tips");
	         	
	          	allFieldsTrEdit.removeClass("ui-state-error");
				
				fValid = fValid && checkLength(tips, tr_name_edit, "track name", 1, 64);
	       		fValid = fValid && checkLength(tips, tr_audio_edit, "track path", 1, 256);
	       		fValid = fValid && checkLength(tips, tr_thumb_edit, "track thumbnail", 0, 256);
				if($("#startAtTimeEdit").val().length > 0) fValid = fValid && checkTimeFormat(tips, $("#startAtTimeEdit"), "start at time");
				if($("#stopAtTimeEdit").val().length > 0) fValid = fValid && checkTimeFormat(tips, $("#stopAtTimeEdit"), "start at time");
	       		fValid = fValid && checkLength(tips, tr_buy_edit, "buy URL / Javascript function", 0, 256);
	       		fValid = fValid && checkIfDuration(tips, tr_duration_edit, "track duration");
	 
	          	if (fValid)
		        {
	          		var content = $("#mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + cur_tr_id + " > h3").html();
	          		var pos = content.indexOf(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].name);
	          		
	          		content = content.slice(0, pos);
	          		
	          		$("#mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + cur_tr_id + " > h3").html(content + tr_name_edit.val().replace(/"/g, "'"));
	          		
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].name = tr_name_edit.val().replace(/"/g, "'");
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].audio = tr_audio_edit.val().replace(/"/g, "'");
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].thumb = tr_thumb_edit.val().replace(/"/g, "'");
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].buy = tr_buy_edit.val().replace(/"/g, "'");
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].duration = tr_duration_edit.val();
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].dl = tr_dl_edit.val();
	          		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].title = getTrackTitleEdit();
					mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].startAtTime = $("#startAtTimeEdit").val().replace(/"/g, "'");
					mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].stopAtTime = $("#stopAtTimeEdit").val().replace(/"/g, "'");
					mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].isPrivate = $("#is_private_edit").val().replace(/"/g, "'");
					mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].password = $("#password_edit").val().replace(/"/g, "'");
					mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].encrypt = $("#encrypt_edit").val().replace(/"/g, "'");
					mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].useATB = $("#use_a_to_b_edit").val().replace(/"/g, "'");
					mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].type = $("#track_type_edit").val();
					mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].playOnlyIfLoggedIn = $("#play_only_if_logged_in_edit").val();
					
					$("#mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + cur_tr_id + "_img").attr("src", tr_thumb_edit.val().replace(/"/g, "'"));
					
		            $(this).dialog("close");
	         	}
	          	else
	          	{
	          		$("#edit-track-dialog").scrollTop(0);
	          	}
	        },
	        "Cancel": function()
	        {
	        	$(this).dialog("close");
	        }
	    },
	    close: function()
	    {
		    allFieldsTrEdit.removeClass("ui-state-error");
		    $("#edit_tr_tips").removeClass("fwd-error");
	    },
	    open: function()
	    {
	    	$("#tr_name_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].name);
	    	$("#tr_audio_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].audio);
	    	$("#tr_thumb_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].thumb);
	    	$("#tr_buy_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].buy);
	    	$("#tr_duration_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].duration);
	    	$("#tr_dl_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].dl);
			$("#is_private_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].isPrivate);
			$("#password_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].password);
			$("#encrypt_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].encrypt);
		
			if(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].useATB){
				$("#use_a_to_b_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].useATB);
			}else{
				$("#use_a_to_b_edit").val('no');
			}

			if(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].playOnlyIfLoggedIn){
				$("#play_only_if_logged_in_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].playOnlyIfLoggedIn);
			}else{
				$("#play_only_if_logged_in_edit").val('no');
			}
		
			if(!mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].type){
				$("#track_type_edit").val("multimedia");
			}else{
				$("#track_type_edit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].type);
			}
			
			
			$("#startAtTimeEdit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].startAtTime);
			$("#stopAtTimeEdit").val(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].stopAtTime);
			
		    setTrackTitleEdit(mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].title);
			
			$("#upload_thumb_edit").attr("src", mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks[curTrOrderId].thumb);
		    
		    $("#wp-trtitleedit-wrap").attr("style", "margin-top:-30px;");
		    $("#trtitleedit-html").html("HTML");
		    
		    var allMpItems = $("#main_playlists").sortable("toArray");
       		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
		    
		    $("#edit_tr_tips").text("The track name and path fields are required.");
       		
       		$("#trtitleedit_ifr").height(181);
		}
	});
	
	function setTrackTitleEdit(str)
	{
		if (typeof tinyMCE !== "undefined" && tinyMCE.get("trtitleedit"))
	    {
	    	tinyMCE.get("trtitleedit").setContent(str);
	    }
	    
	    $("#trtitleedit").val(str);
	}
	
	function getTrackTitleEdit()
	{
		var tr_title_edit;
		
		if (typeof tinyMCE !== "undefined" && tinyMCE.get("trtitleedit"))
	    {
			if ($("#wp-trtitleedit-wrap").hasClass("tmce-active"))
			{
				tr_title_edit = tinyMCE.get("trtitleedit").getContent();
				
				if (tr_title_edit.length < 1)
				{
					tr_title_edit = $("#trtitleedit").val();
				}
			}
			else
			{
				tr_title_edit = $("#trtitleedit").val();
			}
	    }
		else
		{
			tr_title_edit = $("#trtitleedit").val();
		}

        return tr_title_edit.replace(/"/g, "'").replace(/\n/g, "");
	}

	$(".edit_track_btn").click(function()
	{
		var reg_exp1 = /mp[0-9]+_/;
		var reg_exp2 = /pl[0-9]+_/;
		var reg_exp3 = /tr[0-9]+_/;
		
		cur_mp_id = parseInt($(this).attr("id").match(reg_exp1)[0].slice(2, -1));
		cur_pl_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(2, -1));
		cur_tr_id = parseInt($(this).attr("id").match(reg_exp3)[0].slice(2));
		
		var allMpItems = $("#main_playlists").sortable("toArray");
   		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
        
        var allPlItems = $("#mp" + cur_mp_id + "_pls").sortable("toArray");
   		curPlOrderId = allPlItems.indexOf("mp" + cur_mp_id + "_pl" + cur_pl_id);
   		
   		var allTrItems = $("#mp" + cur_mp_id + "_pl" + cur_pl_id + "_trs").sortable("toArray");
   		curTrOrderId = allTrItems.indexOf("mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + cur_tr_id);
		
        $("#edit-track-dialog").dialog("open");
        return false;
    });
	
	$("#delete-track-dialog").dialog(
	{
		autoOpen: false,
		width: 300,
	    height: 160,
	    modal: true,
	    buttons:
		{
	        "Yes": function()
	        {
				var allMpItems = $("#main_playlists").sortable("toArray");
		   		curMpOrderId = allMpItems.indexOf("mp" + cur_mp_id);
		        
		        var allPlItems = $("#mp" + cur_mp_id + "_pls").sortable("toArray");
		   		curPlOrderId = allPlItems.indexOf("mp" + cur_mp_id + "_pl" + cur_pl_id);
		   		
		   		var allTrItems = $("#mp" + cur_mp_id + "_pl" + cur_pl_id + "_trs").sortable("toArray");
		   		curTrOrderId = allTrItems.indexOf("mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + cur_tr_id);
		   		
		   		mainPlaylistsAr[curMpOrderId].playlists[curPlOrderId].tracks.splice(curTrOrderId, 1);
		   		
		   		$("#mp" + cur_mp_id + "_pl" + cur_pl_id + "_tr" + cur_tr_id).remove();
		
		   		$(".trs").sortable("refresh");
		        
		        $(this).dialog("close");
	        },
	        "No": function()
	        {
	        	$(this).dialog("close");
	        }
	    }
	});
	
	$(".delete_track_btn").click(function()
	{
		var reg_exp1 = /mp[0-9]+_/;
		var reg_exp2 = /pl[0-9]+_/;
		var reg_exp3 = /tr[0-9]+_/;
		
		cur_mp_id = parseInt($(this).attr("id").match(reg_exp1)[0].slice(2, -1));
		cur_pl_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(2, -1));
		cur_tr_id = parseInt($(this).attr("id").match(reg_exp3)[0].slice(2));
		
        $("#delete-track-dialog").dialog("open");
        return false;
    });

	// track audio custom uploader
	var custom_uploader;
    
    $("#upload_audio_button").click(function(e)
    {
        e.preventDefault();
 
        //If the uploader object has already been created, reopen the dialog
        if (custom_uploader)
        {
            custom_uploader.open();
            return;
        }
        
        //Extend the wp.media object
        custom_uploader = wp.media.frames.file_frame = wp.media(
        {
            title: "Add video(mp4) or audio(mp3)",
            button:
            {
                text: "Add video(mp4) or audio(mp3)"
            },
            library:
            {
            	type: "audio,video"
            },
            multiple: false
        });
 
        //When a file is selected, grab the URL and set it as the text field's value
        custom_uploader.on("select", function()
        {
            attachment = custom_uploader.state().get("selection").first().toJSON();
            
            $("#tr_audio").val(attachment.url);
        });
 
        //Open the uploader dialog
        custom_uploader.open();
    });
	
	// track thumb custom uploader
	var custom_uploader2;
    
    $("#upload_thumb_button").click(function(e)
    {
        e.preventDefault();
 
        //If the uploader object has already been created, reopen the dialog
        if (custom_uploader2)
        {
            custom_uploader2.open();
            return;
        }
        
        //Extend the wp.media object
        custom_uploader2 = wp.media.frames.file_frame = wp.media(
        {
            title: "Choose Image",
            button:
            {
                text: "Add Image"
            },
            library:
            {
            	type: "image"
            },
            multiple: false
        });
 
        //When a file is selected, grab the URL and set it as the text field's value
        custom_uploader2.on("select", function()
        {
            attachment = custom_uploader2.state().get("selection").first().toJSON();
            
            $("#tr_thumb").val(attachment.url);
            $("#upload_thumb").attr("src", attachment.url);
        });
 
        //Open the uploader dialog
        custom_uploader2.open();
    });
    
   // track audio custom uploader edit
	var custom_uploader_edit;
    
    $("#upload_audio_button_edit").click(function(e)
    {
        e.preventDefault();
 
        //If the uploader object has already been created, reopen the dialog
        if (custom_uploader_edit)
        {
            custom_uploader_edit.open();
            return;
        }
        
        //Extend the wp.media object
        custom_uploader_edit = wp.media.frames.file_frame = wp.media(
        {
            title: "Add video(mp4) or audio(mp3)",
            button:
            {
                text: "Add video(mp4) or audio(mp3)"
            },
            library:
            {
            	type: "audio,video"
            },
            multiple: false
        });
 
        //When a file is selected, grab the URL and set it as the text field's value
        custom_uploader_edit.on("select", function()
        {
            attachment = custom_uploader_edit.state().get("selection").first().toJSON();
            
            $("#tr_audio_edit").val(attachment.url);
        });
 
        //Open the uploader dialog
        custom_uploader_edit.open();
    });
	
	// track thumb custom uploader edit
	var custom_uploader2_edit;
    
    $("#upload_thumb_button_edit").click(function(e)
    {
        e.preventDefault();
 
        //If the uploader object has already been created, reopen the dialog
        if (custom_uploader2_edit)
        {
            custom_uploader2_edit.open();
            return;
        }
        
        //Extend the wp.media object
        custom_uploader2_edit = wp.media.frames.file_frame = wp.media(
        {
            title: "Choose Image",
            button:
            {
                text: "Add Image"
            },
            library:
            {
            	type: "image"
            },
            multiple: false
        });
 
        //When a file is selected, grab the URL and set it as the text field's value
        custom_uploader2_edit.on("select", function()
        {
            attachment = custom_uploader2_edit.state().get("selection").first().toJSON();
            
            $("#tr_thumb_edit").val(attachment.url);
            $("#upload_thumb_edit").attr("src", attachment.url);
        });
 
        //Open the uploader dialog
        custom_uploader2_edit.open();
    });
	
	// playlist thumb custom uploader
	var custom_uploader_pl;
    
    $("#upload_pl_thumb_button").click(function(e)
    {
        e.preventDefault();
 
        //If the uploader object has already been created, reopen the dialog
        if (custom_uploader_pl)
        {
            custom_uploader_pl.open();
            return;
        }
        
        //Extend the wp.media object
        custom_uploader_pl = wp.media.frames.file_frame = wp.media(
        {
            title: "Choose Image",
            button:
            {
                text: "Add Image"
            },
            library:
            {
            	type: "image"
            },
            multiple: false
        });
 
        //When a file is selected, grab the URL and set it as the text field's value
        custom_uploader_pl.on("select", function()
        {
            attachment = custom_uploader_pl.state().get("selection").first().toJSON();
            
            $("#pl_thumb").val(attachment.url);
            $("#upload_pl_thumb").attr("src", attachment.url);
        });
 
        //Open the uploader dialog
        custom_uploader_pl.open();
    });
	
	// playlist thumb custom uploader edit
	var custom_uploader_pl_edit;
    
    $("#upload_pl_thumb_button_edit").click(function(e)
    {
        e.preventDefault();
 
        //If the uploader object has already been created, reopen the dialog
        if (custom_uploader_pl_edit)
        {
            custom_uploader_pl_edit.open();
            return;
        }
        
        //Extend the wp.media object
        custom_uploader_pl_edit = wp.media.frames.file_frame = wp.media(
        {
            title: "Choose Image",
            button:
            {
                text: "Add Image"
            },
            library:
            {
            	type: "image"
            },
            multiple: false
        });
 
        //When a file is selected, grab the URL and set it as the text field's value
        custom_uploader_pl_edit.on("select", function()
        {
            attachment = custom_uploader_pl_edit.state().get("selection").first().toJSON();
            
            $("#pl_thumb_edit").val(attachment.url);
            $("#upload_pl_thumb_edit").attr("src", attachment.url);
        });
 
        //Open the uploader dialog
        custom_uploader_pl_edit.open();
    });
	
	function checkTimeFormat(tips, el, prop, min, max){
		
		var timeRegExp = /^(?:2[0-3]|[01][0-9]):[0-5][0-9]:[0-5][0-9]$/;
		
      	if(!timeRegExp.test(el.val())){
        	el.addClass("ui-state-error");
        	updateTips(tips, "The  " + prop + " field must have the format hh:mm:ss ex:00:10:48 .");
        	return false;
      	}else{
        	return true;
      	}

	}
    
    $("#update_btn").click(function()
	{
    	$("#playlist_data").val(JSON.stringify(mainPlaylistsAr));
    });
});