<?php $agc_options = stripslashes_deep( get_option( 'agc_options' ) ); ?>
<div class='wrap agc_wrap'>
	<div id='agc_preview_button'>
		<a href='<?php echo add_query_arg( 'agc_preview', '', home_url() ); ?>' target='_blank'><span class='agc_icon_expand'></span> Preview</a>
	</div>
	<div id='agc_preview'>
	</div>
	<div id='agc_editor' class='agc_active'>
		<div id='agc_editor_toggle' class='agc_active'>
			<span class='agc_icon_close'></span>
		</div>
		<form id='agc_editor_form' data-url='<?php echo admin_url( 'admin-ajax.php' ); ?>'>
			<div id='agc_accordion'>
				<div class='agc_accordion_toggle agc_active'>
					General <span class='agc_chevron agc_icon_chevron_right'></span>
				</div>
				<div class='agc_accordion_content agc_active'>
					<div class='agc_setting'>
						<p>Plugin active</p>
						<p class='agc_note'>Will not display age verification screen if set as No</p>
						<div class='agc_inline'>
							<input type='radio' id='agc_active_1' name='agc_active' value='1' <?php if( $agc_options['active'] == true ) echo "checked='checked'"; ?>/> <label for='agc_active_1' class='agc_radio'>Yes</label>
						</div>
						<div class='agc_inline'>
							<input type='radio' id='agc_active_2' name='agc_active' value='0' <?php if( $agc_options['active'] == false ) echo "checked='checked'"; ?>/> <label for='agc_active_2' class='agc_radio'>No</label>
						</div>
					</div>
					<div class='agc_setting'>
						<p>Minimum age</p>
						<input type='text'  name='agc_age' value='<?php echo $agc_options['age']; ?>'/>
					</div>
					<div class='agc_setting'>
						<p>Verification method</p>
						<div class='agc_inline'>
							<input type='radio' id='agc_method_1' name='agc_method' value='birthday' data-agc-fields-toggle <?php if( $agc_options['method'] == 'birthday' ) echo "checked='checked'"; ?>/> <label for='agc_method_1' class='agc_radio'>Birthday</label>
						</div>
						<div class='agc_inline'>
							<input type='radio' id='agc_method_2' name='agc_method' value='checkbox' data-agc-fields-toggle <?php if( $agc_options['method'] == 'checkbox' ) echo "checked='checked'"; ?>/> <label for='agc_method_2' class='agc_radio'>Checkbox</label>
						</div>
						<div class='agc_inline'>
							<input type='radio' id='agc_method_3' name='agc_method' value='enter' data-agc-fields-toggle <?php if( $agc_options['method'] == 'enter' ) echo "checked='checked'"; ?>/> <label for='agc_method_3' class='agc_radio'>Enter</label>
						</div>
					</div>
					<div class='agc_setting <?php if( $agc_options['method'] != 'birthday' ) echo 'agc_hidden'; ?>' data-agc-method='birthday'>
						<p>Date format</p>
						<div class='agc_inline'>
							<input type='radio' id='agc_date_format_1' name='agc_date_format' value='dmy' <?php if( $agc_options['date_format'] == 'dmy' ) echo "checked='checked'"; ?>/> <label for='agc_date_format_1' class='agc_radio'>dd/mm/yyyy</label>
						</div>
						<div class='agc_inline'>
							<input type='radio' id='agc_date_format_2' name='agc_date_format' value='mdy' <?php if( $agc_options['date_format'] == 'mdy' ) echo "checked='checked'"; ?>/> <label for='agc_date_format_2' class='agc_radio'>mm/dd/yyyy</label>
						</div>
					</div>
					<div class='agc_setting'>
						<p>Cookie life</p>
						<p class='agc_note'>Number of days before age is requested again</p>
						<input type='text'  name='agc_cookie_life' value='<?php echo $agc_options['cookie_life']; ?>'/>
					</div>
					<div class='agc_setting'>
						<p>Search engines</p>
						<p class='agc_note'>Display age verification screen to search engine crawlers</p>
						<div class='agc_inline'>
							<input type='radio' id='agc_search_engine_1' name='agc_search_engine' value='1' <?php if( $agc_options['search_engine'] == true ) echo "checked='checked'"; ?>/> <label for='agc_search_engine_1' class='agc_radio'>Yes</label>
						</div>
						<div class='agc_inline'>
							<input type='radio' id='agc_search_engine_2' name='agc_search_engine' value='0' <?php if( $agc_options['search_engine'] == false ) echo "checked='checked'"; ?>/> <label for='agc_search_engine_2' class='agc_radio'>No</label>
						</div>
					</div>
					<div class='agc_setting'>
						<p>Exit button</p>
						<div class='agc_inline'>
							<input type='radio' id='agc_exit_1' name='agc_exit' value='1' data-agc-fields-toggle <?php if( $agc_options['exit'] == true ) echo "checked='checked'"; ?>/> <label for='agc_exit_1' class='agc_radio'>Yes</label>
						</div>
						<div class='agc_inline'>
							<input type='radio' id='agc_exit_2' name='agc_exit' value='0' data-agc-fields-toggle <?php if( $agc_options['exit'] == false ) echo "checked='checked'"; ?>/> <label for='agc_exit_2' class='agc_radio'>No</label>
						</div>
					</div>
					<div class='agc_setting <?php if( $agc_options['exit'] != true ) echo 'agc_hidden'; ?>' data-agc-exit='1'>
						<p>Exit button URL</p>
						<p class='agc_note'>Include http:// or https://</p>
						<input type='text'  name='agc_exit_url' value='<?php echo htmlspecialchars( $agc_options['exit_url'], ENT_QUOTES, 'UTF-8' ); ?>'/>
					</div>
				</div>
				<div class='agc_accordion_toggle'>
					Restricted sections <span class='agc_chevron agc_icon_chevron_right'></span>
				</div>
				<div class='agc_accordion_content'>
					<div class='agc_setting'>
						<p>Age verification required</p>
						<div class='agc_tab_radio'>
							<div class='agc_inline'>
								<input type='radio' id='agc_restriction_1' name='agc_restriction' value='all' data-target='#agc_restriction_all_content' <?php if( $agc_options['restriction'] == 'all' ) echo "checked='checked'"; ?>/> <label for='agc_restriction_1' class='agc_radio'>Everywhere</label>
							</div>
							<div class='agc_inline'>
								<input type='radio' id='agc_restriction_2' name='agc_restriction' value='exclusion' data-target='#agc_restriction_selection_content' <?php if( $agc_options['restriction'] == 'exclusion' ) echo "checked='checked'"; ?>/> <label for='agc_restriction_2' class='agc_radio'>Everywhere excluding selection</label>
							</div>
							<div class='agc_inline'>
								<input type='radio' id='agc_restriction_3' name='agc_restriction' value='selection' data-target='#agc_restriction_selection_content' <?php if( $agc_options['restriction'] == 'selection' ) echo "checked='checked'"; ?>/> <label for='agc_restriction_3' class='agc_radio'>Selection only</label>
							</div>
						</div>
					</div>
					<div class='agc_tab_content'>
						<div class='agc_tab_pane' id='agc_restriction_all_content'>
						</div>
						<div class='agc_tab_pane <?php if( $agc_options['restriction'] == 'exclusion' || $agc_options['restriction'] == 'selection' ) echo "agc_active"; ?>' id='agc_restriction_selection_content'>
							<div class='agc_setting'>
								<p>Pages</p>
								<select name='agc_pages[]' class='agc_multi_select' data-placeholder='Select some pages' multiple>
									<?php
									$agc_pages = get_pages( array( 'post_type' => 'page', 'sort_column' => 'post_title', 'sort_order' => 'asc' ) );
									if( $agc_pages ) {
										foreach( $agc_pages as $val ) {
											$selected = "";
											if( is_array( $agc_options['pages'] ) ) {
												if( in_array( $val->ID, $agc_options['pages'] ) ) {
													$selected = "selected";
												}
											}
											echo "<option value='".$val->ID."' $selected>".$val->post_title."</option>";
										}
									}
									?>
								</select>
							</div>
							<div class='agc_setting'>
								<p>Posts</p>
								<select name='agc_posts[]' class='agc_multi_select' data-placeholder='Select some posts' multiple>
									<?php
									$agc_post_types = get_post_types( array( 'public' => true ) );
									unset( $agc_post_types['page'] );
									unset( $agc_post_types['attachment'] );
									foreach( $agc_post_types as $post_type ) {
										$agc_posts = get_posts( array( 'post_type' => $post_type, 'posts_per_page' => 3000, 'orderby' => 'title', 'order' => 'asc' ) );
										if( !empty($agc_posts) ) {
											echo "<optgroup label='".strtoupper( $post_type )."'>";
											foreach( $agc_posts as $val ) {
												$selected = "";
												if( is_array( $agc_options['posts'] ) ) {
													if( in_array( $val->ID, $agc_options['posts'] ) ) {
														$selected = "selected";
													}
												}
												echo "<option value='".$val->ID."' $selected>".$val->post_title."</option>";
											}
											echo "</optgroup>";
										}
									}
									wp_reset_postdata();
									?>
								</select>
							</div>
							<div class='agc_setting'>
								<p>Terms (Categories)</p>
								<select name='agc_terms[]' class='agc_multi_select' data-placeholder='Select some terms' multiple>
									<?php
									$tax = get_taxonomies();
									unset( $tax['nav_menu'] );
									unset( $tax['link_category'] );
									unset( $tax['post_format'] );

									foreach( $tax as $val ) {
										$terms = get_terms( array('taxonomy' => $val, 'hide_empty' => false) );
										if( !empty($terms) ) {
											echo "<optgroup label='".strtoupper( $val )."'>";
											foreach( $terms as $term ) {
												$selected = "";
												if( is_array( $agc_options['terms'] ) ) {
													if( in_array( $term->term_id, $agc_options['terms'] ) ) {
														$selected = "selected";
													}
												}
												echo "<option value='".$term->term_id."' $selected>".ucfirst( $val )." &raquo ".$term->name."</option>";
											}
											echo "</optgroup>";
										}
									}
									?>
								</select>
							</div>
							<div class='agc_setting'>
								<p>Post types</p>
								<select name='agc_post_types[]' class='agc_multi_select' data-placeholder='Select some post types' multiple>
									<?php
									$post_types = get_post_types();
									$dont_include = array(
										'revision',
										'nav_menu_item',
										'custom_css',
										'customize_changeset',
										'oembed_cache',
										'user_request',
										'wp_block'
									);
									foreach( $post_types as $val ) {
										if( !in_array($val, $dont_include) ) {
											$selected = "";
											if( is_array( $agc_options['post_types'] ) ) {
												if( in_array( $val, $agc_options['post_types'] ) ) {
													$selected = "selected";
												}
											}
											echo "<option value='".$val."' $selected>".$val."</option>";
										}
									}
									?>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class='agc_accordion_toggle'>
					Styling <span class='agc_chevron agc_icon_chevron_right'></span>
				</div>
				<div class='agc_accordion_content'>
					<div class='agc_setting'>
						<p>Logo</p>
						<?php
						$agc_file_id = $agc_options['logo'];

						// Get the file url
						$agc_file_url = $agc_file_id != null ? wp_get_attachment_url( $agc_file_id ) : false;

						// Get the file name
						$agc_file_name = $agc_file_url != false ? basename( $agc_file_url ) : '';

						echo 	"<div class='agc_file_preview ".( $agc_file_url != false ? '' : 'hidden' )."'>
								<a class='agc_file_add' data-type='image' href='#'>
									<div class='agc_file_thumb'>
										".( $agc_file_url != false ? "<img src='{$agc_file_url}'/>" : "" )."
									</div>
								</a>
								<div class='agc_file_name'>$agc_file_name</div>
								<a class='agc_file_remove' href='#'>Remove file</a>
								<input class='agc_file_id' type='hidden' name='agc_logo' value='".( $agc_file_url != false ? esc_attr( $agc_file_id ) : '' )."' />
							</div>";
						echo 	"<div class='agc_file_none ".( $agc_file_url != false ? 'hidden' : '' )."'>
								<a class='agc_file_add button' data-type='image' href='#'>Add file</a>
							</div>";

						?>

					</div>
					<div class='agc_setting'>
						<p>Logo max width (px)</p>
						<input type='text'  name='agc_logo_width' value='<?php echo $agc_options['logo_width']; ?>'/>
					</div>
					<div class='agc_setting'>
						<p>Background options</p>
						<div class='agc_tab_radio'>
							<div class='agc_inline'>
								<input type='radio' id='agc_background_1' name='agc_background' data-target='#agc_background_color_content' value='color' <?php if( $agc_options['background'] == 'color' ) echo "checked='checked'"; ?>/> <label for='agc_background_1' class='agc_radio'>Color</label>
							</div>
							<div class='agc_inline'>
								<input type='radio' id='agc_background_2' name='agc_background' data-target='#agc_background_image_content' value='image' <?php if( $agc_options['background'] == 'image' ) echo "checked='checked'"; ?>/> <label for='agc_background_2' class='agc_radio'>Image</label>
							</div>
							<div class='agc_inline'>
								<input type='radio' id='agc_background_3' name='agc_background' data-target='#agc_background_video_content' value='video' <?php if( $agc_options['background'] == 'video' ) echo "checked='checked'"; ?>/> <label for='agc_background_3' class='agc_radio'>Video</label>
							</div>
						</div>
					</div>
					<div class='agc_tab_content'>
						<div class='agc_tab_pane <?php if( $agc_options['background'] == 'color' ) echo "agc_active"; ?>' id='agc_background_color_content'>
							<div class='agc_setting'>
								<p>Background color</p>
								<?php
								$presets = array( '#ec5b5b', '#45a1ef', '#65de73', '#a052e2', '#ee9e36' );
								$agc_custom_active = !in_array( $agc_options['background_color'], $presets ) && $agc_options['background_color'] != null ? true : false;
								foreach( $presets as $val ) {
									echo 	"<div class='agc_palette ".( $val == $agc_options['background_color'] ? "agc_active" : "" )."'>
											<div class='agc_color' style='background-color: $val'></div>
											<input type='radio' name='agc_background_color' value='$val' ".( $val == $agc_options['background_color'] ? "checked='checked'" : "" )."/>
										</div>";
								}
								
								echo 	"<div class='agc_palette agc_palette_custom ".( $agc_custom_active == true ? 'agc_active' : '' )."'>
										<span class='agc_icon_pencil'></span>
										<div class='agc_color' style='background-color: ".( $agc_custom_active == true ? $agc_options['background_color'] : '#666' )."'></div>
										<input type='radio' name='agc_background_color' ".( $agc_custom_active == true ? "value='{$agc_options['background_color']}' checked='checked'" : "value='#666'" )."/>
									</div>";
								?>

							</div>
						</div>
						<div class='agc_tab_pane <?php if( $agc_options['background'] == 'image' ) echo "agc_active"; ?>' id='agc_background_image_content'>
							<div class='agc_setting'>
								<p>Background overlay opacity</p>
								<div class='agc_slider'>
									<div class='agc_slider_handle ui-slider-handle'></div>
									<input type='hidden' class='agc_slider_input' name='agc_background_image_overlay' value='<?php echo $agc_options['background_image_overlay']; ?>'/>
								</div>
							</div>
							<div class='agc_setting'>
								<p>Background Image</p>
								<?php
								$agc_file_id = $agc_options['background_image'];

								// Get the file url
								$agc_file_url = $agc_file_id != null ? wp_get_attachment_url( $agc_file_id ) : false;

								// Get the file name
								$agc_file_name = $agc_file_url != false ? basename( $agc_file_url ) : '';

								echo 	"<div class='agc_file_preview ".( $agc_file_url != false ? '' : 'hidden' )."'>
										<a class='agc_file_add' data-type='image' href='#'>
											<div class='agc_file_thumb'>
												".( $agc_file_url != false ? "<img src='{$agc_file_url}'/>" : "" )."
											</div>
										</a>
										<div class='agc_file_name'>$agc_file_name</div>
										<a class='agc_file_remove' href='#'>Remove file</a>
										<input class='agc_file_id' type='hidden' name='agc_background_image' value='".( $agc_file_url != false ? esc_attr( $agc_file_id ) : '' )."' />
									</div>";
								echo 	"<div class='agc_file_none ".( $agc_file_url != false ? 'hidden' : '' )."'>
										<a class='agc_file_add button' data-type='image' href='#'>Add file</a>
									</div>";

								?>

							</div>
						</div>
						<div class='agc_tab_pane <?php if( $agc_options['background'] == 'video' ) echo "agc_active"; ?>' id='agc_background_video_content'>
							<div class='agc_setting'>
								<p>Background overlay opacity</p>
								<div class='agc_slider'>
									<div class='agc_slider_handle ui-slider-handle'></div>
									<input type='hidden' class='agc_slider_input' name='agc_background_video_overlay' value='<?php echo $agc_options['background_video_overlay']; ?>'/>
								</div>
							</div>
							<div class='agc_setting'>
								<p>Background video</p>
								<?php
								$agc_file_id = $agc_options['background_video'];

								// Get the file url
								$agc_file_url = $agc_file_id != null ? wp_get_attachment_url( $agc_file_id ) : false;

								// Get the file name
								$agc_file_name = $agc_file_url != false ? basename( $agc_file_url ) : '';

								echo 	"<div class='agc_file_preview ".( $agc_file_url != false ? '' : 'hidden' )."'>
										<a class='agc_file_add' data-type='video' href='#'>
											<div class='agc_file_thumb'>
												<img src='".AGC_PLUGIN_URL."admin/assets/img/video_icon.png'/>
											</div>
										</a>
										<div class='agc_file_name'>$agc_file_name</div>
										<a class='agc_file_remove' href='#'>Remove file</a>
										<input class='agc_file_id' type='hidden' name='agc_background_video' value='".esc_attr( $agc_file_id )."' />
									</div>";
								echo 	"<div class='agc_file_none ".( $agc_file_url != false ? 'hidden' : '' )."'>
										<a class='agc_file_add button' data-type='video' href='#'>Add file</a>
									</div>";

								?>

							</div>
						</div>
					</div>

				</div>
				<div class='agc_accordion_toggle'>
					Form text <span class='agc_chevron agc_icon_chevron_right'></span>
				</div>
				<div class='agc_accordion_content'>
					<p class='agc_note'>Enter %agc_age% in any field to output minimum age</p>
					<div class='agc_setting'>
						<p>Title</p>
						<input type='text' name='agc_form_title' value='<?php echo htmlspecialchars( $agc_options['form_title'], ENT_QUOTES, 'UTF-8' ); ?>'/>
					</div>
					<div class='agc_setting'>
						<p>Intro</p>
						<textarea name='agc_form_intro'><?php echo htmlspecialchars( $agc_options['form_intro'], ENT_QUOTES, 'UTF-8' ); ?></textarea>
					</div>
					<div class='agc_setting <?php if( $agc_options['method'] != 'checkbox' ) echo 'agc_hidden'; ?>' data-agc-method='checkbox'>
						<p>Checkbox</p>
						<input type='text' name='agc_form_checkbox' value='<?php echo htmlspecialchars( $agc_options['form_checkbox'], ENT_QUOTES, 'UTF-8' ); ?>'/>
					</div>
					<div class='agc_setting'>
						<p>Button</p>
						<input type='text' name='agc_form_button' value='<?php echo htmlspecialchars( $agc_options['form_button'], ENT_QUOTES, 'UTF-8' ); ?>'/>
					</div>
					<div class='agc_setting <?php if( $agc_options['exit'] != true ) echo 'agc_hidden'; ?>' data-agc-exit='1'>
						<p>Exit button</p>
						<input type='text'  name='agc_form_button_exit' value='<?php echo htmlspecialchars( $agc_options['form_button_exit'], ENT_QUOTES, 'UTF-8' ); ?>'/>
					</div>
				</div>
				<div class='agc_accordion_toggle'>
					Response text <span class='agc_chevron agc_icon_chevron_right'></span>
				</div>
				<div class='agc_accordion_content'>
					<p class='agc_note'>Enter %agc_age% in any field to output minimum age</p>
					<div class='agc_setting <?php if( $agc_options['method'] != 'birthday' ) echo 'agc_hidden'; ?>' data-agc-method='birthday'>
						<p>Empty</p>
						<input type='text' name='agc_response_birthday_empty' value='<?php echo htmlspecialchars( $agc_options['response_birthday_empty'], ENT_QUOTES, 'UTF-8' ); ?>'/>
					</div>
					<div class='agc_setting <?php if( $agc_options['method'] != 'birthday' ) echo 'agc_hidden'; ?>' data-agc-method='birthday'>
						<p>Non existent date</p>
						<input type='text' name='agc_response_birthday_date' value='<?php echo htmlspecialchars( $agc_options['response_birthday_date'], ENT_QUOTES, 'UTF-8' ); ?>'/>
					</div>
					<div class='agc_setting <?php if( $agc_options['method'] != 'birthday' ) echo 'agc_hidden'; ?>' data-agc-method='birthday'>
						<p>Below minimum age</p>
						<input type='text' name='agc_response_birthday_below' value='<?php echo htmlspecialchars( $agc_options['response_birthday_below'], ENT_QUOTES, 'UTF-8' ); ?>'/>
					</div>
					<div class='agc_setting <?php if( $agc_options['method'] != 'checkbox' ) echo 'agc_hidden'; ?>' data-agc-method='checkbox'>
						<p>Empty</p>
						<input type='text' name='agc_response_checkbox_empty' value='<?php echo htmlspecialchars( $agc_options['response_checkbox_empty'], ENT_QUOTES, 'UTF-8' ); ?>'/>
					</div>
				</div>
			</div>
			<div id='agc_editor_submit'>
				<button id='agc_edit_button' type='submit'>
					Save Changes
					<div class='agc_spinner'>
						<span class='agc_icon_spinner'></span>
					</div>
				</button>
				<input type='hidden' name='action' value='agc_edit'/>
				<?php wp_nonce_field( 'agc_edit', 'nonce', false ); ?>
			</div>
		</form>
	</div>
	<div class='agc_cleared'></div>
</div>
