jQuery( document ).ready( function( $ ) {
	if ( document.cookie.indexOf( "agc_verified_" + agc.age + "=" ) == -1 || agc.preview == 1 ) {
		// Setup viewport for agc screen
		if( !$( 'meta[name="viewport"]' ).length ) {
			$( 'head' ).append( '<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0"/>' );
		}
		else {
			$( 'meta[name="viewport"]' ).attr( 'content', 'width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0' );
		}
		$( 'html, body' ).addClass( 'agc_no_scroll' );
		
		// iOS and Android won't autoplay unless video is muted
		var windowsize = $( window ).width();
		if( windowsize < 992 ) {
			agc.screen = agc.screen.replace( "<video class='agc_screen' id='agc_bg_video' autoplay playsinline loop>", "<video class='agc_screen' id='agc_bg_video' autoplay playsinline loop muted>" );
		}
		$( 'body' ).append( agc.screen );	
	}
});