<?php 
// Include WP Library for JavaScript fetching
if ( !defined( 'AGC_VERSION' ) ) {
	require_once( '../../../../wp-load.php' ); 
}
$agc_options = stripslashes_deep( get_option( 'agc_options' ) );

if ( $agc_options['background'] === 'color' ) {
	echo "<div class='agc_screen' id='agc_bg' style='background-color: ".$agc_options['background_color']."'></div>"; 
}
else if ( $agc_options['background'] === 'image' ) {
	echo "<div class='agc_screen' id='agc_bg' style='background-image: url(".wp_get_attachment_url( $agc_options['background_image'] ).")'></div>"; 
	echo "<div class='agc_screen' id='agc_overlay' style='opacity:".$agc_options['background_image_overlay']."'></div>";
}
else if( $agc_options['background'] === 'video' ) {
	echo "<video class='agc_screen' id='agc_bg_video' autoplay playsinline loop muted><source src='".wp_get_attachment_url( $agc_options['background_video'] )."' type='video/mp4'></video>";
	echo "<div class='agc_screen' id='agc_overlay' style='opacity:".$agc_options['background_video_overlay']."'></div>";
}
?>
<aside class='agc_screen' id='agc_form'>
	<div id='agc_container'>
		<?php 
		$file_url = false;
		if( $agc_options['logo'] != null ) { 
			$file_url = wp_get_attachment_url( $agc_options['logo'] );
		}

		if( $file_url != false ) {
			/**
			 * Since 1.1.6
			 * Prevent Smush plugin from breaking JSON of this template
			 * Added data-src tag ( Smush class lazy.php - public function parse_image( $src, $image ) )
			 */
			echo "<p><img data-src='".$file_url."' src='".$file_url."' style='max-width:".$agc_options['logo_width']."px'/></p>";
		}
		?>
		<p id='agc_title'><?php echo str_replace( '%agc_age%', $agc_options['age'], $agc_options['form_title'] ); ?></p>
		<p><?php echo nl2br( str_replace( '%agc_age%', $agc_options['age'], $agc_options['form_intro'] ) ); ?></p>
		<form id='agc_verify_form' data-url='<?php echo admin_url( 'admin-ajax.php' ); ?>'>
			<?php if( $agc_options['method'] === 'checkbox' ) { ?>
				<div id='agc_checkbox'>
					<input type='checkbox' id='agc_check' name='agc_check'/>
					<label for='agc_check'><?php echo str_replace( '%agc_age%', $agc_options['age'], $agc_options['form_checkbox'] ); ?></label>
				</div>
			<?php } else if( $agc_options['method'] === 'birthday' ) { ?>
				<div id='agc_dob'>
					<?php
					$agc_days = 	"<div class='agc_select_wrap'>
								<div class='agc_select'>
									<span class='agc_select_val'>".apply_filters( 'agc_select_day', 'DD' )."</span> 
									<select name='agc_day'>
										<option value=''>".apply_filters( 'agc_select_day', 'DD' )."</option>";
										for( $x=1; $x<=31; $x++ ) {
											$agc_days .= "<option value='$x'>".sprintf("%02d", $x)."</option>";
										}
					$agc_days .=			"</select>
								</div>
								<div class='agc_options'>
									<div class='agc_triangle_up'>
									</div>
									<ul>";
										for( $x=1; $x<=31; $x++ ) {
											$agc_days .= "<li data-val='$x'>".sprintf("%02d", $x)."</li>";
										}
					$agc_days .=			"</ul>
								</div>
							</div>";

					$agc_months = 	"<div class='agc_select_wrap'>
								<div class='agc_select'>
									<span class='agc_select_val'>".apply_filters( 'agc_select_month', 'MM' )."</span> 
									<select name='agc_month'>
										<option value=''>".apply_filters( 'agc_select_month', 'MM' )."</option>";
										
										for( $x=1; $x<=12; $x++ ) {
											$agc_months .= "<option value='$x'>".sprintf("%02d", $x)."</option>";
										}
										
					$agc_months .=			"</select>
								</div>
								<div class='agc_options'>
									<div class='agc_triangle_up'>
									</div>
									<ul>";
										for( $x=1; $x<=12; $x++ ) {
											$agc_months .= "<li data-val='$x'>".sprintf("%02d", $x)."</li>";
										}
					$agc_months .=			"</ul>
								</div>
							</div>";

					$agc_years = 	"<div class='agc_select_wrap'>
								<div class='agc_select'>
									<span class='agc_select_val'>".apply_filters( 'agc_select_year', 'YYYY' )."</span> 
									<select name='agc_year'>
										<option value=''>".apply_filters( 'agc_select_year', 'YYYY' )."</option>";
										for( $x=0; $x<=100; $x++ ) {
											$y = date( 'Y' );
											$agc_years .= "<option value='".($y - $x)."'>".($y - $x)."</option>";
										}
					$agc_years .=			"</select>
								</div>
								<div class='agc_options'>
									<div class='agc_triangle_up'>
									</div>
									<ul>";
										for( $x=0; $x<=100; $x++ ) {
											$y = date( 'Y' );
											$agc_years .= "<li data-val='".($y - $x)."'>".($y - $x)."</li>";
										}
					$agc_years .=			"</ul>
								</div>
							</div>";

					if( $agc_options['date_format'] === 'dmy' ) {
						echo $agc_days.$agc_months.$agc_years;
					}
					else {
						echo $agc_months.$agc_days.$agc_years;
					}
					?>
					<div class='agc_cleared'></div>
				</div>
			<?php } ?>
			<div id='agc_verify_submit'>
				<button type='submit' class='agc_verify_button' <?php echo isset( $_GET['agc_preview_dashboard'] ) ? "disabled='disabled'" : ""; ?>><?php echo str_replace( '%agc_age%', $agc_options['age'], $agc_options['form_button'] ); ?></button>
				<?php if( $agc_options['exit'] == true ) { ?>
					<a href='<?php echo $agc_options['exit_url']; ?>' class='agc_verify_button' <?php echo isset( $_GET['agc_preview_dashboard'] ) ? "disabled='disabled'" : ""; ?>><?php echo str_replace( '%agc_age%', $agc_options['age'], $agc_options['form_button_exit'] ); ?></a>
				<?php } ?>
				<input type='hidden' name='action' value='agc_verify'/>
				<?php 
				// Let ajax request know that we're previewing
				echo ( isset( $_GET['agc_preview_dashboard'] ) || !empty( $preview ) ) ? "<input type='hidden' name='agc_preview' value='1'/>" : "";  
				?>
			</div>
		</form>
	</div>
</aside>