/**
 * @package   	JCE
 * @copyright 	Copyright (c) 2009-2019 Ryan Demmer. All rights reserved.
 * @license   	GNU/GPL 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * JCE is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

var tinyMCEPopup = {
    getParam: function(n, dv) {
        return this.editor.getParam(n, dv);
    },
    getLang: function(n, dv) {
        var lang = Wf.getLanguage();
        return Wf.i18n[lang + '.' + n] || dv;
    },
    getWindowArg: function(n, dv) {
        var v = this.editor.windowManager.params[n];
        return (typeof v !== "undefined") ? v : dv;
    },
    close: function() {
        return this.editor.windowManager.close();
    }
};
// fake editor
tinyMCEPopup.editor = window.tinymce || window.parent.tinymce;

jQuery(document).ready(function($) {
    var win = window.parent,
        s = tinyMCEPopup.editor.settings,
        element = s.element,
        el;

    if (element) {
        el = win.document.getElementById(element);
        if (el) {
            tinyMCEPopup.editor.windowManager.params.value = el.value;
        }
    }

    if (s.callback) {
        var fn = win[s.callback];

        if (typeof fn === "function") {
            tinyMCEPopup.editor.windowManager.params.callback = fn;
        }
    }

    // Joomla 3.5.x Media Field
    if (el && el.className.indexOf(' field-media-input ') !== -1) {
        $('#cancel').hide();
    }
});