<?php

/**
 * @package   	JCE
 * @copyright 	Copyright (c) 2009-2017 Ryan Demmer. All rights reserved.
 * @license   	GNU/GPL 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * JCE is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
defined('_WF_EXT') or die('RESTRICTED');

class WFPopupsExtension_Widgetkit2 {

    /**
     * Constructor activating the default information of the class
     *
     * @access	protected
     */
    public function __construct() {
        if (self::isEnabled()) {
            $scripts = array();

            $document = WFDocument::getInstance();

            $document->addScript('plugins/jce/popups-widgetkit2/js/widgetkit.js', 'joomla');
        }
    }

    public function getParams() {
        $wf = WFEditorPlugin::getInstance();

        return array(
            'lightbox_group'            => $wf->getParam('popups.widgetkit.lightbox_group', ''),
            'lightbox_keyboard'         => $wf->getParam('popups.widgetkit.lightbox_keyboard', ''),
            'lightbox_duration'         => $wf->getParam('popups.widgetkit.lightbox_duration', '')
        );
    }

    public function isEnabled() {
        $wf = WFEditorPlugin::getInstance();

        if (JPluginHelper::isEnabled('content', 'widgetkit') && $wf->getParam('popups.widgetkit2.enable', 1) == 1) {
            return true;
        }

        return false;
    }
}

?>