<?php

namespace DevOwl\RealThumbnailGenerator\lite;

use DevOwl\RealThumbnailGenerator\Vendor\DevOwl\Freemium\CorePro;
use Exception;
use DevOwl\RealThumbnailGenerator\Vendor\MatthiasWeb\Utils\ExpireOption;
use MatthiasWeb\WPU\V4\WPLSController;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
trait Core
{
    use CorePro;
    private $updater;
    // Documented in IOverrideCore
    public function overrideConstruct()
    {
        $this->getUpdater();
        // Initially load the updater
    }
    // Documented in IOverrideCore
    public function overrideInit()
    {
        // Show plugin notice
        if (!$this->getUpdater()->isActivated()) {
            add_action('after_plugin_row_' . plugin_basename(RTG_FILE), [$this, 'after_plugin_row'], 10, 2);
        }
    }
    /**
     * Show a notice in the plugins list that the plugin is not activated, yet.
     *
     * @param string $file
     * @param array $plugin
     */
    public function after_plugin_row($file, $plugin)
    {
        $wp_list_table = _get_list_table('WP_Plugins_List_Table');
        \printf('<tr class="rtg-update-notice active">
	<th colspan="%d" class="check-column">
    	<div class="plugin-update update-message notice inline notice-warning notice-alt">
        	<div class="update-message">%s</div>
    	</div>
    </th>
</tr>', $wp_list_table->get_column_count(), wpautop(__('<strong>You have not yet entered the license key</strong>. To receive automatic updates, please enter the key in "Enter license".', RTG_TD)));
    }
    // Documented in IOverrideCore
    public function isLicenseNoticeDismissed($set = null)
    {
        if (!$this->isPro()) {
            return \true;
        }
        $value = '1';
        $expireOption = new \DevOwl\RealThumbnailGenerator\Vendor\MatthiasWeb\Utils\ExpireOption(RTG_OPT_PREFIX . '_licenseActivated', \false, 365 * \constant('DAY_IN_SECONDS'));
        $expireOption->enableTransientMigration(\DevOwl\RealThumbnailGenerator\Vendor\MatthiasWeb\Utils\ExpireOption::TRANSIENT_MIGRATION_SITE_WIDE);
        if ($set !== null) {
            $expireOption->set($set ? $value : 0);
        }
        return $expireOption->get() === $value;
    }
    /**
     * Send an email newsletter if checked in the updater.
     *
     * @param string $email
     */
    public function handleNewsletter($email)
    {
        wp_remote_post('https://devowl.io/wp-json/devowl-site/v1/plugin-activation-newsletter', ['body' => ['email' => $email, 'referer' => home_url(), 'slug' => RTG_SLUG]]);
    }
    // Documented in IOverrideCore
    public function getUpdater()
    {
        if ($this->updater === null) {
            $this->updater = \MatthiasWeb\WPU\V4\WPLSController::initClient('https://license.matthias-web.com/', ['name' => 'WP Real Thumbnail Generator', 'version' => RTG_VERSION, 'path' => RTG_FILE, 'slug' => RTG_SLUG, 'newsletterPrivacy' => 'https://devowl.io/privacy-policy/']);
            add_action('wpls_email_' . RTG_SLUG, [$this, 'handleNewsletter']);
        }
        return $this->updater;
    }
}
