<?php

namespace DevOwl\RealThumbnailGenerator\view;

use DevOwl\RealThumbnailGenerator\attachment\Thumbnail;
use DevOwl\RealThumbnailGenerator\base\UtilsProvider;
use WP_Post;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Server-side view handling.
 */
class View
{
    use UtilsProvider;
    private static $me = null;
    /**
     * When editing a attachment show up the available thumbnail size count and regenerate button.
     *
     * @param array $form_fields
     * @param WP_Post $post
     */
    public function attachment_fields_to_edit($form_fields, $post)
    {
        if ($post->post_type !== 'attachment' || !(wp_attachment_is_image($post->ID) || \DevOwl\RealThumbnailGenerator\attachment\Thumbnail::getInstance()->isPdf($post->ID)) || !current_user_can('upload_files')) {
            return $form_fields;
        }
        $check = \DevOwl\RealThumbnailGenerator\attachment\Thumbnail::getInstance()->check($post->ID, \false);
        // Create form field
        $form_fields['rtg'] = ['label' => __('Thumbnails', RTG_TD), 'input' => 'html', 'html' => '<div class="rtg-attachment-compat">
            <div class="alignleft">' . \sprintf(
            // translators:
            __('%1$d of %2$s registered', RTG_TD),
            is_wp_error($check) ? -1 : $check['cntGenerated'],
            is_wp_error($check) ? -1 : $check['cntRegistered']
        ) . '</div>
    <button class="button alignright" data-rtg="' . $post->ID . '" data-action="info" style="margin-left:5px">' . __('More', RTG_TD) . '</button>
    <button class="button alignright" data-rtg="' . $post->ID . '" data-action="regenerate">' . __('Regenerate', RTG_TD) . '</button>
</div>'];
        return $form_fields;
    }
    /**
     * Adds a link to each table row so a single one can be regenerated.
     *
     * @param array $actions
     * @param WP_Post $post
     */
    public function media_row_actions($actions, $post)
    {
        if (('image/' === \substr($post->post_mime_type, 0, 6) || \DevOwl\RealThumbnailGenerator\attachment\Thumbnail::getInstance()->isPdf($post)) && current_user_can('upload_files')) {
            $actions['rtg_regenerate'] = '<a href="javascript:undefined" data-rtg="' . $post->ID . '" data-action="regenerate">' . __('Regenerate', RTG_TD) . '</a>';
        }
        return $actions;
    }
    /**
     * Get singleton instance.
     *
     * @return View
     */
    public static function getInstance()
    {
        return self::$me === null ? self::$me = new \DevOwl\RealThumbnailGenerator\view\View() : self::$me;
    }
}
