<?php

namespace DevOwl\RealThumbnailGenerator\Vendor\DevOwl\Freemium;

use Exception;
use DevOwl\RealThumbnailGenerator\Vendor\MatthiasWeb\Utils\Base;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
trait CorePro
{
    // Documented in ICore
    public function overrideConstructFreemium()
    {
        add_filter('http_request_args', [$this, 'http_request_args_lite'], 10, 2);
        add_filter('plugin_row_meta', [$this, 'plugin_row_meta_lite'], 10, 2);
    }
    /**
     * We want to know the lite version so it can be shown right to the pro version.
     *
     * @param array $args
     * @param string $url
     * @return array
     * @see https://developer.wordpress.org/reference/functions/wp_update_plugins/
     */
    public function http_request_args_lite($args, $url)
    {
        /**
         * This trait always needs to be used along with base trait.
         *
         * @var Base
         */
        $base = $this;
        if (set_url_scheme($url, 'http') === 'http://api.wordpress.org/plugins/update-check/1.1/') {
            $basename = plugin_basename($base->getPluginConstant('FILE'));
            $liteSlug = $base->getPluginConstant(\DevOwl\RealThumbnailGenerator\Vendor\DevOwl\Freemium\FreemiumProvider::$PLUGIN_CONST_SLUG_LITE) . '/index.php';
            $plugins = \json_decode($args['body']['plugins'], ARRAY_A);
            // We are sure that our plugin is in it, but recheck...
            if (isset($plugins['plugins'][$basename])) {
                // Create the installed plugin (do not replace)
                $lite = $plugins['plugins'][$basename];
                $lite['Title'] .= ' (Free)';
                $lite['Name'] .= ' (Free)';
                $plugins['plugins'][$liteSlug] = $lite;
                // Create the active plugin (do not replace)
                $plugins['active'][] = $liteSlug;
                // Write to the arguments so it is sent to the wp.org server
                $args['body']['plugins'] = \json_encode($plugins);
            }
        }
        return $args;
    }
    /**
     * Add an "Lite version" title to the plugin row links. For debugging purposes.
     *
     * @param string[] $links
     * @param string $file
     * @return string[]
     */
    public function plugin_row_meta_lite($links, $file)
    {
        /**
         * This trait always needs to be used along with base trait.
         *
         * @var Base
         */
        $base = $this;
        // Completely ignore errors
        try {
            if (\false !== \strpos($file, plugin_basename($base->getPluginConstant('FILE')))) {
                $update_plugins = get_site_transient('update_plugins');
                if ($update_plugins !== \false && \is_object($update_plugins) && isset($update_plugins->response, $update_plugins->no_update)) {
                    $liteSlug = $base->getPluginConstant(\DevOwl\RealThumbnailGenerator\Vendor\DevOwl\Freemium\FreemiumProvider::$PLUGIN_CONST_SLUG_LITE) . '/index.php';
                    $no_update = $update_plugins->no_update;
                    $response = $update_plugins->response;
                    $version = 'n/a';
                    // Lite version has update
                    if (isset($response[$liteSlug])) {
                        $version = $response[$liteSlug]->new_version;
                    }
                    // No update, still show the current lite version
                    if (isset($no_update[$liteSlug])) {
                        $version = $no_update[$liteSlug]->new_version;
                    }
                    // Use tooltip in first version string
                    $links[0] = '<span title="Lite version is currently ' . $version . '">' . $links[0] . '</span>';
                }
            }
        } catch (\Exception $e) {
            // Silence is golden.
        }
        return $links;
    }
    // Documented in ICore
    public function isLiteNoticeDismissed($set = null)
    {
        return \true;
    }
}
