( function( $ ) {

	HappyForms.parts = HappyForms.parts || {};

	HappyForms.parts.signature = {
		init: function() {
			this.type   = this.$el.data( 'happyforms-type' );
			this.$input = $( 'input', this.$el );

			this.$input.on( 'keyup change', this.triggerChange.bind( this ) );
			this.$input.on( 'blur', this.onBlur.bind( this ) );
			this.$input.on( 'focus', this.onInputFocus.bind( this ) );

			this.initTooltip();
		},

		isFilled: function() {
			var filledInputs = this.$input.filter( function() {
				var $input = $( this );
				var hasValue = false;

				if ( $input.is( '[type=checkbox]' ) ) {
					hasValue = $input.is( ':checked' );
				} else {
					hasValue = '' !== $input.val();
				}

				return hasValue;
			} );

			return 2 === filledInputs.length;
		},
	};

} )( jQuery );
