( function( $, _, Backbone, api, settings ) {

	var CheckboxView = happyForms.classes.views.parts.checkbox;
	var CheckboxOptionView = happyForms.classes.views.parts.checkboxOption;

	happyForms.classes.views.parts.checkboxOption = CheckboxOptionView.extend( {
		events: _.extend( {}, CheckboxOptionView.prototype.events, {
			'change [name=limit_submissions]': 'onItemLimitSubmissionsChange',
			'keyup [name=limit_submissions_amount]': 'onItemLimitSubmissionsAmountChange',
		} ),

		onItemLimitSubmissionsChange: function( e ) {
			var isChecked = $( e.target ).is( ':checked' );

			this.model.set( 'limit_submissions', isChecked ? 1 : 0 );
			$( '.happyforms-part-item-limit-submission-settings', this.$el ).toggle();
		},

		onItemLimitSubmissionsAmountChange: function( e ) {
			this.model.set( 'limit_submissions_amount', $( e.target ).val() );
			this.part.trigger( 'change' );
		},
	} );

	happyForms.classes.views.parts.checkbox = CheckboxView.extend( {
		initialize: function() {
			CheckboxView.prototype.initialize.apply( this, arguments );

			this.listenTo( this.model, 'change:other_option', this.onAddOtherOption );
			this.listenTo( this.model, 'change:other_option_label', this.onOtherOptionLabelChange );
			this.listenTo( this.model, 'change:other_option_placeholder', this.onOtherOptionPlaceholderChange );
			this.listenTo( this.model, 'change:display_as_letters', this.refreshPart );
			this.listenTo( this.model, 'change:limit_choices', this.onLimitChoices );
		},

		onAddOtherOption: function( model, value ) {
			var $otherOptionOptions = $( '.happyforms-nested-settings[data-trigger="other_option"]', this.$el );

			if ( 1 == value ) {
				$otherOptionOptions.show();
			} else {
				$otherOptionOptions.hide();
			}

			this.refreshPart();
		},

		onOtherOptionLabelChange: function( model, value ) {
			var data = {
				id: this.model.get( 'id' ),
				callback: 'onCheckboxOtherOptionLabelChangeCallback'
			};

			happyForms.previewSend( 'happyforms-part-dom-update', data );
		},

		onOtherOptionPlaceholderChange: function( model, value ) {
			var data = {
				id: this.model.get( 'id' ),
				callback: 'onCheckboxOtherOptionPlaceholderChangeCallback'
			};

			happyForms.previewSend( 'happyforms-part-dom-update', data );
		},

		onLimitChoices: function( model, value ) {
			var $limitChoicesOptions = $( '.happyforms-nested-settings[data-trigger="limit_choices"]', this.$el );

			if ( 1 == value ) {
				$limitChoicesOptions.show();
			} else {
				$limitChoicesOptions.hide();
			}
		},
	} );

	happyForms.previewer = _.extend( happyForms.previewer, {
		onCheckboxOtherOptionLabelChangeCallback: function( id, html, options ) {
			var part = this.getPartModel( id );
			var $part = this.getPartElement( html );
			var $otherOptionLabel = $( '.happyforms-part-option--other .label', $part );

			$otherOptionLabel.text( part.get( 'other_option_label' ) );
		},

		onCheckboxOtherOptionPlaceholderChangeCallback: function( id, html, options ) {
			var part = this.getPartModel( id );
			var $part = this.getPartElement( html );
			var $otherOptionInput = $( '.happyforms-part-option--other input[type=text]', $part );

			$otherOptionInput.attr( 'placeholder', part.get( 'other_option_placeholder' ) );
		},
	} );

} ) ( jQuery, _, Backbone, wp.customize, _happyFormsSettings );
