( function( $, _, Backbone, api, settings ) {

	var MultiLineTextView = happyForms.classes.views.parts.multi_line_text;

	happyForms.classes.views.parts.multi_line_text = MultiLineTextView.extend( {
		initialize: function() {
			MultiLineTextView.prototype.initialize.apply( this, arguments );

			this.listenTo( this.model, 'change:rich_text', this.onRichTextChange );
			this.listenTo( this.model, 'change:rows', this.onRowsChange );
		},

		onRichTextChange: function( model, value ) {
			if ( 1 == value ) {
				$( '.happyforms-placeholder-option', this.$el ).hide();
			} else {
				$( '.happyforms-placeholder-option', this.$el ).show();
			}

			model.fetchHtml( function( response ) {
				var data = {
					id: model.get( 'id' ),
					html: response,
				};

				happyForms.previewSend( 'happyforms-form-part-refresh', data );
			} );
		},

		onRowsChange: function( model, value ) {
			if ( model.get( 'rich_text' ) ) {
				model.fetchHtml( function( response ) {
					var data = {
						id: model.get( 'id' ),
						html: response,
					};

					happyForms.previewSend( 'happyforms-form-part-refresh', data );
				} );
			} else {
				var data = {
					id: this.model.id,
					callback: 'onMultiLineTextRowsChange',
					options: {
						value: value
					}
				};

				happyForms.previewSend( 'happyforms-part-dom-update', data );
			}
		}
	} );

} ) ( jQuery, _, Backbone, wp.customize, _happyFormsSettings );
