( function( $, _, Backbone, api, settings ) {

	var SelectOptionView = happyForms.classes.views.parts.selectOption;

	happyForms.classes.views.parts.selectOption = SelectOptionView.extend( {
		events: _.extend( {}, SelectOptionView.prototype.events, {
			'change [name=limit_submissions]': 'onItemLimitSubmissionsChange',
			'keyup [name=limit_submissions_amount]': 'onItemLimitSubmissionsAmountChange',
		} ),

		onItemLimitSubmissionsChange: function( e ) {
			var isChecked = $( e.target ).is( ':checked' );

			this.model.set( 'limit_submissions', isChecked ? 1 : 0 );
			$( '.happyforms-part-item-limit-submission-settings', this.$el ).toggle();
		},

		onItemLimitSubmissionsAmountChange: function( e ) {
			this.model.set( 'limit_submissions_amount', $( e.target ).val() );
			this.part.trigger( 'change' );
		},
	} );

} ) ( jQuery, _, Backbone, wp.customize, _happyFormsSettings );
