<?php

if ( ! function_exists( 'happyforms_schedule_remove_unassigned_attachments' ) ) :

function happyforms_schedule_remove_unassigned_attachments() {
	require_once( happyforms_get_include_folder() . '/classes/class-attachment-controller.php' );

	$controller = happyforms_get_attachment_controller();

	if ( ! wp_next_scheduled( $controller->schedule_remove_unassigned ) ) {
		wp_schedule_event( time(), 'hourly', $controller->schedule_remove_unassigned );
	}
}

endif;

add_action( 'happyforms_activate', 'happyforms_schedule_remove_unassigned_attachments' );

if ( ! function_exists( 'happyforms_cleanup_on_install' ) ) :

function happyforms_cleanup_on_install() {
	require_once( happyforms_get_include_folder() . '/classes/class-privacy-settings.php' );

	$cleanup_on_uninstall = happyforms_get_privacy_settings()->cleanup_on_uninstall();

	return apply_filters( 'happyforms_cleanup_on_uninstall', $cleanup_on_uninstall );
}

endif;

if ( ! function_exists( 'happyforms_cleanup' ) ) :

function happyforms_cleanup() {
	if ( ! happyforms_cleanup_on_install() ) {
		return;
	}

	// Admin stats
	delete_option( 'happyforms_stat_settings' );
	delete_option( 'happyforms_stat_settings' );
	delete_option( 'happyforms_stat_new_contacts' );
	delete_option( 'happyforms_stat_reached_goals' );
	delete_option( 'happyforms_stat_responses_abandoned' );
	delete_option( 'happyforms_stat_responses_mobile' );
	delete_option( 'happyforms_stat_responses_started' );
	delete_option( 'happyforms_stat_responses_submitted' );
	delete_option( 'happyforms_stat_settings' );
	delete_option( 'happyforms_stat_validation_errors' );

	// Forms
	$forms = get_posts( array(
		'post_type' => 'happyform',
		'post_status' => array_values( get_post_stati() ),
		'numberposts' => -1,
	) );

	foreach( $forms as $form ) {
		wp_delete_post( $form->ID, true );
	}

	// General options
	delete_option( 'happyforms-data-version' );
	delete_option( 'widget_happyforms_widget' );
	delete_option( 'happyforms_goal_pages' );
	delete_transient( '_happyforms_has_responses' );
	delete_option( 'happyforms-tracking' );
	delete_option( 'ttf_updates_key_happyforms' );

	// User meta
	$users = get_users();

	foreach( $users as $user ) {
		delete_user_meta( $user->ID, 'happyforms-dismissed-notices' );
		delete_transient( 'happyforms_admin_notices_' . md5( $user->user_login ) );
		delete_user_meta( $user->ID, 'happyforms-settings-sections-states' );
	}

	// Blocklist
	delete_option( 'happyforms_blocklist' );

	// Activity
	$responses = get_posts( array(
		'post_type' => 'happyforms-message',
		'post_status' => array_values( get_post_stati() ),
		'numberposts' => -1,
	) );

	foreach( $responses as $response ) {
		wp_delete_post( $response->ID, true );
	}

	delete_transient( 'happyforms_response_counters' );

	// Migrations
	delete_option( 'happyforms-data-version' );

	// Polls
	$polls = get_posts( array(
		'post_type' => 'happyforms-poll',
		'post_status' => 'any',
		'numberposts' => -1,
	) );

	foreach( $polls as $poll ) {
		wp_delete_post( $poll->ID, true );
	}

	// Privacy settings
	delete_option( 'happyforms_privacy_settings' );
	wp_clear_scheduled_hook( 'happyforms_schedule_privacy_cleanup' );

	// Role permissions
	delete_option( 'happyforms_role_permissions' );

	// Validation messages
	delete_option( 'happyforms-validation-messages' );

	// Integrations
	delete_option( '_happyforms_service_credentials' );

	// Anti-spam
	delete_option( '_happyforms_antispam_service_active' );

	// Email
	delete_option( '_happyforms_email_service_active' );
}

endif;

add_action( 'happyforms_uninstall', 'happyforms_cleanup' );
