<?php

if ( ! function_exists( 'happyforms_previous_message_edit_link' ) ):

function happyforms_previous_message_edit_link( $post_id, $text ) {
	global $happyforms_message_nav;

	if ( array_search( $post_id, $happyforms_message_nav ) > 0 ) {
		edit_post_link( $text, '', '', $happyforms_message_nav[0] );
	}
}

endif;

if ( ! function_exists( 'happyforms_next_message_edit_link' ) ):

function happyforms_next_message_edit_link( $post_id, $text ) {
	global $happyforms_message_nav;

	if ( array_search( $post_id, $happyforms_message_nav )
		=== count( $happyforms_message_nav ) - 2 ) {
		edit_post_link( $text, '', '', $happyforms_message_nav[2] );
	}
}

endif;

if ( ! function_exists( 'happyforms_get_reply_and_mark_link' ) ):

function happyforms_get_reply_and_mark_link( $id ) {
	$message_controller = happyforms_get_message_controller();

	if ( ! $post = get_post( $id ) ) {
		return;
	}

	if ( $message_controller->post_type !== $post->post_type ) {
		return;
	}

	$action = '&action=edit';
	$post_type_object = get_post_type_object( $post->post_type );
	$link = admin_url( sprintf( $post_type_object->_edit_link . $action, $post->ID ) );
	$url = add_query_arg( $message_controller->reply_and_mark_action, 1, $link );

	return $url;
}

endif;

if ( ! function_exists( 'happyforms_get_pdf_part_value' ) ):

function happyforms_get_pdf_part_value( $value, $part = array(), $form = array() ) {
	$value = happyforms_get_message_part_value( $value, $part, 'pdf' );
	$value = apply_filters( 'happyforms_get_pdf_part_value', $value, $part, $form );

	// Interpolate line breaks
	$value = str_replace( '\n', "\n", $value );
	// Replace html line breaks with plain line breaks
	$value = preg_replace( '/<br(\s+)?\/?>/i', "\n", $value );
	// Strip all tags
	$value = wp_strip_all_tags( $value, false );
	// Strip tabs and redundant whitespace
	$value = preg_replace( "/[ \t]+/", " ", $value );
	// Decode HTML entities
	$value = htmlspecialchars_decode( $value, ENT_QUOTES );
	// Unescape
	$value = wp_unslash( $value );

	return $value;
}

endif;

if ( ! function_exists( 'happyforms_get_response_mark_link' ) ):

function happyforms_get_response_mark_link( $response_id ) {
	$url = admin_url( 'post.php' );
	$action = happyforms_get_message_controller()->mark_action;
	$url = wp_nonce_url( $url, "{$action}-{$response_id}" );
	$url = add_query_arg( 'action', $action, $url );
	$url = add_query_arg( 'post', $response_id, $url );

	return $url;
}

endif;

if ( ! function_exists( 'happyforms_get_form_status_link' ) ):

	function happyforms_get_form_status_link( $form_ids = array() ) {
		$url = admin_url( 'edit.php' );
		$form_ids = join( ',', $form_ids );
		$action = happyforms_get_form_status()->status_action;
		$url = wp_nonce_url( $url, "{$action}-{$form_ids}" );
		$url = add_query_arg( 'action', $action, $url );
		$url = add_query_arg( 'form_ids', $form_ids, $url );

		return $url;
	}

endif;

if ( ! function_exists( 'happyforms_unread_messages_badge' ) ):
/**
 * Outputs the unread messages badge, if there are any.
 *
 * @since 1.1
 *
 * @return void
 */
function happyforms_unread_messages_badge() {
	$counters = happyforms_get_message_controller()->get_counters();
	$unread = $counters['unread'];
	$badge = '';

	if ( $unread ) {
		$badge = sprintf(
			' <span class="awaiting-mod count-1"><span class="pending-count">%s</span></span>',
			$unread
		);
	}

	return $badge;
}

endif;

if ( ! function_exists( 'happyforms_abandonment_email_template_path' ) ):

function happyforms_abandonment_email_template_path() {
	$path = happyforms_get_include_folder() . '/templates/email-abandonment.php';
	$path = apply_filters( 'happyforms_abandonment_email_template_path', $path );

	return $path;
}

endif;

if ( ! function_exists( 'happyforms_get_option_counter_meta_key' ) ):

function happyforms_get_option_counter_meta_key( $form_id, $option_id ) {
	$meta_key = "_happyforms_option_counter_{$form_id}_{$option_id}";

	return $meta_key;
}

endif;

if ( ! function_exists( 'happyforms_credentials_input' ) ) :

function happyforms_credentials_input( $service_id, $key, $label, $value ) {
	$html_id = "happyforms_integrations_{$service_id}_{$key}";
	?>
	<label for="<?php echo $html_id; ?>"><?php echo $label; ?>:</label>
	<div class="hf-pwd">
		<input type="password" class="widefat happyforms-credentials-input connected" id="<?php echo $html_id; ?>" name="credentials[<?php echo $service_id; ?>][<?php echo $key; ?>]" value="<?php echo $value; ?>" />
		<button type="button" class="button button-secondary hf-hide-pw hide-if-no-js" data-toggle="0" aria-label="<?php _e( 'Show credentials', 'happyforms' ); ?>" data-label-show="<?php _e( 'Show credentials', 'happyforms' ); ?>" data-label-hide="<?php _e( 'Hide credentials', 'happyforms' ); ?>">
			<span class="dashicons dashicons-visibility" aria-hidden="true"></span>
		</button>
	</div>
	<?php
}

endif;

if ( ! function_exists( 'happyforms_message_is_spam' ) ):

function happyforms_message_is_spam( $message_id ) {
	$status = happyforms_get_meta( $message_id, 'read' );
	$is_spam = 2 == $status;

	return $is_spam;
}

endif;
