<?php

if ( ! function_exists( 'happyforms_get_file_mime_groups' ) ):

function happyforms_get_file_mime_groups() {
	$types = wp_get_ext_types();
	$documents = array_merge( $types['document'], $types['spreadsheet'], $types['text'] );
	$archives = $types['archive'];
	$images = $types['image'];
	$media = array_merge( $types['audio'], $types['video'] );
	$groups = array(
		'documents' => $documents,
		'archives' => $archives,
		'images' => $images,
		'media' => $media,
	);

	return $groups;
}

endif;

if ( ! function_exists( 'happyforms_get_file_mime_group' ) ):

function happyforms_get_file_mime_group( $type ) {
	$groups = happyforms_get_file_mime_groups();

	foreach( $groups as $group => $types ) {
		if ( in_array( $type, $types ) ) {
			return $group;
		}
	}

	return false;
}

endif;

if ( ! function_exists( 'happyforms_get_file_types' ) ):

function happyforms_get_file_types( $group = '' ) {
	$groups = happyforms_get_file_mime_groups();

	switch( $group ) {
		case 'documents':
		case 'archives':
		case 'images':
		case 'media':
			$group = $groups[$group];
			break;
		case '':
			$group = call_user_func_array( 'array_merge', array_values( $groups ) );
			break;
		default:
			$group = array();
			break;
	}

	return $group;
}

endif;

if ( ! function_exists( 'happyforms_get_file_mime' ) ):

function happyforms_get_file_mime( $extension, $only_mime = false ) {
	$mimes = wp_get_mime_types();
	$file_mime = array();

	foreach( $mimes as $ext => $mime ) {
		if ( preg_match( "/^($ext)$/", $extension ) ) {
			$file_mime[$ext] = $mime;
			break;
		}
	}

	if ( true === $only_mime ) {
		return $mime;
	}

	return $file_mime;
}

endif;