<?php
$message_blocklist = happyforms_get_message_blocklist();
$action = $message_blocklist->save_action;
$nonce = $message_blocklist->save_nonce;
$blocklist = $message_blocklist->read();
?>

<div>
	<div class="happyforms-settings-notices"></div>

	<form class="hf-ajax-submit">
		<?php wp_nonce_field( $action, $nonce ); ?>
		<input type="hidden" name="action" value="<?php echo $action; ?>">
		<p>
			<?php _e( 'Each new submission will be scanned against the following lists and if a match is found that submission will automatically be marked as', 'happyforms' ); ?> <?php if ( current_user_can( 'happyforms_manage_activity' ) ) : ?><?php printf( __( '<a href="%s">spam</a>', 'happyforms' ), admin_url( 'edit.php?post_type=happyforms-message&activity_status=spam' ) ); ?><?php else : ?><?php _e( 'spam', 'happyforms' ); ?><?php endif; ?>.
		</p>
		<div class="controls">
			<div class="control">
				<div class="control__line">
					<input type="checkbox" name="blocklist[block_emails]" value="1" id="blocklist_block_emails" <?php checked( $blocklist['block_emails'], 1 ); ?>>
					<label for="blocklist_block_emails"><?php _e( 'Scan for the following email addresses, email domains and email partials', 'happyforms' ); ?></label>
					<div class="nested-input">
						<textarea name="blocklist[emails]" rows="10" cols="50" id="blocklist_emails" class="large-text code"><?php echo $blocklist['emails']; ?></textarea><p><?php _e( 'One per line. Not case sensitive. Blank spaces disallowed.', 'happyforms' ); ?></p>
					</div>
				</div>
			</div>
			<div class="control">
				<div class="control__line">
					<input type="checkbox" name="blocklist[block_language]" value="1" id="blocklist_block_language" <?php checked( $blocklist['block_language'], 1 ); ?>>
					<label for="blocklist_block_language"><?php _e( 'Scan for the following words, phrases and letters', 'happyforms' ); ?></label>
					<div class="nested-input">
						<textarea name="blocklist[language]" rows="10" cols="50" id="blocklist_language" class="large-text code"><?php echo $blocklist['language']; ?></textarea><p><?php _e( 'One per line. Not case sensitive. Punctuation, numbers and alt characters disallowed.', 'happyforms' ); ?></p>
					</div>
				</div>
			</div>
		</div>
		<div class="alignleft">
			<span class="spinner"></span>
			<input type="submit" class="button button-primary" value="<?php _e( 'Save Changes', 'happyforms' ); ?>">
		</div>
		<br class="clear">
	</form>
</div>
