<?php
$form_controller = happyforms_get_form_controller();
$message_controller = happyforms_get_message_controller();
$action_type = ( isset( $_GET['action_type'] ) ) ? esc_attr( $_GET['action_type'] ) : '';
?>

<?php
$form_classes = array(
	'happyforms-export-section__form'
);

switch( $action_type ) {
	case 'import':
		$form_classes[] = 'doing-action-import';
		break;
}
?>

<form class="<?php echo join( ' ', $form_classes ); ?>" action="<?php echo admin_url( 'admin.php' ); ?>" id="happyforms-export-form" method="post">
	<input type="hidden" name="action" value="happyforms_export_import">
	<?php wp_nonce_field( 'happyforms_export_import', 'happyforms_export_nonce' ); ?>

	<div id="happyforms-export-select-action">
		<label for="happyforms-export-select-action-select"><?php _e( 'Action', 'happyforms' ); ?>:</label>
		<select name="action_type" id="happyforms-export-select-action-select">
			<option value="" selected>— <?php _e( 'Select', 'happyforms' ); ?> —</option>
			<option value="import" <?php selected( $action_type, 'import' ); ?>><?php _e( 'Import data (.xml)', 'happyforms' ); ?></option>
			<option value="export_responses" <?php selected( $action_type, 'export_responses' ); ?>><?php _e( 'Export submissions to spreadsheet (.csv)', 'happyforms' ); ?></option>
			<option value="export_form" <?php selected( $action_type, 'export_form' ); ?>><?php _e( 'Export a form (.xml)', 'happyforms' ); ?></option>
			<option value="export_form_responses" <?php selected( $action_type, 'export_form_responses' ); ?>><?php _e( 'Export a form and its submissions (.xml)', 'happyforms' ); ?></option>
		</select>
	</div>

	<div id="happyforms-export-select-form">
		<label for="happyforms-export-select-form-select"><?php _e( 'Form', 'happyforms' ); ?>:</label>
		<select name="form_id" id="happyforms-export-select-form-select">
			<option value="" data-has-responses selected><?php _e( '— Select —', 'happyforms' ); ?>
			<?php
			$forms = $form_controller->get();

			foreach ( $forms as $form ) {
				$responses = $message_controller->get_by_form( $form['ID'], true );
				?>
				<option value="<?php echo esc_attr( $form['ID'] ); ?>"<?php echo ( ! empty( $responses ) ) ? ' data-has-responses' : ''; ?>><?php echo happyforms_get_form_property( $form, 'post_title' ); ?></option>
				<?php
			}
			?>
		</select>
	</div>

	<div id="happyforms-export-section-import">
		<div id="happyforms-export-import-form">
			<div class="media-upload-form type-form validate">
				<?php wp_enqueue_script( 'plupload' ); ?>
				<?php wp_enqueue_script( 'plupload-handlers' ); ?>

				<p>
					<label for="upload"><?php _e( 'Choose a file from your computer', 'happyforms' ); ?>:</label>
					(<?php _e( 'Maximum size', 'happyforms' ); ?>: <?php echo size_format( wp_max_upload_size() ); ?>)
					<input type="file" name="file-import-stub" size="25" id="happyforms-export-import-upload-stub" accept=".xml">
				</p>
				<?php media_upload_form(); ?>
			</div>
		</div>

		<div id="happyforms-import-status">
			<div class="static-messages">
				<p><?php _e( 'Importing file…', 'happyforms' ); ?></p>
			</div>
			<div class="runtime-messages"></div>
		</div>

		<div id="happyforms-import-result">
			<div id="happyforms-import-messages">
			</div>
		</div>

		<input type="hidden" id="happyforms-import-attachment-id">
	</div>

	<?php
	$button_labels = array(
		'export' => __( 'Download Export File', 'happyforms' ),
		'import' => __( 'Upload File and Import', 'happyforms' ),
	);

	$button_default_label = ( isset( $button_labels[$action_type] ) ) ? $button_labels[$action_type] : __( 'Submit', 'happyforms' );
	?>
	<button type="submit" class="button button-primary" data-label-export_responses="<?php echo $button_labels['export']; ?>" data-label-export_form="<?php echo $button_labels['export']; ?>" data-label-export_form_responses="<?php echo $button_labels['export']; ?>" data-label-import="<?php echo $button_labels['import']; ?>"><?php echo $button_default_label; ?></button>
	<p class="reset">
		<a href="<?php echo admin_url( '/admin.php?page=happyforms-export&action_type=import' ); ?>"><?php _e( 'Retry', 'happyforms' ); ?></a>
	</p>
	<p class="import-more">
		<a href="<?php echo admin_url( '/admin.php?page=happyforms-settings&action_type=import' ); ?>"><?php _e( 'Import another file', 'happyforms' ); ?></a>
	</p>
</form>
