<script type="text/template" id="happyforms-customize-address-template">
	<?php include( happyforms_get_core_folder() . '/templates/customize-form-part-header.php' ); ?>
	<p>
		<label for="<%= instance.id %>_title"><?php _e( 'Label', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_title" class="widefat title" value="<%= instance.label %>" data-bind="label" />
	</p>
	<p class="happyforms-placeholder-option" style="display: <%= ( 'as_placeholder' !== instance.label_placement ) ? 'block' : 'none' %>">
		<label for="<%= instance.id %>_placeholder"><?php _e( 'Placeholder', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_placeholder" class="widefat title" value="<%= instance.placeholder %>" data-bind="placeholder" />
	</p>
	<p>
		<label for="<%= instance.id %>_description"><?php _e( 'Hint', 'happyforms' ); ?></label>
		<textarea id="<%= instance.id %>_description" data-bind="description"><%= instance.description %></textarea>
	</p>

	<?php do_action( 'happyforms_part_customize_address_before_options' ); ?>

	<p>
		<label for="<%= instance.id %>_mode"><?php _e( 'Mode', 'happyforms' ); ?></label>
		<select id="<%= instance.id %>_mode" name="mode" data-bind="mode" class="widefat">
			<option value="simple"<%= (instance.mode == 'simple') ? ' selected' : '' %>><?php _e( 'Full', 'happyforms' ); ?></option>
			<option value="autocomplete"<%= (instance.mode == 'autocomplete') ? ' selected' : '' %>><?php _e( 'Full with autocomplete', 'happyforms' ); ?></option>
			<option value="country-city"<%= (instance.mode == 'country-city') ? ' selected' : '' %>><?php _e( 'Country and city', 'happyforms' ); ?></option>
			<option value="country"<%= (instance.mode == 'country') ? ' selected' : '' %>><?php _e( 'Country only', 'happyforms' ); ?></option>
		</select>
	</p>
	<p>
		<label>
			<input type="checkbox" name="has_geolocation" class="checkbox" value="1" <% if ( instance.has_geolocation ) { %>checked="checked"<% } %> data-bind="has_geolocation" /> <?php _e( 'Allow geolocation', 'happyforms' ); ?>
		</label>
	</p>
	<div class="happyforms-nested-settings" data-trigger="has_geolocation" style="display: <%= ( 'autocomplete' === instance.mode || instance.has_geolocation ) ? 'block' : 'none' %>">
		<p>
			<label for="<%= instance.id %>_apikey"><?php _e( 'Google API key', 'happyforms' ); ?></label>
			<input type="text" id="<%= instance.id %>_apikey class="widefat title" value="<%= instance.apikey %>" data-bind="apikey" />
		</p>
		<p class="description">
			<?php printf(
				'%s <a href="https://developers.google.com/places/web-service/get-api-key" target="_blank" class="external">%s</a>.',
				__( 'Address autocompletion requires a', 'happyforms' ),
				__( 'Google Places API key', 'happyforms' )
			); ?>
			<?php printf(
				'%s <a href="https://developers.google.com/maps/documentation/geocoding/start" target="_blank" class="external">%s</a>.',
				__( 'Geolocation requires a', 'happyforms' ),
				__( 'Google Geocoding API key', 'happyforms' )
			); ?>
		</p>
	</div>
	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.required ) { %>checked="checked"<% } %> data-bind="required" /> <?php _e( 'Require an answer', 'happyforms' ); ?>
		</label>
	</p>

	<?php do_action( 'happyforms_part_customize_address_after_options' ); ?>

	<?php do_action( 'happyforms_part_customize_address_before_advanced_options' ); ?>

	<?php happyforms_customize_part_width_control(); ?>

	<?php do_action( 'happyforms_part_customize_address_after_advanced_options' ); ?>

	<p>
		<label for="<%= instance.id %>_css_class"><?php _e( 'CSS classes', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_css_class" class="widefat title" value="<%= instance.css_class %>" data-bind="css_class" />
	</p>

	<div class="happyforms-part-logic-wrap">
		<div class="happyforms-logic-view">
			<?php happyforms_customize_part_logic(); ?>
		</div>
	</div>

	<?php happyforms_customize_part_footer(); ?>
</script>
