<script type="text/template" id="happyforms-customize-rating-template">
	<?php include( happyforms_get_core_folder() . '/templates/customize-form-part-header.php' ); ?>
	<p>
		<label for="<%= instance.id %>_title"><?php _e( 'Label', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_title" class="widefat title" value="<%= instance.label %>" data-bind="label" />
	</p>
	<p>
		<label for="<%= instance.id %>_description"><?php _e( 'Hint', 'happyforms' ); ?></label>
		<textarea id="<%= instance.id %>_description" data-bind="description"><%= instance.description %></textarea>
	</p>

	<?php do_action( 'happyforms_part_customize_rating_before_options' ); ?>

	<p>
		<label for="<%= instance.id %>_rating_type"><?php _e( 'Type', 'happyforms' ); ?></label>
		<select id="<%= instance.id %>_rating_type" data-bind="rating_type">
			<option value="scale"<%= (instance.rating_type == 'scale') ? ' selected' : '' %>><?php _e( 'Scale', 'happyforms' ); ?></option>
			<option value="yesno"<%= (instance.rating_type == 'yesno') ? ' selected' : '' %>><?php _e( 'Polar', 'happyforms' ); ?></option>
		</select>
	</p>
	<p>
		<label for="<%= instance.id %>_rating_visuals"><?php _e( 'Visuals', 'happyforms' ); ?></label>
		<select id="<%= instance.id %>_rating_visuals" data-bind="rating_visuals">
			<option class="scale-default" data-allowed-for="scale" value="stars"<%= (instance.rating_visuals == 'stars') ? ' selected' : '' %><%= (instance.rating_type == 'yesno' ) ? ' disabled' : '' %>><?php _e( 'Stars', 'happyforms' ); ?></option>
			<option class="yesno-default" data-allowed-for="scale,yesno" value="smileys"<%= (instance.rating_visuals == 'smileys') ? ' selected' : '' %>><?php _e( 'Smileys', 'happyforms' ); ?></option>
			<option value="thumbs" data-allowed-for="yesno" <%= (instance.rating_visuals == 'thumbs') ? ' selected' : '' %><%= (instance.rating_type == 'scale' ) ? ' disabled' : '' %>><?php _e( 'Thumbs', 'happyforms' ); ?></option>
		</select>
	</p>
	<div class="happyforms-nested-settings" data-trigger="rating_type:scale" style="display: <%= ( instance.rating_type == 'scale' && instance.rating_visuals == 'smileys' ) ? 'block' : 'none' %>">
		<p>
			<label for="rating-labels-scale-0"><?php _e( 'Labels', 'happyforms' ); ?></label>
			<% if ( instance.rating_labels_scale ) { %>
				<% _.each( instance.rating_labels_scale, function( label, index ) { %>
					<input type="text" class="widefat title happyforms-self-spaced-input rating-label" id="rating-labels-scale-<%= index %>" value="<%= label %>" data-attribute="rating_labels_scale" data-index="<%= index %>">
				<% }); %>
			<% } %>
		</p>
	</div>
	<div class="happyforms-nested-settings" data-trigger="rating_type:yesno" style="display: <%= ( instance.rating_type == 'yesno' ) ? 'block' : 'none' %>">
		<p>
			<label for="rating-labels-yesno-0"><?php _e( 'Labels', 'happyforms' ); ?></label>
			<% if ( instance.rating_labels_yesno ) { %>
				<% _.each( instance.rating_labels_yesno, function( label, index ) { %>
					<input type="text" class="widefat title happyforms-self-spaced-input rating-label" id="rating-labels-yesno-<%= index %>" value="<%= label %>" data-attribute="rating_labels_yesno" data-index="<%= index %>">
				<% }); %>
			<% } %>
		</p>
	</div>
	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.required ) { %>checked="checked"<% } %> data-bind="required" /> <?php _e( 'Require an answer', 'happyforms' ); ?>
		</label>
	</p>

	<?php do_action( 'happyforms_part_customize_rating_after_options' ); ?>

	<?php do_action( 'happyforms_part_customize_rating_before_advanced_options' ); ?>

	<?php happyforms_customize_part_width_control(); ?>

	<?php do_action( 'happyforms_part_customize_rating_after_advanced_options' ); ?>

	<p>
		<label for="<%= instance.id %>_css_class"><?php _e( 'CSS classes', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_css_class" class="widefat title" value="<%= instance.css_class %>" data-bind="css_class" />
	</p>

	<div class="happyforms-part-logic-wrap">
		<div class="happyforms-logic-view">
			<?php happyforms_customize_part_logic(); ?>
		</div>
	</div>

	<?php happyforms_customize_part_footer(); ?>
</script>
