<script type="text/template" id="customize-happyforms-rich-text-template">
	<?php include( happyforms_get_core_folder() . '/templates/customize-form-part-header.php' ); ?>
	<p>
		<label for="<%= instance.id %>_title"><?php _e( 'Label', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_title" class="widefat title" value="<%= instance.label %>" data-bind="label" />
	</p>
	<p>
		<label for="<%= instance.id %>_description"><?php _e( 'Hint', 'happyforms' ); ?></label>
		<textarea id="<%= instance.id %>_description" data-bind="description"><%= instance.description %></textarea>
	</p>
	<p>
		<label for="<%= instance.id %>_rows"><?php _e( 'Rows', 'happyforms' ); ?></label>
		<input type="number" id="<%= instance.id %>_rows" min="5" max="20" class="widefat title" value="<%= instance.rows %>" data-bind="rows" />
	</p>

	<?php do_action( 'happyforms_part_customize_rich_text_before_options' ); ?>

	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.required ) { %>checked="checked"<% } %> data-bind="required" /> <?php _e( 'Require an answer', 'happyforms' ); ?>
		</label>
	</p>

	<?php do_action( 'happyforms_part_customize_rich_text_after_options' ); ?>

	<?php do_action( 'happyforms_part_customize_rich_text_before_advanced_options' ); ?>

	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.limit_input ) { %>checked="checked"<% } %> data-bind="limit_input" /> <?php _e( 'Limit words/characters', 'happyforms' ); ?>
		</label>
	</p>

	<div class="happyforms-nested-settings character-limit-settings" <% if ( ! instance.limit_input ) { %>style="display: none;"<% } %>>
		<p>
			<label for="<%= instance.id %>_character_limit"><?php _e( 'Limit', 'happyforms' ); ?></label>
			<input type="number" id="<%= instance.id %>_character_limit" class="widefat title" step="1" min="1" value="<%= instance.character_limit %>" data-bind="character_limit" />
		</p>
		<p>
			<label for="<%= instance.id %>_character_limit_mode"><?php _e( 'Count', 'happyforms' ); ?></label>
			<select id="<%= instance.id %>_character_limit_mode" data-bind="character_limit_mode">
				<option value="word_max"<%= (instance.character_limit_mode == 'word_max') ? ' selected' : '' %>><?php _e( 'Max words', 'happyforms' ); ?></option>
				<option value="word_min"<%= (instance.character_limit_mode == 'word_min') ? ' selected' : '' %>><?php _e( 'Min words', 'happyforms' ); ?></option>
				<option value="character_max"<%= (instance.character_limit_mode == 'character_max') ? ' selected' : '' %>><?php _e( 'Max characters', 'happyforms' ); ?></option>
				<option value="character_min"<%= (instance.character_limit_mode == 'character_min') ? ' selected' : '' %>><?php _e( 'Min characters', 'happyforms' ); ?></option>
			</select>
		</p>
		<p class="character-limit__characters-label" style="display: <%= ( 'character_min' === instance.character_limit_mode || 'character_max' === instance.character_limit_mode ) ? 'block' : 'none' %>">
			<label for="<%= instance.id %>_characters_label"><?php _e( '\'Characters\' label', 'happyforms' ); ?></label>
			<input type="text" id="<%= instance.id %>_characters_label" class="widefat title" value="<%= instance.characters_label %>" data-bind="characters_label" />
		</p>
		<p class="character-limit__words-label" style="display: <%= ( 'word_max' === instance.character_limit_mode || 'word_min' === instance.character_limit_mode ) ? 'block' : 'none' %>">
			<label for="<%= instance.id %>_words_label"><?php _e( '\'Words\' label', 'happyforms' ); ?></label>
			<input type="text" id="<%= instance.id %>_words_label" class="widefat title" value="<%= instance.words_label %>" data-bind="words_label" />
		</p>
	</div>
	<p>
		<label for="<%= instance.id %>_width"><?php _e( 'Width', 'happyforms' ); ?></label>
		<select id="<%= instance.id %>_width" name="width" data-bind="width" class="widefat">
			<option value="full"<%= (instance.width == 'full') ? ' selected' : '' %>><?php _e( 'Full', 'happyforms' ); ?></option>
			<option value="half"<%= (instance.width == 'half') ? ' selected' : '' %>><?php _e( 'Half', 'happyforms' ); ?></option>
			<option value="third"<%= (instance.width == 'third') ? ' selected' : '' %>><?php _e( 'Third', 'happyforms' ); ?></option>
			<option value="quarter"<%= (instance.width == 'quarter') ? ' selected' : '' %>><?php _e( 'Quarter', 'happyforms' ); ?></option>
		</select>
	</p>
	<p class="width-options" style="display: none">
		<label>
			<input type="checkbox" class="checkbox apply-all-check" value="" data-apply-to="width" /> <?php _e( 'Apply to all fields', 'happyforms' ); ?>
		</label>
	</p>

	<?php do_action( 'happyforms_part_customize_rich_text_after_advanced_options' ); ?>

	<p>
		<label for="<%= instance.id %>_css_class"><?php _e( 'CSS classes', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_css_class" class="widefat title" value="<%= instance.css_class %>" data-bind="css_class" />
	</p>

	<div class="happyforms-part-logic-wrap">
		<div class="happyforms-logic-view">
			<?php happyforms_customize_part_logic(); ?>
		</div>
	</div>

	<?php happyforms_customize_part_footer(); ?>
</script>
