
<script type="text/template" id="happyforms-customize-scale-template">
	<?php include( happyforms_get_core_folder() . '/templates/customize-form-part-header.php' ); ?>
	<p>
		<label for="<%= instance.id %>_title"><?php _e( 'Label', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_title" class="widefat title" value="<%= instance.label %>" data-bind="label" />
	</p>
	<p>
		<label for="<%= instance.id %>_description"><?php _e( 'Hint', 'happyforms' ); ?></label>
		<textarea id="<%= instance.id %>_description" data-bind="description"><%= instance.description %></textarea>
	</p>

	<?php do_action( 'happyforms_part_customize_scale_before_options' ); ?>

	<div class="min-max-wrapper">
		<p>
			<label for="<%= instance.id %>_max_value"><?php _e( 'Min number', 'happyforms' ); ?></label>
			<input type="number" id="<%= instance.id %>_max_value" class="widefat title" value="<%= instance.min_value %>" data-bind="min_value" />
		</p>
		<p>
			<label for="<%= instance.id %>_max_value"><?php _e( 'Max number', 'happyforms' ); ?></label>
			<input type="number" id="<%= instance.id %>_max_value" class="widefat title" value="<%= instance.max_value %>" data-bind="max_value" />
		</p>
	</div>
	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.required ) { %>checked="checked"<% } %> data-bind="required" /> <?php _e( 'Require an answer', 'happyforms' ); ?>
		</label>
	</p>

	<?php do_action( 'happyforms_part_customize_scale_after_options' ); ?>

	<?php do_action( 'happyforms_part_customize_scale_before_advanced_options' ); ?>

	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.multiple ) { %>checked="checked"<% } %> data-bind="multiple" /> <?php _e( 'Allow range select', 'happyforms' ); ?>
		</label>
	</p>
	<div class="happyforms-nested-settings" data-trigger="multiple" style="margin-bottom: 1em; display: <%= ( instance.multiple ) ? 'flex' : 'none' %>">
		<div class="min-max-wrapper">
			<p>
				<label for="<%= instance.id %>_default_range_from"><?php _e( 'Default min number', 'happyforms' ); ?></label>
				<input type="number" id="<%= instance.id %>_default_range_from" class="widefat title" value="<%= instance.default_range_from %>" data-bind="default_range_from" />
			</p>
			<p>
				<label for="<%= instance.id %>_default_range_to"><?php _e( 'Default max number', 'happyforms' ); ?></label>
				<input type="number" id="<%= instance.id %>_default_range_to" class="widefat title" value="<%= instance.default_range_to %>" data-bind="default_range_to" />
			</p>
		</div>
	</div>
	<p class="scale-single-options" style="display: <%= ( instance.multiple ) ? 'none' : 'block' %>">
		<label for="<%= instance.id %>_default_value"><?php _e( 'Default value', 'happyforms' ); ?></label>
		<input type="number" id="<%= instance.id %>_default_value" class="widefat title" value="<%= instance.default_value %>" data-bind="default_value" />
	</p>
	<p>
		<label for="<%= instance.id %>_min_label"><?php _e( 'Min number label', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_min_label" class="widefat title" value="<%= instance.min_label %>" data-bind="min_label" />
	</p>
	<p>
		<label for="<%= instance.id %>_max_label"><?php _e( 'Max number label', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_max_label" class="widefat title" value="<%= instance.max_label %>" data-bind="max_label" />
	</p>
	<p>
		<label for="<%= instance.id %>_step"><?php _e( 'Increments', 'happyforms' ); ?></label>
		<select id="<%= instance.id %>_step" data-bind="step" class="widefat">
			<option value="1"<%= (instance.step == '1') ? ' selected' : '' %>>1</option>
			<option value="0.1"<%= (instance.step == '0.1') ? ' selected' : '' %>>0.1</option>
			<option value="10"<%= (instance.step == '10') ? ' selected' : '' %>>10</option>
			<option value="100"<%= (instance.step == '100') ? ' selected' : '' %>>100</option>
		</select>
	</p>

	<?php do_action( 'happyforms_part_customize_scale_after_advanced_options' ); ?>

	<p>
		<label for="<%= instance.id %>_css_class"><?php _e( 'CSS classes', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_css_class" class="widefat title" value="<%= instance.css_class %>" data-bind="css_class" />
	</p>

	<div class="happyforms-part-logic-wrap">
		<div class="happyforms-logic-view">
			<?php happyforms_customize_part_logic(); ?>
		</div>
	</div>

	<?php happyforms_customize_part_footer(); ?>
</script>
