( function( $ ) {
	$( document ).on( 'change', 'select[name*=services]', function( e ) {
		var $select = $( e.target );
		var value   = $select.val();
		var $widget = $select.parents( '.inside' );

		if ( value ) {
			var $selectedService = $( '#happyforms-service-'+ value, $widget );

			if ( $selectedService.length ) {
				$( '.happyforms-service-integration', $widget ).hide();
				$selectedService.show();
			}
		} else {
			$( '.happyforms-service-integration', $widget ).hide();
		}

		$select.parents( 'form' ).trigger( 'happyforms.enable' );
	} );

	$( document ).on( 'change', 'input[class=happyforms-service-toggle]', function( e ) {
		var $checkbox  = $( e.target );
		var $container = $checkbox.parents( '.happyforms-service-integration' );

		if ( $checkbox.is( ':checked' ) ) {
			$container.addClass( 'enabled' );
		} else {
			$container.removeClass( 'enabled' );
		}
	} );

	$( document ).on( 'click', '#happyforms-service-aweber .oauth-connected a', function( e ) {
		var $link  = $( e.target );
		var $widget = $link.parents( '.authenticated' );

		$widget.removeClass( 'authenticated' );
	} );

} )( jQuery );
