<?php
$service = happyforms_get_integrations()->get_service( 'aweber' );
$credentials = $service->get_credentials();
$code_verifier = $service->generate_code_verifier();
?>
<div id="happyforms-service-<?php echo $service->id; ?>" class="happyforms-service-integration">
	<div class="widget-content <?php if ( $service->is_connected() ) : ?>authenticated<?php endif; ?>">
		<div class="oauth-flow">
			<input type="hidden" name="credentials[aweber][code_verifier]" value="<?php echo $code_verifier; ?>" />
			<?php
			happyforms_credentials_input(
				$service->id,
				'verification_code',
				__( 'Verification code', 'happyforms' ),
				''
			);
			?>
			<p>
				<a href="<?php echo $service->get_authorize_url( $code_verifier ); ?>" target="_blank"><?php _e( 'Get verification code', 'happyforms' ); ?></a>
			</p>
		</div>
		<div class="oauth-connected">
			<p>
				<?php _e( 'Successfully connected', 'happyforms' ); ?>. <a href="<?php echo $service->get_authorize_url( $code_verifier ); ?>" target="_blank"><?php _e( 'Authenticate again', 'happyforms' ); ?></a>
			</p>
		</div>
	</div>
</div>
