<?php
$service = happyforms_get_integrations()->get_service( 'paypal' );
$credentials = $service->get_credentials();
$enabled = $service->is_enabled();
?>
<div id="happyforms-service-<?php echo $service->id; ?>" class="happyforms-service-integration<?php echo ( $enabled ) ? ' enabled' : ''; ?>">
	<p>
		<label>
			<input type="checkbox" class="happyforms-service-toggle" name="credentials[paypal][enabled]" value="1" <?php checked( $enabled, true ); ?>> <?php _e( 'PayPal', 'happyforms' ); ?>
		</label>
	</p>

	<div class="nested-block">
		<div class="widget-content <?php if ( $service->is_connected() ) : ?>authenticated<?php endif; ?>">
			<input type="hidden" name="services[]" value="<?php echo $service->id; ?>">
			<?php
			happyforms_credentials_input(
				$service->id,
				'client_id',
				__( 'Client ID (live)', 'happyforms' ),
				$credentials['client_id']
			);
			?>
			<?php
			happyforms_credentials_input(
				$service->id,
				'client_secret',
				__( 'Client secret (live)', 'happyforms' ),
				$credentials['client_secret']
			);
			?>
			<?php
			happyforms_credentials_input(
				$service->id,
				'sandbox_client_id',
				__( 'Client ID (sandbox)', 'happyforms' ),
				$credentials['sandbox_client_id']
			);
			?>
			<?php
			happyforms_credentials_input(
				$service->id,
				'sandbox_client_secret',
				__( 'Client secret (sandbox)', 'happyforms' ),
				$credentials['sandbox_client_secret']
			);
			?>
			<p>
				<label>
					<?php $checked = happyforms_is_truthy( $credentials['sandbox_mode'] ); ?>
					<input type="checkbox" name="credentials[paypal][sandbox_mode]" value="1" <?php checked( $checked, true ); ?>> <?php _e( 'Use sandbox mode', 'happyforms' ); ?>
				</label>
			</p>
		</div>
	</div>
</div>
