<?php

class TTF_Product_Central_Product {

	public $account = '';
	public $id = '';
	public $menu_id = '';
	public $name = '';
	public $plugin_slug = '';
	public $url = '';
	public $version = '';
	public $page = 'ttf-updates-%s';
	public $option = 'ttf_updates_key_%s';

	public function __construct( $product_data ) {
		$product_data = wp_parse_args( $product_data, $this->get_default_metadata() );

		foreach( $product_data as $property => $value ) {
			$this->$property = $value;
		}

		$this->page = sprintf( $this->page, $this->account );
		$this->option = sprintf( $this->option, $this->account );
	}

	public function get_default_metadata() {
		$metadata = array(
			'account' => '',
			'id' => '',
			'menu_id' => '',
			'name' => '',
			'plugin_slug' => '',
			'url' => '',
			'version' => '',
		);

		return $metadata;
	}

	public function authorize( $email, $password, $domain ) {
		$endpoint = ttf_product_central_updater()->get_api_url( 'auth' );
		$response = wp_remote_get( $endpoint, array(
			'body' => array(
				'email' => $email,
				'password' => $password,
				'domain' => $domain,
				'account' => $this->account,
			),
			'timeout' => 5,
		) );

		$code = (int) wp_remote_retrieve_response_code( $response );
		$body = wp_remote_retrieve_body( $response );

		if ( ! $body ) {
			$error = new WP_Error(
				'unexpected',
				'An unexpected error occurred. Try again later.'
			);

			return $error;
		}

		$body = json_decode( $body );

		if ( ! $body->success ) {
			return new WP_Error( 'bad_credentials', 'The email address or password entered doesn\'t match our records.' );
		}

		$key = $body->data->ttf_key;
		update_option( $this->option, $key );

		return true;
	}

	public function deauthorize() {
		delete_option( $this->option );
	}

	public function is_authorized() {
		return true;
	}

	public function get_info() {
		$api_url = ttf_product_central_updater()->get_api_url( 'product' );

		$request = wp_remote_get( $api_url, array(
			'body' => array(
				'account' => $this->account,
				'product' => $this->id,
			)
		) );

		if ( is_wp_error( $request ) ) {
			return false;
		}

		$code = (int) wp_remote_retrieve_response_code( $request );

		if ( 200 !== $code ) {
			return false;
		}

		$body = json_decode( wp_remote_retrieve_body( $request ) );

		if ( ! $body->success ) {
			return false;
		}

		$info = $body->data;
		$info->download_link = $this->get_download_link();
		$info->sections = (array) $info->sections;

		$icons = isset( $info->icons ) ? (array) $info->icons : false;
		$icons = apply_filters( 'ttf_product_central_icons', $icons );

		if ( $icons ) {
			$info->icons = $icons;
		}

		$banners = isset( $info->banners ) ? (array) $info->banners : false;
		$banners = apply_filters( 'ttf_product_central_banners', $banners );

		if ( $banners ) {
			$info->banners = $banners;
		}

		if ( isset( $info->translations ) ) {
			$info->translations = (array) $info->translations;
		}

		return $info;
	}

	public function get_download_link() {
		$api_url = ttf_product_central_updater()->get_api_url( 'download' );
		$api_url = "{$api_url}/{$this->account}/{$this->id}";

		return $api_url;
	}

	public function get_update( $update_info ) {
		$update = new stdClass();
		$update->slug = $this->id;
		$update->plugin_slug = $this->plugin_slug;
		$update->new_version = $update_info->version;
		$update->url = $update_info->homepage;
		$update->package = $this->get_download_link();

		if ( isset( $update_info->tested ) ) {
			$update->tested = $update_info->tested;
		}

		if ( isset( $update_info->banners ) ) {
			$update->banners = $update_info->banners;
		}

		if ( isset( $update_info->icons ) ) {
			$update->icons = $update_info->icons;
		}

		if ( isset( $update_info->upgrade_notice ) ) {
			$update->upgrade_notice = $update_info->upgrade_notice;
		}

		return $update;
	}

}
