<div class="wrap">
	<h1><?php printf( __( 'Register', 'ttf-updates' ), $product->name ); ?></h1>

	<?php if ( $notice ) : ?>
	<div class="notice <?php echo $notice['type']; ?>">
		<p><?php echo $notice['message']; ?></p>
	</div>
	<?php endif; ?>

	<?php if ( $product->is_authorized() ) : ?>
		<p class="description"><?php _e( 'Good news! It looks like you\'ve already synced your account.', 'ttf-updates' ); ?></p>
	<?php else: ?>
		<p class="description"><?php _e( 'Please sign into your account using the same credentials you use to sign into', 'ttf-updates' ); ?> <a href="<?php echo $product->url; ?>" target="_blank"><?php echo str_replace( 'https://', '', $product->url ); ?></a>.</p>
	<?php endif; ?>

	<form action="" method="post" class="happyforms-updater-credentials">
	<?php if ( $product->is_authorized() ) : ?>
		<input type="hidden" name="action" value="ttf-updates-deauthorize" />
		<button type="submit" class="button button-primary button-hero">
			<svg aria-hidden="true" focusable="false" data-prefix="fas" data-icon="undo" class="svg-inline--fa fa-undo fa-w-16" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M212.333 224.333H12c-6.627 0-12-5.373-12-12V12C0 5.373 5.373 0 12 0h48c6.627 0 12 5.373 12 12v78.112C117.773 39.279 184.26 7.47 258.175 8.007c136.906.994 246.448 111.623 246.157 248.532C504.041 393.258 393.12 504 256.333 504c-64.089 0-122.496-24.313-166.51-64.215-5.099-4.622-5.334-12.554-.467-17.42l33.967-33.967c4.474-4.474 11.662-4.717 16.401-.525C170.76 415.336 211.58 432 256.333 432c97.268 0 176-78.716 176-176 0-97.267-78.716-176-176-176-58.496 0-110.28 28.476-142.274 72.333h98.274c6.627 0 12 5.373 12 12v48c0 6.627-5.373 12-12 12z"></path></svg>
			<?php _e( 'Reset credentials', 'ttf-updates' ); ?>
		</button>
	<?php else: ?>
		<?php wp_nonce_field( $page ); ?>
		<input type="hidden" name="action" value="ttf-updates-authorize" />
		<input type="email" name="email" value="" placeholder="<?php _e( 'Email address', 'ttf-updates' ); ?>" autofocus />
		<input type="password" name="password" placeholder="<?php _e( 'Password', 'ttf-updates' ); ?>" value="" />
		<button type="submit" class="button button-primary button-hero button-block"><?php printf( __( 'Register %s', 'ttf-updates' ), $product->name ); ?></button>
	<?php endif; ?>
	</form>
</div>
