<?php
/**
 * The page Settings.
 *
 * @since 1.0.0
 */

// Exit if accessed directly
if( !defined('ABSPATH') ) {
	exit;
}

class WCL_PerformanceCDNPage extends WCL_Page {

	/**
	 * The id of the page in the admin menu.
	 *
	 * Mainly used to navigate between pages.
	 * @see FactoryPages000_AdminPage
	 *
	 * @since 1.0.0
	 * @var string
	 */
	public $id = "performance_cdn";

	/**
	 * @var string
	 */
	public $page_parent_page = 'performance';

	/**
	 * @var string
	 */
	public $page_menu_dashicon = 'dashicons-performance';

	/**
	 * @var int
	 */
	public $page_menu_position = 20;

	public $available_for_multisite = true;

	/**
	 * @param WCL_Plugin $plugin
	 */
	public function __construct(WCL_Plugin $plugin)
	{
		$this->menu_title = __('CDN', 'clearfy');

		parent::__construct($plugin);

		$this->plugin = $plugin;
	}

	/**
	 * Permalinks options.
	 *
	 * @return mixed[]
	 * @since 1.0.0
	 */
	public function getPageOptions()
	{
		$options = array();

		$options[] = array(
			'type' => 'html',
			'html' => '<div class="wbcr-factory-page-group-header">' . __('<strong>CDN general settings</strong>.', 'clearfy') . '<p>' . __('General cdn settings.', 'clearfy') . '</p></div>'
		);

		$options[] = array(
			'type' => 'checkbox',
			'way' => 'buttons',
			'name' => 'enable_cdn',
			'title' => __('Enable CDN', 'clearfy'),
			'layout' => array('hint-type' => 'icon', 'hint-icon-color' => 'grey'),
			'hint' => __('Enable CDN.', 'clearfy'),
			'default' => false
		);

		$options[] = array(
			'type' => 'textbox',
			'name' => 'cdn_cname',
			'title' => __('Specify the CNAME(s) below', 'clearfy'),
			'layout' => array('hint-type' => 'icon', 'hint-icon-color' => 'grey'),
			'hint' => __('All URLs of static files (CSS, JS, images) will be rewritten to the CNAME(s) you provide.', 'clearfy'),
			'default' => ''
		);
		$options[] = [
			'type' => 'dropdown',
			'way' => 'buttons',
			'name' => 'cdn_zone',
			'data' => [
				['all', __('All files', 'clearfy')],
				['css_and_js', __('CSS ans Javascripts', 'clearfy')],
				['js', __('Javascripts', 'clearfy')],
				['css', __('CSS', 'clearfy')],
				['images', __('Images', 'clearfy')],
			],
			'title' => __('File types', 'clearfy'),
			'hint' => __('Types of files that will be uploaded through the provider you have installed cdn.', 'clearfy'),
			//'layout' => array('hint-type' => 'icon', 'hint-icon-color' => 'grey'),
			'default' => 'all'
		];
		$options[] = array(
			'type' => 'html',
			'html' => '<div class="wbcr-factory-page-group-header">' . __('<strong>Bunny CDN settings</strong>.', 'clearfy') . '<p>' . __('These settings are needed to integrate with Bunny CDN so that you can automatically purge cache.', 'clearfy') . '</p></div>'
		);
		$options[] = array(
			'type' => 'textbox',
			'name' => 'bunny_cdn_api_key',
			'title' => __('Bunny CDN API Key (Optional):', 'clearfy'),
			//'layout' => array('hint-type' => 'icon', 'hint-icon-color' => 'grey'),
			'hint' => sprintf(__('The <a href="%s" target="_blank">bunny.net</a> API key to manage the zone. Adding this will enable features such as cache purging. Read more about how to get a API Key in the <a href="%s" target="_blank">documentation</a>.', 'clearfy'), 'https://bunnycdn.com/?ref=gem0b5av1a', 'https://clearfy.pro/docs/cdn-setup/'),
			'default' => ''
		);
		$options[] = array(
			'type' => 'html',
			'html' => '<div class="wbcr-factory-page-group-header">' . __('<strong>Cdn77 settings</strong>.', 'clearfy') . '<p>' . __('These settings are needed to integrate with cdn77.com so that you can automatically purge cache.', 'clearfy') . '</p></div>'
		);
		$options[] = array(
			'type' => 'textbox',
			'name' => 'cdn77_api_login',
			'title' => __('Login (Optional):', 'clearfy'),
			//'layout' => array('hint-type' => 'icon', 'hint-icon-color' => 'grey'),
			'hint' => sprintf(__('Login in cdn77.com. Adding this will enable features such as cache purging. Read more about how to get a login in the <a href="%s" target="_blank">documentation</a>.', 'clearfy'), 'https://clearfy.pro/docs/cdn-setup/'),
			'default' => ''
		);
		$options[] = array(
			'type' => 'textbox',
			'name' => 'cdn77_api_cdnid',
			'title' => __('CDN ID (Optional):', 'clearfy'),
			//'layout' => array('hint-type' => 'icon', 'hint-icon-color' => 'grey'),
			'hint' => sprintf(__('ID in cdn77.com. Adding this will enable features such as cache purging. Read more about how to get a ID in the <a href="%s" target="_blank">documentation</a>.', 'clearfy'), 'https://clearfy.pro/docs/cdn-setup/'),
			'default' => ''
		);
		$options[] = array(
			'type' => 'textbox',
			'name' => 'cdn77_api_key',
			'title' => __('API Key (Optional):', 'clearfy'),
			//'layout' => array('hint-type' => 'icon', 'hint-icon-color' => 'grey'),
			'hint' => sprintf(__('API Key in cdn77.com. Adding this will enable features such as cache purging. Read more about how to get a API Key in the <a href="%s" target="_blank">documentation</a>.', 'clearfy'), 'https://clearfy.pro/docs/cdn-setup/'),
			'default' => ''
		);

		$form_options = array();

		$form_options[] = array(
			'type' => 'form-group',
			'items' => $options,
			//'cssClass' => 'postbox'
		);

		return apply_filters('wclearfy/performance/cdn_form', $form_options, $this);
	}
}
