<?php
/**
 * The page Settings.
 *
 * @since 1.0.0
 */

// Exit if accessed directly
if( !defined('ABSPATH') ) {
	exit;
}

class WCL_PerformancePreloadPage extends WCL_Page {

	/**
	 * The id of the page in the admin menu.
	 *
	 * Mainly used to navigate between pages.
	 * @see FactoryPages000_AdminPage
	 *
	 * @since 1.0.0
	 * @var string
	 */
	public $id = "performance_preload";

	/**
	 * @var string
	 */
	public $page_parent_page = 'performance';

	/**
	 * @var string
	 */
	public $page_menu_dashicon = 'dashicons-performance';

	/**
	 * @var int
	 */
	public $page_menu_position = 20;

	public $available_for_multisite = true;

	/**
	 * @param WCL_Plugin $plugin
	 */
	public function __construct(WCL_Plugin $plugin)
	{
		$this->menu_title = __('Preload', 'clearfy');

		parent::__construct($plugin);

		$this->plugin = $plugin;
	}

	/**
	 * Permalinks options.
	 *
	 * @return mixed[]
	 * @since 1.0.0
	 */
	public function getPageOptions()
	{
		$options = array();

		$options[] = array(
			'type' => 'html',
			'html' => '<div class="wbcr-factory-page-group-header">' . __('<strong>Prefetch DNS Requests</strong>.', 'clearfy') . '<p>' . __('DNS prefetching can make external files load faster, especially on mobile networks.', 'clearfy') . '</p></div>'
		);

		$options[] = array(
			'type' => 'textarea',
			'name' => 'urls_prefetch',
			'title' => __('URLs to prefetch', 'clearfy'),
			'htmlAttrs' => ['placeholder' => '//example.com'],
			'hint' => __('Specify external hosts to be prefetched (no http:, one per line)', 'clearfy'),
			'default' => ''
		);

		$options[] = array(
			'type' => 'html',
			'html' => '<div class="wbcr-factory-page-group-header">' . __('<strong>Preload Fonts</strong>.', 'clearfy') . '<p>' . __('Improves performance by helping browsers discover fonts in CSS files.', 'clearfy') . '</p></div>'
		);

		$options[] = array(
			'type' => 'textarea',
			'name' => 'preload_fonts',
			'title' => __('Fonts to preload', 'clearfy'),
			'htmlAttrs' => ['placeholder' => '/wp-content/themes/your-theme/assets/fonts/font-file.woff'],
			'hint' => __('Specify urls of the font files to be preloaded (one per line). Fonts must be hosted on your own domain, or the domain you have specified on the CDN tab. The domain part of the URL will be stripped automatically.
Allowed font extensions: otf, ttf, svg, woff, woff2.', 'clearfy'),
			'default' => ''
		);

		$form_options = array();

		$form_options[] = array(
			'type' => 'form-group',
			'items' => $options,
			//'cssClass' => 'postbox'
		);

		return apply_filters('wclearfy/performance/preload_form', $form_options, $this);
	}
}
