<?php
/**
 * Boot
 *
 * @author        Alexander Kovalev <alex.kovalevv@gmail.com>
 * @copyright (c) 14.11.2019, Webcraftic
 * @version       1.0
 */

add_action('plugins_loaded', function () {
	if( defined('WCL_PLUGIN_ACTIVE') ) {
		if( is_admin() && version_compare(WCL_PLUGIN_VERSION, '1.6.8', '<') ) {
			$clearfy_compat_func = function () {
				$error = __('Premium package for Clearfy requires the installation of the free version 1.6.8 or higher. Please update the Clearfy plugin to version 1.6.8 or higher to continue.', 'clearfy');
				echo '<div class="notice notice-error"><p>' . $error . '</p></div>';
			};

			add_action('admin_notices', $clearfy_compat_func);
			add_action('network_admin_notices', $clearfy_compat_func);
		}

		if( WCL_Plugin::app()->isActivateComponent('minify_and_combine') ) {
			require_once WCLP_PLUGIN_DIR . '/includes/class-move-scripts-to-footer.php';
		}

		if( is_admin() ) {
			WCL_Plugin::app()->registerPage('WCL_PerformanceCDNPage', WCLP_PLUGIN_DIR . '/admin/pages/class-pages-performance-cdn.php');
			WCL_Plugin::app()->registerPage('WCL_PerformancePreloadPage', WCLP_PLUGIN_DIR . '/admin/pages/class-pages-performance-preload.php');
		}
		require_once WCLP_PLUGIN_DIR . '/includes/class-cdn.php';
		$cdn = new WCL_CDN();
		$cdn->register_hooks();

		require_once WCLP_PLUGIN_DIR . '/includes/class-preload.php';
		new WCL_Preload();
	}
}, 20);

