<?php
/**
 * Plugin Name: Webcraftic Clearfy package
 * Description: This is the package of the components of the Clearfy plugin. If you use the Clearfy plugin, please do not delete this plugin!
 * Author: Webcraftic <wordpress.webraftic@gmail.com>
 * Version: 1.2.6
 * Text Domain: clearfy
 * Domain Path: /languages/
 * Author URI: https://clearfy.pro
 */

// Exit if accessed directly
if( !defined('ABSPATH') ) {
	exit;
}

if( defined('WCLP_PLUGIN_ACTIVE') ) {
	return;
}

define('WCLP_PLUGIN_ACTIVE', true);

define('WCLP_PLUGIN_FILE', __FILE__);
define('WCLP_PLUGIN_DIR', dirname(__FILE__));
define('WCLP_PLUGIN_BASE', plugin_basename(__FILE__));
define('WCLP_PLUGIN_URL', plugins_url(null, __FILE__));

require_once WCLP_PLUGIN_DIR . '/boot.php';
require_once WCLP_PLUGIN_DIR . '/plugins/cache-premium/cache-premium.php';
require_once WCLP_PLUGIN_DIR . '/plugins/assets-manager-premium/assets-manager-premium.php';
require_once WCLP_PLUGIN_DIR . '/plugins/update-manager-premium/updates-manager-premium.php';
require_once WCLP_PLUGIN_DIR . '/plugins/seo-friendly-images-premium/seo-friendly-images-premium.php';
require_once WCLP_PLUGIN_DIR . '/plugins/hide-my-wp/hide-my-wp.php';
require_once WCLP_PLUGIN_DIR . '/plugins/async-javascript/async-javascript.php';

if( !function_exists('wclp_uninstall') ) {
	function wclp_uninstall()
	{
		whmp_uninstall();
	}

	register_uninstall_hook(__FILE__, 'wclp_uninstall');
}

if( !function_exists('wclp_activation') ) {
	function wclp_activation()
	{
		if( !(is_plugin_active('clearfy/clearfy.php') || is_plugin_active('wp-plugin-clearfy/clearfy.php')) ) {
			wp_die(sprintf("The Clearfy Premium Package plugin has stopped. <b>To continue working you need to install and activate the <a href='%s' rel='noopener' target='_blank'>Clearfy free</a> plugin.</b><br><br><a href='%s' rel='noopener'>Go back to plugins</a>", 'https://wordpress.org/plugins/clearfy/', admin_url('plugins.php')));
		}

		whmp_activation();
		wclearfy_cache_pro_activate();
	}

	register_activation_hook(__FILE__, 'wclp_activation');
}

if( !function_exists('wclp_deactivation') ) {
	function wclp_deactivation()
	{
		if( !(is_plugin_active('clearfy/clearfy.php') || is_plugin_active('wp-plugin-clearfy/clearfy.php')) ) {
			return;
		}

		whmp_deactivation();
		wclearfy_cache_pro_deactivate();
	}

	register_deactivation_hook(__FILE__, 'wclp_deactivation');
}

