<?php

/**
 * Assets manager Premium base class
 *
 * @author        Alexander Kovalev <alex.kovalevv@gmail.com>, GitHub: https://github.com/alexkovalevv
 * @copyright (c) 01.10.2018, Webcraftic
 * @version       1.0
 */

// Exit if accessed directly
if( !defined('ABSPATH') ) {
	exit;
}

class WGNZP_Config_Assets_Manager {

	/**
	 * @param WGZ_Plugin $plugin
	 *
	 * @throws \Exception
	 */
	public function __construct($plugin)
	{
		if( !$plugin instanceof WGZ_Plugin && !$plugin instanceof WCL_Plugin ) {
			throw new \Exception('Invalid $plugin argument type passed.');
		}
		$this->plugin = $plugin;

		add_action('wam/views/safe_mode_checkbox', [$this, 'print_save_mode_checkbox']);
		add_action('wam/views/assets/handle_column/after_url', [$this, 'print_move_to_footer_fake_checkbox']);
		add_filter('wam/before_save_settings', [$this, 'filter_save_options'], 10, 2);

		remove_all_filters('wam/conditions/call_method');
		add_filter('wam/conditions/call_method', [$this, 'check_conditions_method'], 10, 4);
		add_action('wam/plugin_print_scripts', function () {
			?>
			<script type='text/javascript' src='<?php echo WGZP_PLUGIN_URL . '/assets/js/wam-assets-manager-pro.js'; ?>'></script>
			<?php
		});
	}

	/**
	 * @param $data
	 * @since  1.1.0
	 *
	 * @author Alexander Kovalev <alex.kovalevv@gmail.com>
	 */
	public function print_save_mode_checkbox($data)
	{
		?>
		<label class="wam-float-panel__checkbox  wam-tooltip  wam-tooltip--bottom" data-tooltip="<?php _e('In test mode, you can experiment with disabling unused scripts safely for your site. The resources that you disabled will be visible only to you (the administrator), and all other users will receive an unoptimized version of the site, until you remove this tick', 'gonzales') ?>.">
			<input id="js-wam-save-mode-checkbox" class="wam-float-panel__checkbox-input visually-hidden" type="checkbox"<?php checked($data['save_mode']) ?>>
			<span class="wam-float-panel__checkbox-text"><?php _e('Safe mode', 'gonzales') ?></span>
		</label>
		<?php
	}

	public function print_move_to_footer_fake_checkbox($item)
	{
		$url_parts = wp_parse_url($item['url_short']);
		$urls_prefetch = WCL_Plugin::app()->getPopulateOption('urls_prefetch');

		if( !empty($urls_prefetch) ) {
			$urls_prefetch = preg_split('/\r\n|\n|\r/', $urls_prefetch);
			$urls_prefetch = array_map(function ($value) {
				return trim(rtrim($value));
			}, $urls_prefetch);
			$urls_prefetch = array_filter($urls_prefetch, function ($value) {
				return !is_null($value) && $value !== '';
			});
		} else {
			$urls_prefetch = [];
		}
		?>
		<div>
			<p style="display: inline-block">
				<input type="checkbox" class="wam-checkbox wam-table__checkbox wam-checkbox__move-to-footer" <?php checked($item['move_to_footer']) ?>>
				<?php _e('Move to footer', 'gonzales') ?>
				<i class="wam-help-hint wam-tooltip wam-tooltip--bottom" data-tooltip="<?php _e('This function will force a script or style from the header to the footer. This can fix problems of blocking page rendering.', 'gonzales') ?>"></i>
			</p>
			<?php if( !empty($url_parts['host']) && !in_array('//' . $url_parts['host'], $urls_prefetch) ): ?>
				<p style="display: inline-block">
					<a style="color:red;text-decoration: underline;font-size:12px;" href="#" class="js-wam-add-dns-prefetch" data-nonce="<?php echo wp_create_nonce('wam_add_dns_prefetch') ?>" data-domain="//<?php echo esc_attr($url_parts['host']); ?>">
						[<?php _e('Add domain to dns prefetch list', 'gonzales') ?>]
						<i class="wam-help-hint wam-tooltip wam-tooltip--bottom" data-tooltip="<?php _e('Add external domain to dns prefetch list.', 'gonzales') ?>"></i>
					</a>
				</p>
			<?php endif; ?>
		</div>
		<?php
	}

	/**
	 * @param $settings
	 * @param $raw_updated_settings
	 *
	 * @return mixed
	 * @since  1.1.0
	 *
	 * @author Alexander Kovalev <alex.kovalevv@gmail.com>
	 */
	public function filter_save_options($settings, $raw_updated_settings)
	{
		if( !empty($raw_updated_settings['save_mode']) ) {
			$settings['save_mode'] = "true" === $raw_updated_settings['save_mode'] ? true : false;
		}

		return $settings;
	}

	/**
	 * @param $default
	 * @param $method_name
	 * @param $operator
	 * @param $value
	 *
	 * @return mixed
	 * @since  1.1.0
	 *
	 * @author Alexander Kovalev <alex.kovalevv@gmail.com>
	 */
	public function check_conditions_method($default, $method_name, $operator, $value)
	{
		require_once WGZP_PLUGIN_DIR . '/includes/class-check-conditions.php';
		$conditions = new WGNZP_Check_Conditions();
		if( method_exists($conditions, $method_name) ) {
			return $conditions->$method_name($operator, $value);
		}

		return $default;
	}
}