<?php
/**
 * Clearfy quick start options
 *
 * @author Alex Kovalev <alex.kovalevv@gmail.com>
 * @copyright (c) 03.06.2020, Webcraftic
 * @version 1.0
 */

add_filter("wbcr_clearfy_group_options", function ($options) {
	$options[] = array(
		'name' => 'ajs_enabled',
		'title' => __('Enable Async JavaScript', 'async-javascript'),
		'tags' => array('optimize_code')
	);

	$options[] = array(
		'name' => 'ajs_method',
		'title' => __('Javascript load mode', 'async-javascript'),
		'tags' => array('optimize_code'),
		'values' => ['optimize_code' => 'defer']
	);

	$options[] = array(
		'name' => 'ajs_jquery',
		'title' => __('jQuery load', 'async-javascript'),
		'tags' => array('optimize_code'),
		'values' => ['optimize_code' => 'exclude']
	);

	$options[] = array(
		'name' => 'ajs_exclusions',
		'title' => __('Exclude scripts', 'async-javascript'),
		'tags' => array()
	);

	$options[] = array(
		'name' => 'ajs_async',
		'title' => __('Scripts to async', 'async-javascript'),
		'tags' => array()
	);

	$options[] = array(
		'name' => 'ajs_defer',
		'title' => __('Scripts to defer', 'async-javascript'),
		'tags' => array()
	);

	$options[] = array(
		'name' => 'ajs_plugin_exclusions',
		'title' => __('Plugin Exclusions', 'async-javascript'),
		'tags' => array()
	);

	$options[] = array(
		'name' => 'ajs_theme_exclusions',
		'title' => __('Theme Exclusions', 'async-javascript'),
		'tags' => array()
	);

	return $options;
});