<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Страница общих настроек для этого плагина.
 *
 * @author        Artem Prihodko <webtemyk@yandex.ru>
 * @author        Alex Kovalev <alex.kovalevv@gmail.com>, Github: https://github.com/alexkovalevv
 *
 * @copyright (c) 2020 Webraftic Ltd
 */
class WAJS_SettingsPage extends WCL_Page {

	/**
	 * {@inheritDoc}
	 *
	 * @return string
	 * @since  1.0.0
	 */
	public $id = "async_javascript_settings";

	/**
	 * {@inheritDoc}
	 *
	 * @return string
	 * @since  1.0.0
	 */
	public $type = "options";

	/**
	 * {@inheritDoc}
	 *
	 * @return string
	 * @since  1.0.0
	 */
	public $page_menu_dashicon = 'dashicons-download';

	/**
	 * {@inheritDoc}
	 *
	 * @return string
	 * @since  1.0.0
	 */
	public $page_parent_page = "performance";

	/**
	 * {@inheritDoc}
	 *
	 * @var bool
	 */
	public $available_for_multisite = true;

	/**
	 * {@inheritDoc}
	 *
	 * @since  1.0.0
	 * @var bool
	 */
	public $show_right_sidebar_in_options = true;

	/**
	 * @param WCL_Plugin $plugin
	 */
	public function __construct( $plugin ) {
		$this->menu_title = __( 'Async Javascript', 'async-javascript' );
		parent::__construct( $plugin );
	}

	/**
	 * {@inheritDoc}
	 *
	 * @return string|void
	 * @since  1.0.0
	 */
	public function getPageTitle() {
		return __( 'Async Javascript', 'async-javascript' );
	}

	/**
	 *{@inheritDoc}
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function assets( $scripts, $styles ) {
		$this->scripts->request( [
			'control.list',
		], 'bootstrap' );

		$this->styles->request( [
			'control.list',
		], 'bootstrap' );

		$this->styles->add( WAJS_PLUGIN_URL . '/admin/assets/css/ajs-form.css' );

		parent::assets( $scripts, $styles );


	}

	/**
	 * {@inheritDoc}
	 *
	 * @return mixed[]
	 * @since 1.0.0
	 */
	public function getPageOptions() {
		$plugins           = [];
		$installed_plugins = get_plugins();
		foreach ( $installed_plugins as $key => $plugin ) {
			$tmp = explode( '/', $key );
			if ( isset( $tmp[0] ) && count( $tmp ) >= 2 ) {
				$slug      = $tmp[0];
				$plugins[] = [ $slug, $plugin['Name'] ];
			} else {
				break;
			}
		}

		$themes           = [];
		$installed_themes = wp_get_themes();
		foreach ( $installed_themes as $key => $theme ) {
			$themes[] = [ $key, $theme ];
		}

		$options = [];

		$options[] = [
			'type' => 'html',
			'html' => '<div class="wbcr-factory-page-group-header"><strong>' . __( 'Basic settings of Async JavaScript', 'async-javascript' ) . '</strong><p>' . __( 'Enabling/disabling Async JavaScript, as well as basic operating mode settings', 'async-javascript' ) . '</p></div>'
		];

		$options[] = [
			'type'    => 'checkbox',
			'way'     => 'buttons',
			'name'    => 'ajs_enabled',
			'title'   => __( 'Enable Async JavaScript', 'async-javascript' ),
			'layout'  => [ 'hint-type' => 'icon', 'hint-icon-color' => 'red' ],
			'hint'    => __( 'Enabling / disabling Async JavaScript', 'async-javascript' ),
			'default' => false
		];

		$options[] = [
			'type'    => 'dropdown',
			'way'     => 'buttons',
			'name'    => 'ajs_method',
			'title'   => __( 'Javascript load mode', 'async-javascript' ),
			'data'    => [
				[ 'async', __( 'Async', 'async-javascript' ) ],
				[ 'defer', __( 'Defer', 'async-javascript' ) ],
			],
			'default' => 'async',
			'layout'  => [ 'hint-type' => 'icon', 'hint-icon-color' => 'grey' ],
			'hint'    => __( "Select the method that you wish to enable.", 'async-javascript' )
		];

		$options[] = [
			'type'    => 'dropdown',
			'way'     => 'buttons',
			'name'    => 'ajs_jquery',
			'title'   => __( 'jQuery load', 'async-javascript' ),
			'data'    => [
				[ 'async', __( 'Async', 'async-javascript' ) ],
				[ 'defer', __( 'Defer', 'async-javascript' ) ],
				[ 'exclude', __( 'Exclude', 'async-javascript' ) ],
			],
			'default' => 'exclude',
			'layout'  => [ 'hint-type' => 'icon', 'hint-icon-color' => 'grey' ],
			'hint'    => __( "Often if jQuery is loaded with async or defer it can break some jQuery functions, specifically inline scripts which require jQuery to be loaded before the scripts are run. Sometimes choosing a different method (async or defer) will work, otherwise it may be necessary to exclude jQuery from having async or defer applied.", 'async-javascript' )
		];

		$options[] = [
			'type' => 'html',
			'html' => '<div class="wbcr-factory-page-group-header"><strong>' . __( 'Exclusions for Async JavaScript', 'async-javascript' ) . '</strong><p>' . __( 'Scripts, plugins, and themes that should not be handled by the Async Javascript component', 'async-javascript' ) . '</p></div>'
		];

		$options[] = [
			'type'    => 'textarea',
			'name'    => 'ajs_exclusions',
			'title'   => __( 'Exclude scripts', 'async-javascript' ),
			'hint'    => __( 'A comma-separated list of scripts you want to exclude, for example \'whatever.js, another.js\' (without the quotes) to exclude those scripts', 'async-javascript' ),
			'default' => ''
		];

		$options[] = [
			'type'    => 'textarea',
			'name'    => 'ajs_async',
			'title'   => __( 'Scripts to async', 'async-javascript' ),
			'hint'    => __( 'Please list any scripts which you would like to apply the \'async\' attribute to. (comma seperated list eg: whatever.js, another.js)', 'async-javascript' ),
			'default' => ''
		];

		$options[] = [
			'type'    => 'textarea',
			'name'    => 'ajs_defer',
			'title'   => __( 'Scripts to defer', 'async-javascript' ),
			'hint'    => __( 'Please list any scripts which you would like to apply the \'defer\' attribute to. (comma seperated list eg: whatever.js, another.js)', 'async-javascript' ),
			'default' => ''
		];

		$options[] = [
			'type'     => 'list',
			'way'      => 'checklist',
			'name'     => 'ajs_plugin_exclusions',
			'title'    => __( 'Plugin Exclusions', 'async-javascript' ),
			'data'     => $plugins,
			'layout'   => [ 'hint-type' => 'icon', 'hint-icon-color' => 'grey' ],
			'hint'     => __( 'Select one or more plugins. Scripts contained within the plugin will not have async/defer applied.<br><br>' . 'Please Note: This will exclude any JavaScript files which are contained within the files of the selected Plugin(s). External JavaScripts loaded by the selected Plugin(s) are not affected.<br><br>
				 For Example: If a plugin is installed in path /wp-content/plugins/some-plugin/ then and JavaScripts contained within this path will be excluded. If the plugin loads a JavaScript which is countained elsewhere then the Global Method will be used (ie async or defer)', 'async-javascript' ),
			'default'  => '',
			'cssClass' => 'wbcr_clearfy_ajs_multiple_list',
		];

		$options[] = [
			'type'     => 'list',
			'way'      => 'checklist',
			'name'     => 'ajs_theme_exclusions',
			'title'    => __( 'Theme Exclusions', 'async-javascript' ),
			'data'     => $themes,
			'layout'   => [ 'hint-type' => 'icon', 'hint-icon-color' => 'grey' ],
			'hint'     => __( 'Select one or more themes. Scripts contained within the theme will not have async/defer applied.<br><br>' . 'Please Note: This will exclude any JavaScript files which are contained within the files of the selected Theme(s). External JavaScripts loaded by the selected Theme(s) are not affected.<br><br>
				 For Example: If a theme is installed in path /wp-content/themes/some-theme/ then and JavaScripts contained within this path will be excluded. If the theme loads a JavaScript which is countained elsewhere then the Global Method will be used (ie async or defer)', 'async-javascript' ),
			'default'  => '',
			'cssClass' => 'wbcr_clearfy_ajs_multiple_list',
		];

		$formOptions   = [];
		$formOptions[] = [
			'type'  => 'form-group',
			'items' => $options
		];

		return $formOptions;
	}
}