<?php
/**
 * Plugin Name: Clearfy Async Javascript
 * Plugin URI: https://clearfy.pro
 * Description: Plugin for async javascript load
 * Author: Webcraftic <wordpress.webraftic@gmail.com>
 * Version: 1.0.0
 * Text Domain: async-javascript
 * Domain Path: /languages/
 * Author URI: https://clearfy.pro
 */

// Выход при непосредственном доступе
if( !defined('ABSPATH') ) {
	exit;
}

if( !function_exists('wajs_premium_load') ) {
	function wajs_premium_load()
	{
		if( !defined('WCL_PLUGIN_ACTIVE') || defined('WCL_PLUGIN_THROW_ERROR') ) {
			return;
		}

		if( !WCL_Plugin::app()->isActivateComponent('async_js') ) {
			return;
		}

		if( version_compare(WCL_PLUGIN_VERSION, '1.6.4', '<') ) {
			return;
		}

		// Устанавливаем контстанту, что плагин уже используется
		define('WAJS_PLUGIN_ACTIVE', true);

		// Устанавливаем контстанту, что плагин уже используется
		define('WAJS_PLUGIN_VERSION', '1.1.0');

		// Директория плагина
		define('WAJS_PLUGIN_DIR', dirname(__FILE__));

		// Относительный путь к плагину
		define('WAJS_PLUGIN_BASE', plugin_basename(__FILE__));

		// Ссылка к директории плагина
		define('WAJS_PLUGIN_URL', plugins_url(null, __FILE__));

		// Global scripts
		// ---------------------------------------------------------
		if( !wp_doing_ajax() && !wp_doing_cron() ) {
			require(WAJS_PLUGIN_DIR . '/includes/classes/class-configurate-async-javascript.php');
			try {
				new WAJS_Configurate(WCL_Plugin::app());
			} catch( Exception $e ) {
				// nothing
			}
		}

		// Admin scripts
		// ---------------------------------------------------------
		if( is_admin() ) {
			require(WAJS_PLUGIN_DIR . '/admin/boot.php');

			$admin_path = WAJS_PLUGIN_DIR . '/admin/pages';
			WCL_Plugin::app()->registerPage('WAJS_SettingsPage', $admin_path . '/class-pages-settings.php');
		}
	}

	add_action('plugins_loaded', 'wajs_premium_load', 20);

	/**.
	 * Очищает данные плагина, при удалении плагина
	 *
	 * @author Alexander Kovalev <alex.kovalevv@gmail.com>
	 * @since  1.1.0
	 */
	function wajs_premium_uninstall()
	{
		//global $wpdb;
		//$wpdb->query( "DELETE FROM {$wpdb->prefix}options WHERE option_name LIKE 'wbcr_ajs_%';" );
	}

	if( defined('WCLP_PLUGIN_ACTIVE') ) {
		$wajs_activation_file = WCLP_PLUGIN_FILE;
	} else {
		$wajs_activation_file = __FILE__;
	}
	register_uninstall_hook($wajs_activation_file, 'wajs_premium_uninstall');
}
