<?php
/**
 * The page Settings.
 *
 * @since 1.0.0
 */

// Exit if accessed directly
if( !defined('ABSPATH') ) {
	exit;
}

class WCL_CacheProPage extends WCL_CachePage {


	protected $errors = [
		98 => "<label>.htaccess was not found</label> <a target='_blank' href='http://www.wpfastestcache.com/warnings/htaccess-was-not-found/'>Read More</a>",
		99 => "define('WP_CACHE', true); is needed to be added into wp-config.php",
		100 => "You have to set <strong><u><a href=" . "'/wp-admin/options-permalink.php'>permalinks</a></u></strong>",
		101 => "Fast Velocity Minify needs to be deactivated",
		102 => 'Far Future Expiration Plugin needs to be deactivated',
		103 => "SG Optimizer needs to be deactived",
		104 => "AdRotate needs to be deactived",
		105 => "MobilePress needs to be deactived",
		106 => "Speed Booster Pack needs to be deactived",
		107 => "WP Performance Score Booster needs to be deactivated<br>This plugin has aldready Gzip, Leverage Browser Caching features",
		109 => "Check and Enable GZIP compression needs to be deactivated<br>This plugin has aldready Gzip feature",
		110 => "GZippy needs to be deactivated<br>This plugin has aldready Gzip feature",
		111 => "GZip Ninja Speed Compression needs to be deactivated<br>This plugin has aldready Gzip feature",
		112 => "WordPress Gzip Compression needs to be deactivated<br>This plugin has aldready Gzip feature",
		113 => "GZIP Output needs to be deactivated<br>This plugin has aldready Gzip feature",
		114 => "Head Cleaner needs to be deactivated",
		115 => "Far Future Expiration Plugin needs to be deactivated",
	];


	/**
	 * We register notifications for some actions
	 *
	 * @param                        $notices
	 * @param \Wbcr_Factory000_Plugin $plugin
	 *
	 * @return array
	 * @see libs\factory\pages\themplates\FactoryPages000_ImpressiveThemplate
	 */
	public function getActionNotices($notices)
	{

		$notices[] = [
			'conditions' => [
				'wclearfy-cache-cleared' => 1
			],
			'type' => 'success',
			'message' => 'Cache has been cleared!'
		];

		foreach($this->errors as $key => $error_message) {
			$notices[] = [
				'conditions' => [
					'wclearfy-cache-error' => $key
				],
				'type' => 'danger',
				'message' => $error_message
			];
		}

		return $notices;
	}

	public function afterFormSave()
	{
		try {
			WCL_Cache_Helpers::modifyHtaccess();
		} catch( Exception $e ) {
			if( !empty($e->getCode()) && isset($this->errors[$e->getCode()]) ) {
				$this->redirectToAction('index', ['wclearfy-cache-error' => $e->getCode()]);
			}
		}
	}
}
