<?php
/**
 * Plugin Name: Clearfy Cache Premium
 * Plugin URI: https://clearfy.pro
 * Description: Clearfy cache premium
 * Author: Webcraftic <wordpress.webraftic@gmail.com>
 * Version: 1.0.2
 * Text Domain: cache-premium
 * Domain Path: /languages/
 * Author URI: https://clearfy.pro
 */

// Выход при непосредственном доступе
if( !defined('ABSPATH') ) {
	exit;
}

if( !function_exists('wclearfy_cache_pro_load') ) {
	function wclearfy_cache_pro_load()
	{
		if( !defined('WCL_PLUGIN_ACTIVE') || defined('WCL_PLUGIN_THROW_ERROR') ) {
			return;
		}

		if( !WCL_Plugin::app()->isActivateComponent('cache') || version_compare(WCL_PLUGIN_VERSION, '1.6.4', '<') ) {
			return;
		}

		// Устанавливаем контстанту, что плагин уже используется
		define('WCLEARFY_CACHEPRO_PLUGIN_ACTIVE', true);

		// Устанавливаем контстанту, что плагин уже используется
		define('WCLEARFY_CACHEPRO_PLUGIN_VERSION', '1.0.2');

		// Директория плагина
		define('WCLEARFY_CACHEPRO_PLUGIN_DIR', dirname(__FILE__));

		// Относительный путь к плагину
		define('WCLEARFY_CACHEPRO_PLUGIN_BASE', plugin_basename(__FILE__));

		// Ссылка к директории плагина
		define('WCLEARFY_CACHEPRO_PLUGIN_URL', plugins_url(null, __FILE__));

		require_once WCLEARFY_CACHEPRO_PLUGIN_DIR . '/includes/includes/helpers.php';
		require_once WCLEARFY_CACHEPRO_PLUGIN_DIR . '/includes/cache.php';

		// Global scripts
		// ---------------------------------------------------------
		if( !is_admin() ) {
			if( WCL_Plugin::app()->getPopulateOption('enable_cache') ) {
				if( WCL_Plugin::app()->getPopulateOption('widget_cache') ) {
					require_once WCLEARFY_CACHEPRO_PLUGIN_DIR . "/includes/classes/widget-cache.php";

					WCL_WidgetCache::action();
				}
			}

			if( WCL_Plugin::app()->getPopulateOption('cache_mobile_theme') ) {
				require_once WCLEARFY_CACHEPRO_PLUGIN_DIR . '/includes/classes/mobile-cache.php';
			}
		}

		// Admin scripts
		// ---------------------------------------------------------
		if( is_admin() ) {
			require(WCLEARFY_CACHEPRO_PLUGIN_DIR . '/admin/boot.php');
			if( class_exists('WCL_CachePage') ) {
				WCL_Plugin::app()->registerPage('WCL_CacheProPage', WCLEARFY_CACHEPRO_PLUGIN_DIR . '/admin/pages/class-pages-cache.php');
			}
		}

		add_filter('wbcr/clearfy/adminbar_menu_items', function ($menu_items) {
			$menu_items['clearfy-clear-all-cache'] = [
				'id' => 'clearfy-clear-all-cache',
				'title' => '<span class="dashicons dashicons-update"></span> ' . __('Clear all cache', 'clearfy'),
				'href' => add_query_arg('wclearfy_cache_delete', '1')
				//'href' => WCL_Plugin::app()->getPluginPageUrl('cache', ['action' => 'delete-cache'])
			];

			return $menu_items;
		});
	}

	add_action('plugins_loaded', 'wclearfy_cache_pro_load', 20);

	/**
	 * Function is performed when the parent plugin Robin image optimizer is activated.
	 *
	 * @author Alexander Kovalev <alex.kovalevv@gmail.com>
	 * @since  1.1.0
	 */
	function wclearfy_cache_pro_activate()
	{
		// Директория плагина
		define('WCLEARFY_CACHEPRO_PLUGIN_DIR', dirname(__FILE__));

		require_once WCLEARFY_CACHEPRO_PLUGIN_DIR . '/includes/cache.php';
		try {
			WCL_Cache::activate();
		} catch( Exception $e ) {
			//nothing
		}
	}

	/**
	 * Function is performed when the parent plugin Robin image optimizer is deactivated.
	 *
	 * @author Alexander Kovalev <alex.kovalevv@gmail.com>
	 * @since  1.1.0
	 */
	function wclearfy_cache_pro_deactivate()
	{
		// Директория плагина
		define('WCLEARFY_CACHEPRO_PLUGIN_DIR', dirname(__FILE__));

		require_once WCLEARFY_CACHEPRO_PLUGIN_DIR . '/includes/cache.php';
		try {
			WCL_Cache::deactivate();
		} catch( Exception $e ) {
			//nothing
		}
	}

	/**.
	 * Очищает данные плагина, при удалении плагина
	 *
	 * @author Alexander Kovalev <alex.kovalevv@gmail.com>
	 * @since  1.1.0
	 */
	function wclearfy_cache_pro_uninstall()
	{
		//WCL_Cache::activate();
		//nothing
	}

	if( defined('WCLP_PLUGIN_ACTIVE') ) {
		$wclearfy_cache_pro_activation_file = WCLP_PLUGIN_FILE;
	} else {
		$wclearfy_cache_pro_activation_file = __FILE__;
	}
	register_uninstall_hook($wclearfy_cache_pro_activation_file, 'wclearfy_cache_pro_uninstall');
}
