<?php

add_filter( 'themerain_customizer', function() {

	// General
	$sections[] = array(
		'label'    => 'General',
		'controls' => array(
			array(
				'label'    => 'Enable AJAX',
				'id'       => 'enable_ajax',
				'std'      => 1,
				'type'     => 'checkbox'
			),
			array(
				'label'    => 'Navigation Subtitle',
				'id'       => 'navigation_subtitle',
				'std'      => esc_html__( 'Next Up', 'themerain' ),
				'type'     => 'text'
			)
		)
	);

	// Header
	$sections[] = array(
		'label'    => 'Header',
		'controls' => array(
			array(
				'label'    => 'Logo Dark',
				'id'       => 'themerain_logo',
				'type'     => 'image'
			),
			array(
				'label'    => 'Logo Light',
				'id'       => 'themerain_logo_light',
				'type'     => 'image'
			),
			array(
				'label'    => 'Logo Image Width (px)',
				'id'       => 'themerain_logo_width',
				'type'     => 'number'
			),
			array(
				'label'    => 'Logo SVG',
				'id'       => 'themerain_logo_svg',
				'type'     => 'textarea'
			),
			array(
				'label'    => 'Twitter',
				'id'       => 'themerain_social_twitter',
				'type'     => 'text'
			),
			array(
				'label'    => 'Facebook',
				'id'       => 'themerain_social_facebook',
				'type'     => 'text'
			),
			array(
				'label'    => 'YouTube',
				'id'       => 'themerain_social_youtube',
				'type'     => 'text'
			),
			array(
				'label'    => 'Instagram',
				'id'       => 'themerain_social_instagram',
				'type'     => 'text'
			),
			array(
				'label'    => 'Behance',
				'id'       => 'themerain_social_behance',
				'type'     => 'text'
			),
			array(
				'label'    => 'Dribbble',
				'id'       => 'themerain_social_dribbble',
				'type'     => 'text'
			),
			array(
				'label'    => 'Vimeo',
				'id'       => 'themerain_social_vimeo',
				'type'     => 'text'
			),
			array(
				'label'    => 'Telegram',
				'id'       => 'social_telegram',
				'type'     => 'text'
			),
			array(
				'label'    => 'TikTok',
				'id'       => 'social_tiktok',
				'type'     => 'text'
			),
			array(
				'label'    => 'Pinterest',
				'id'       => 'themerain_social_pinterest',
				'type'     => 'text'
			),
			array(
				'label'    => 'LinkedIn',
				'id'       => 'themerain_social_linkedin',
				'type'     => 'text'
			),
			array(
				'label'    => 'VK',
				'id'       => 'themerain_social_vk',
				'type'     => 'text'
			)
		)
	);

	// Footer
	$sections[] = array(
		'label'    => 'Footer',
		'controls' => array(
			array(
				'label'    => 'First Column',
				'id'       => 'themerain_footer_1',
				'type'     => 'textarea'
			),
			array(
				'label'    => 'Second Column',
				'id'       => 'themerain_footer_2',
				'type'     => 'textarea'
			)
		)
	);

	// Blog
	$sections[] = array(
		'label'    => 'Blog',
		'controls' => array(
			array(
				'label'    => 'Default style',
				'id'       => 'blog_default_style',
				'type'     => 'select',
				'std'      => 'list',
				'choices'  => array(
					'list'   => 'List',
					'grid'   => 'Grid',
					'split'  => 'Split',
					'wide'   => 'Wide'
				)
			),
			array(
				'label'    => 'Archive style',
				'id'       => 'archive_style',
				'type'     => 'select',
				'std'      => 'list',
				'choices'  => array(
					'list'  => 'List',
					'grid'  => 'Grid',
					'split' => 'Split',
					'wide'  => 'Wide'
				)
			)
		)
	);

	// Portfolio
	$sections[] = array(
		'label'    => 'Portfolio',
		'controls' => array(
			array(
				'label'    => 'Video autoplay',
				'id'       => 'enable_video_autoplay',
				'type'     => 'checkbox'
			)
		)
	);

	// Colors
	$sections[] = array(
		'label'    => 'Colors',
		'controls' => array(
			array(
				'label'    => 'Global Color Scheme',
				'id'       => 'global_scheme',
				'type'     => 'select',
				'std'      => 'light',
				'choices'  => array(
					'light' => 'Light',
					'dark'  => 'Dark'
				)
			),
			array(
				'label'    => 'Text color',
				'id'       => 'global_text_color',
				'type'     => 'color',
				'output'   => [ ':root', '--text-color' ]
			),
			array(
				'label'    => 'Background color',
				'id'       => 'global_bg_color',
				'type'     => 'color',
				'output'   => [ ':root', '--bg-color' ]
			)
		)
	);

	// Typography
	$sections[] = array(
		'label'    => 'Typography',
		'controls' => array(
			array(
				'label'    => 'Primary Font',
				'id'       => 'themerain_primary_font',
				'type'     => 'fonts',
				'std'      => 'default',
				'output'   => [ ':root', '--font-primary' ],
				'choices'  => array(
					'default' => 'Inter'
				)
			),
			array(
				'label'    => 'Secondary Font',
				'id'       => 'themerain_secondary_font',
				'type'     => 'fonts',
				'std'      => 'default',
				'output'   => [ ':root', '--font-secondary' ],
				'choices'  => array(
					'default' => 'Inter'
				)
			)
		)
	);

	return $sections;
} );
