<?php

add_filter( 'themerain_meta_boxes', function() {

	// Portfolio Settings
	$sections[] = array(
		'title'    => 'Portfolio Settings',
		'id'       => 'portfolio',
		'screen'   => array( 'page' ),
		'template' => 'templates/template-portfolio.php',
		'fields'   => array(
			array(
				'label'    => 'Displayed categories',
				'id'       => 'themerain_portfolio_categories',
				'desc'     => 'Choose which of portfolio categories you want to include.',
				'type'     => 'taxonomy'
			),
			array(
				'label'    => 'Projects per page',
				'id'       => 'themerain_portfolio_per_page',
				'desc'     => 'Use "-1" if you want to display all of your projects on the page.',
				'std'      => '-1',
				'type'     => 'range',
				'range'    => array( '-1', '60', '1' )
			),
			array(
				'label'    => 'Style',
				'id'       => 'themerain_portfolio_style',
				'std'      => 'grid',
				'type'     => 'group',
				'choices'  => array(
					'slider'   => 'Slider',
					'carousel' => 'Carousel',
					'covers'   => 'Covers',
					'grid'     => 'Grid'
				)
			)
		)
	);

	// Blog Settings
	$sections[] = array(
		'title'    => 'Blog Settings',
		'id'       => 'blog',
		'screen'   => array( 'page' ),
		'template' => 'templates/template-blog.php',
		'fields'   => array(
			array(
				'label'    => 'Displayed categories',
				'id'       => 'themerain_blog_cats',
				'desc'     => 'Choose which of blog categories you want to include.',
				'type'     => 'taxonomy',
				'taxonomy' => 'category'
			),
			array(
				'label'    => 'Style',
				'id'       => 'themerain_blog_style',
				'std'      => 'list',
				'type'     => 'group',
				'choices'  => array(
					'list'  => 'List',
					'grid'  => 'Grid',
					'split' => 'Split',
					'wide'  => 'Wide'
				)
			)
		)
	);

	// Post Settings
	$sections[] = array(
		'title'    => 'Post Settings',
		'id'       => 'post',
		'screen'   => array( 'post' ),
		'fields'   => array(
			array(
				'label'    => 'Featured',
				'id'       => 'themerain_post_featured',
				'type'     => 'toggle'
			)
		)
	);

	// Project Settings
	$sections[] = array(
		'title'    => 'Project Settings',
		'id'       => 'project',
		'screen'   => array( 'project' ),
		'fields'   => array(
			array(
				'label'    => 'Video thumbnail (.mp4)',
				'id'       => 'themerain_project_thumbnail_video',
				'desc'     => 'If present, the Featured Image will be used as a video poster.',
				'type'     => 'media',
				'media'    => 'video'
			),
			array(
				'label'    => 'Secondary thumbnail',
				'id'       => 'themerain_project_thumbnail_secondary',
				'type'     => 'media'
			),
			array(
				'label'    => 'Link thumbnail to',
				'id'       => 'themerain_project_link_type',
				'std'      => 'default',
				'type'     => 'select',
				'choices'  => array(
					'default' => 'This Project (Default)',
					'image'   => 'Image',
					'video'   => 'Video',
					'url'     => 'External URL',
					'none'    => 'No URL'
				),
			),
			array(
				'label'    => 'Image',
				'id'       => 'themerain_project_link_image',
				'type'     => 'media',
				'cond'     => [ 'themerain_project_link_type', 'image' ]
			),
			array(
				'label'    => 'Video URL',
				'id'       => 'themerain_project_link_video',
				'desc'     => 'For example: https://vimeo.com/XXXXX or https://youtube.com/watch?v=XXXXX',
				'type'     => 'url',
				'cond'     => [ 'themerain_project_link_type', 'video' ]
			),
			array(
				'label'    => 'URL',
				'id'       => 'themerain_project_link_url',
				'type'     => 'url',
				'cond'     => [ 'themerain_project_link_type', 'url' ]
			),
			array(
				'label'    => 'Unique portfolio page',
				'id'       => 'themerain_project_unique_page',
				'desc'     => 'If you\'re using multiple portfolios, please choose the portfolio page where this project is included.',
				'type'     => 'pages'
			)
		)
	);

	// Hero Settings
	$sections[] = array(
		'title'    => 'Hero Settings',
		'id'       => 'hero',
		'screen'   => array( 'project', 'page' ),
		'fields'   => array(
			array(
				'label'    => 'Enable fullscreen',
				'id'       => 'themerain_hero_full',
				'type'     => 'toggle'
			),
			array(
				'label'    => 'Fixed background',
				'id'       => 'themerain_hero_fixed',
				'type'     => 'toggle'
			),
			array(
				'label'    => 'Hero image',
				'id'       => 'themerain_hero_image',
				'type'     => 'media'
			),
			array(
				'label'    => 'Hero video (mp4)',
				'id'       => 'themerain_hero_video',
				'desc'     => 'If present, the background image will be used as a video poster.',
				'type'     => 'media',
				'media'    => 'video'
			),
			array(
				'label'    => 'Media opacity',
				'id'       => 'themerain_hero_opacity',
				'std'      => '100',
				'type'     => 'range',
				'output'   => [ ':root', '--hero-opacity' ]
			),
			array(
				'label'    => 'Media opacity (after scroll)',
				'id'       => 'themerain_hero_opacity_scroll',
				'std'      => '0',
				'type'     => 'range',
				'output'   => [ '.site-hero.has-scrolled', '--hero-opacity' ],
				'cond'     => [ 'themerain_hero_fixed', '1' ],
			),
			array(
				'label'    => 'Hero title',
				'id'       => 'themerain_hero_title',
				'desc'     => 'Replaces the default title of the page.',
				'type'     => 'textarea'
			),
			array(
				'label'    => 'Hero subtitle',
				'id'       => 'themerain_hero_subtitle',
				'type'     => 'textarea'
			),
			array(
				'label'    => 'Hide title',
				'id'       => 'themerain_hero_hide_title',
				'type'     => 'toggle'
			),
			array(
				'label'    => 'Title size',
				'id'       => 'themerain_hero_title_size',
				'std'      => 'large',
				'type'     => 'group',
				'choices'  => array(
					'small'  => 'S',
					'medium' => 'M',
					'large'  => 'L',
					'huge'   => 'XL'
				)
			),
			array(
				'label'    => 'Title width',
				'id'       => 'themerain_hero_title_width',
				'std'      => 'normal',
				'type'     => 'group',
				'choices'  => array(
					'normal' => 'Normal',
					'full'   => 'Full'
				)
			),
			array(
				'label'    => 'Title alignment',
				'id'       => 'themerain_hero_title_alignment',
				'std'      => 'center',
				'type'     => 'group',
				'choices'  => array(
					'left'   => 'Left',
					'center' => 'Center',
					'right'  => 'Right'
				)
			),
			array(
				'label'    => 'Title position',
				'id'       => 'themerain_hero_title_position',
				'std'      => 'center',
				'type'     => 'group',
				'choices'  => array(
					'center' => 'Center',
					'bottom' => 'Bottom'
				)
			),
			array(
				'label'    => 'Hero skin',
				'id'       => 'themerain_hero_scheme',
				'std'      => 'global',
				'type'     => 'select',
				'cond'     => [ 'themerain_hero_fixed', '0' ],
				'choices'  => array(
					'global' => 'Use page settings',
					'light'  => 'Light',
					'dark'   => 'Dark'
				)
			),
			array(
				'label'    => 'Hero text color',
				'id'       => 'themerain_hero_text_color',
				'type'     => 'color',
				'output'   => [ '.hero-normal .site-hero, .hero-normal .header--colored', '--text-color' ],
				'cond'     => [ 'themerain_hero_fixed', '0' ]
			),
			array(
				'label'    => 'Hero background color',
				'id'       => 'themerain_hero_bg_color',
				'type'     => 'color',
				'output'   => [ '.hero-normal .site-hero, .hero-normal .header--colored', '--bg-color' ],
				'cond'     => [ 'themerain_hero_fixed', '0' ]
			)
		)
	);

	// Styling Settings
	$sections[] = array(
		'title'    => 'Styling',
		'id'       => 'styling',
		'screen'   => array( 'post', 'project', 'page' ),
		'fields'   => array(
			array(
				'label'    => 'Color scheme',
				'id'       => 'themerain_page_color',
				'std'      => 'global',
				'type'     => 'select',
				'choices'  => array(
					'global' => 'Use global settings',
					'light'  => 'Light',
					'dark'   => 'Dark'
				)
			),
			array(
				'label'    => 'Text color',
				'id'       => 'themerain_page_text_color',
				'type'     => 'color',
				'output'   => [ '.has-custom-color', '--text-color' ]
			),
			array(
				'label'    => 'Background color',
				'id'       => 'themerain_page_bg_color',
				'type'     => 'color',
				'output'   => [ '.has-custom-color', '--bg-color' ]
			)
		)
	);

	return $sections;
} );
