<?php

class MeowPro_MWL_Core {
  private $item = 'Meow Lightbox Pro';

  public function __construct() {

    // Additional functions for Pro
    add_action( 'init', array( $this, 'init' ) );

    // The Lightbox should be completely off if the request is asynchronous
    if ( MeowCommon_Helpers::is_asynchronous_request() || MeowCommon_Helpers::is_divi_builder() ) {
			return;
    }
    
    add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
  }

  function init() {
    // Common behaviors, license, update system, etc.
    new MeowCommon_Licenser( MWL_PREFIX, MWL_ENTRY, MWL_DOMAIN, $this->item, MWL_VERSION );
  }

  function enqueue_scripts() {
    // Pro CSS
    $physical_file = MWL_PATH . '/app/style-pro.min.css';
    $cache_buster = file_exists( $physical_file ) ? filemtime( $physical_file ) : MWL_VERSION;
    wp_enqueue_style( 'style-pro-css', plugins_url( '/app/style-pro.min.css', __DIR__ ), null, $cache_buster );

    // Pro JS
    $physical_file = MWL_PATH . '/app/lightbox.js';
    $cache_buster = file_exists( $physical_file ) ? filemtime( $physical_file ) : MWL_VERSION;
    wp_enqueue_script( 'mwl-core-pro-js', plugins_url( '/app/lightbox-pro.js', __DIR__ ), 
      array( 'jquery' ), $cache_buster, false );

    wp_localize_script('mwl-core-pro-js', 'mwl_map',
      array(
        'default_engine' => get_option( 'mwl_map_engine', "" ),
        'googlemaps' => array(
          'api_key' => get_option( 'mwl_googlemaps_token', '' ),
          'style' => json_decode( get_option( 'mwl_googlemaps_style', '' ) )
        ),
        'mapbox' => array(
          'api_key' => get_option( 'mwl_mapbox_token', '' ),
          'style' => json_decode( get_option( 'mwl_mapbox_style', '' ) )
        ),
        'maptiler' => array(
          'api_key' => get_option( 'mwl_maptiler_token', '' ),
          'style' => json_decode( get_option( 'mwl_maptiler_style', '' ) )
        )
      )
    );
  }
}
