const webpack = require("webpack")

module.exports = function (env, options) {
  return [
    // proConfig
    {
      mode: 'production',
      entry: './app/lightbox/main-pro.js',
      devtool: options.mode === 'production' ? false : 'source-map',
      output: {
        filename: 'lightbox-pro.js',
        jsonpFunction: 'wpJsonMwlLightboxPro',
        path: __dirname + '/app/'
      },
      module: {
        rules: [
          { test: /\.js$/, exclude: /node_modules/, loader: "babel-loader" }
        ]
      },
      plugins: [
        new webpack.ProvidePlugin({
          $: 'jquery',
          jQuery: 'jquery'
        })
      ]
    },
    // freeConfig
    {
      mode: 'production',
      entry: './app/lightbox/main.js',
      devtool: options.mode === 'production' ? false : 'source-map',
      output: {
        filename: 'lightbox.js',
        jsonpFunction: 'wpJsonMwlLightbox',
        path: __dirname + '/app/'
      },
      module: {
        rules: [
          { test: /\.js$/, exclude: /node_modules/, loader: "babel-loader" }
        ]
      },
      plugins: [
        new webpack.ProvidePlugin({
          $: 'jquery',
          jQuery: 'jquery'
        })
      ]
    }
  ]
}
