<?php
/*
=====================================================
 DLE Forum - by DLE Files Group
-----------------------------------------------------
 Author: DarkLane
-----------------------------------------------------
 https://www.templatedlefr.fr/
-----------------------------------------------------
Copyright (c) 2019-2023 TemplateDleFr
=====================================================
*/

include 'init.php';

if (!$is_logged)
{
	die ("error");
}


$id  = (isset( $_REQUEST['id'] )) ? intval( $_REQUEST['id'] ) : 0;

if (!$id OR !is_moderation(0, 0, $id, 'post_edit'))
{
	die ("error");
}

include_once ENGINE_DIR.'/forum/classes/parse_board.class.php';

$parse = new FilterParse();

$parse->filter_mode = group_value('filter');

if (!group_value('html')) $parse->safe_mode = true;
// ********************************************************************************
// EDIT POST
// ********************************************************************************
if ($_REQUEST['action'] == "edit")
{
	$row = $db->super_query("SELECT * FROM " . PREFIX . "_forum_posts WHERE pid = $id");
	
	if ($id != $row['pid']) die ("error");
	
	$topic_id = $row['topic_id'];
	
	$reason_text = $parse->decodeBBCodes($row['reason_text'], false);
	
	$upload_var = array('area'=>"editpost", 'forum_id'=>$forum_id, 'topic_id'=>$topic_id, 'post_id'=>$id);
	
	$ajax_post_id = $id;
	
	$upload_var['reply'] = "reply";
	
    $_SESSION['post_edit_tid'] = $topic_id;
    
	if ($setting['wysiwyg'] == '0')
	{
		$post_text = $parse->decodeBBCodes( $row['post_text'], false );
		
		include_once ENGINE_DIR.'/forum/editor/bbcode.php';
		
		$bb_code = str_replace ("{THEME}", $config['http_home_url']."templates/".$config['skin'], $bb_code);
	}
	
	else
	{
		$post_text = $parse->decodeBBCodes( $row['post_text'], TRUE, $setting['wysiwyg'] );
		
		include_once ENGINE_DIR.'/forum/editor/wysiwyg.php';
		
		$bb_code = $wysiwyg;
	}
	
	if($member_id['user_group'] == 1 OR $member_id['user_group'] == 2){
		$reason = "<br>{$f_lang['f_edit_reason']}: <input type=\"text\" maxlength=\"150\" class=\"forum_input\" size=\"25\" name=\"reason_text\" id=\"reason_text_{$id}\" value=\"{$reason_text}\"><br>";
	}else{
		$reason = "";
	}
	
	$buffer = <<<HTML
  <form method="post" name="forum_post_form_{$id}" id="forum_post_form_{$id}" style="margin-top:40px">
	 <div class="bb-editor-forum ignore-select">{$bb_code}</div>
	   <div class="bb-editor-forum ignore-select">
	      <textarea id="forum_post_{$id}" name="forum_post_{$id}" rows="15" cols="76" tabindex="4" class="inputbox" style="width:100%;" onclick="setNewField(this.name, document.forum_post_form_{$id})">{$post_text}</textarea>
	   </div><br>
		{$reason}                                          
	<div class="center">
	  <br /><input  class="button" title="{$f_lang['bb_t_apply']}" type=button onclick="ajax_save_post_edit('{$id}', '{$row['wysiwyg']}'); return false;" value="{$f_lang['bb_t_apply']}">
	        <input class="button" title="{$f_lang['bb_t_cancel']}" type=button onclick="ajax_cancel_post_edit('{$id}'); return false;" value="{$f_lang['bb_t_cancel']}">
	</div>
  </form>
HTML;
}

// ********************************************************************************
// SAVE POST
// ********************************************************************************
elseif ($_REQUEST['action'] == "save" && !$read_mode)
{

	if (isset($_POST['reason_text'])){
	$reason_text = $db->safesql($parse->BB_Parse($parse->process($_POST['reason_text']), false));
	}
	
    $topic_id  = intval($_SESSION['post_edit_tid']);
    
    if ($topic_id)
    {
        $topic_title      = $db->super_query("SELECT title FROM " . PREFIX . "_forum_topics WHERE tid = '{$topic_id}'");
        $_POST['img_alt'] = strip_tags(htmlspecialchars_decode($topic_title['title']));
    }
	
	if ( $setting['wysiwyg'] ) $parse->allow_code = false;

	$_POST['post_text'] = isset($_POST['post_text']) ? $_POST['post_text'] : '';
	
	$post_text = $parse->process( $_POST['post_text'] );
	
	if( $setting['wysiwyg'] ) {

		$post_text = $db->safesql( $parse->BB_Parse( $post_text ) );

	} else {

		$post_text = $db->safesql( $parse->BB_Parse( $post_text, false ) );

	}

	if( $parse->not_allowed_text ) {
		forum_msg( $lang['addnews_error'], $lang['news_err_39'], "javascript:history.go(-1)" );
	}
	
	if (!$post_text) die ("error");
	
	$post_text = auto_wrap ($post_text);
	
	if (strlen($post_text) > $setting['post_maxlen'])
	{
		die ("<script language=\"JavaScript\" type=\"text/javascript\">\n alert ('{$f_lang['post_maxlen']}');\n </script>");
	}
	
	$edit_info = ", edit_user = '{$member_id['name']}', edit_time = '{$_TIME}'";
	
	$post_text = $db->safesql($post_text);
	
	$db->query("UPDATE " . PREFIX . "_forum_posts SET post_text = '$post_text' {$edit_info}, reason_text = '{$reason_text}' WHERE pid = $id");

	/*Hide*/
	$post_text = preg_replace ("'\[hide\](.*?)\[/hide\]'si","<!--HideBegin--><div class=\"coverup\"><!--HideEBegin-->\\1<!--HideEnd--></div><!--HideEEnd-->", $post_text);
	/*End hide*/
	
	check_attachment($id, $post_text);
	
	if (stristr ($post_text, "[attachment="))
	{
		$row = $db->super_query("SELECT * FROM " . PREFIX . "_forum_posts WHERE pid = $id");
		
		$tid = $row['topic_id'];
		
		$ajax_edit_attach = TRUE;
		
		require_once ENGINE_DIR.'/forum/sources/components/attachment.php';
	}
	
	$buffer = stripslashes($post_text);
}

else die ("error");

@header("Content-type: text/css; charset=".$config['charset']);
echo $buffer;
?>